/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.activity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.activity.UIActivitiesContainer;
import org.exoplatform.social.webui.composer.UIComposer;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="classpath:groovy/social/webui/activity/UIActivitiesLoader.gtmpl", events={@EventConfig(listeners={LoadMoreActionListener.class})})
public class UIActivitiesLoader
extends UIContainer {
    private static final Log LOG = ExoLogger.getLogger(UIActivitiesLoader.class);
    private int currentLoadIndex;
    private boolean unableLoadNext;
    private UIActivitiesLoader lastActivitiesLoader;
    private ListAccess<ExoSocialActivity> activityListAccess;
    private String ownerName;
    private UIComposer.PostContext postContext;
    private boolean isExtendLoader;
    private UIActivitiesContainer activitiesContainer;
    private UIContainer extendContainer;
    private int loadingCapacity;
    private Space space;

    public static String genereateId() {
        Random random = new Random();
        return "UIActivitiesLoader_" + random.nextDouble();
    }

    public UIActivitiesLoader() {
        try {
            this.activitiesContainer = (UIActivitiesContainer)this.addChild(UIActivitiesContainer.class, null, "UIActivitiesContainer_" + ((Object)((Object)this)).hashCode());
            this.extendContainer = (UIContainer)this.addChild(UIContainer.class, null, "ExtendContainer_" + ((Object)((Object)this)).hashCode());
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
    }

    public void setActivityListAccess(ListAccess<ExoSocialActivity> activityListAccess) {
        this.activityListAccess = activityListAccess;
    }

    public void setSpace(Space space) {
        this.space = space;
    }

    public UIComposer.PostContext getPostContext() {
        return this.postContext;
    }

    public void setPostContext(UIComposer.PostContext postContext) {
        this.postContext = postContext;
    }

    public boolean isExtendLoader() {
        return this.isExtendLoader;
    }

    public void setExtendLoader(boolean extendLoader) {
        this.isExtendLoader = extendLoader;
    }

    public UIActivitiesContainer getActivitiesContainer() {
        return this.activitiesContainer;
    }

    public UIContainer getExtendContainer() {
        return this.extendContainer;
    }

    public void setLoadingCapacity(int loadingCapacity) {
        this.loadingCapacity = loadingCapacity;
    }

    public void setUnableLoadNext(boolean unableLoadNext) {
        this.unableLoadNext = unableLoadNext;
    }

    public boolean isUnableLoadNext() {
        return this.unableLoadNext;
    }

    public UIActivitiesLoader getLastActivitiesLoader() {
        return this.lastActivitiesLoader;
    }

    public void setExtendContainer(UIContainer extendContainer) {
        this.extendContainer = extendContainer;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public void init() {
        try {
            this.unableLoadNext = true;
            this.currentLoadIndex = 0;
            this.isExtendLoader = false;
            this.activitiesContainer.setPostContext(this.postContext);
            this.activitiesContainer.setOwnerName(this.ownerName);
            if (this.space != null) {
                this.activitiesContainer.setSpace(this.space);
            }
            List<ExoSocialActivity> activities = new ArrayList<ExoSocialActivity>(0);
            if (this.activityListAccess.getSize() > this.loadingCapacity) {
                this.setUnableLoadNext(false);
            }
            if (this.isShowActivities(this.space)) {
                activities = this.loadActivities(this.currentLoadIndex, this.loadingCapacity);
            }
            this.activitiesContainer.setActivityList(activities);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void loadNext() throws Exception {
        this.currentLoadIndex += this.loadingCapacity;
        ArrayList<ExoSocialActivity> activities = new ArrayList(0);
        this.lastActivitiesLoader = (UIActivitiesLoader)this.extendContainer.addChild(UIActivitiesLoader.class, null, UIActivitiesLoader.genereateId());
        this.lastActivitiesLoader.setExtendLoader(true);
        if (this.isShowActivities(this.space)) {
            activities = this.loadActivities(this.currentLoadIndex, this.loadingCapacity);
        }
        if (activities.size() > 0) {
            if (activities.size() < this.loadingCapacity) {
                this.setUnableLoadNext(true);
                this.lastActivitiesLoader.setUnableLoadNext(true);
            }
            UIActivitiesContainer lastActivitiesContainer = this.lastActivitiesLoader.getActivitiesContainer();
            lastActivitiesContainer.setPostContext(this.postContext);
            lastActivitiesContainer.setSpace(this.space);
            this.lastActivitiesLoader.setActivities(activities);
        } else {
            this.setUnableLoadNext(true);
            this.lastActivitiesLoader.setUnableLoadNext(true);
        }
    }

    private void setActivities(List<ExoSocialActivity> activities) throws Exception {
        this.activitiesContainer.setActivityList(activities);
    }

    private List<ExoSocialActivity> loadActivities(int index, int length) throws Exception {
        ExoSocialActivity[] activities = (ExoSocialActivity[])this.activityListAccess.load(index, length);
        if (activities == null) {
            return null;
        }
        return new ArrayList<ExoSocialActivity>(Arrays.asList(activities));
    }

    private boolean isShowActivities(Space space) {
        if (space == null) {
            return true;
        }
        String remoteId = Util.getPortalRequestContext().getRemoteUser();
        return Utils.getSpaceService().isMember(space, remoteId);
    }

    public static class LoadMoreActionListener
    extends EventListener<UIActivitiesLoader> {
        public void execute(Event<UIActivitiesLoader> event) throws Exception {
            UIActivitiesLoader uiActivitiesLoader = (UIActivitiesLoader)((Object)event.getSource());
            uiActivitiesLoader.loadNext();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiActivitiesLoader.getExtendContainer());
            UIActivitiesLoader lastLoader = uiActivitiesLoader.getLastActivitiesLoader();
            uiActivitiesLoader.setExtendContainer(lastLoader.getExtendContainer());
        }
    }
}

