/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.composer;

import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.social.webui.composer.UIActivityComposer;
import org.exoplatform.social.webui.composer.UIActivityComposerContainer;
import org.exoplatform.social.webui.composer.UIActivityComposerManager;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.ext.UIExtension;
import org.exoplatform.webui.ext.UIExtensionManager;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/social/webui/composer/UIComposer.gtmpl", events={@EventConfig(listeners={PostMessageActionListener.class})})
public class UIComposer
extends UIForm {
    private UIContainer optionContainer;
    private PostContext postContext;
    private UIActivityComposerContainer composerContainer;
    private UIActivityComposerManager activityComposerManager;
    private boolean isActivityStreamOwner;
    private static final String HTML_ATTRIBUTE_TITLE = "title";
    private static final String COMPOSER_TEXT_AREA_INPUT = "composerInput";

    public UIComposer() throws Exception {
        if (this.getId() == null) {
            this.setId("UIComposer");
        }
        UIFormTextAreaInput messageInput = new UIFormTextAreaInput(COMPOSER_TEXT_AREA_INPUT, COMPOSER_TEXT_AREA_INPUT, null);
        this.addUIFormInput((UIFormInput)messageInput);
        this.composerContainer = (UIActivityComposerContainer)this.addChild(UIActivityComposerContainer.class, null, null);
        this.activityComposerManager = new UIActivityComposerManager();
        if (!this.activityComposerManager.isInitialized()) {
            this.initActivityComposerManager();
        }
        this.activityComposerManager.setDefaultActivityComposer();
    }

    public void isActivityStreamOwner(boolean isActivityStreamOwner) {
        this.isActivityStreamOwner = isActivityStreamOwner;
    }

    public boolean isActivityStreamOwner() {
        return this.isActivityStreamOwner;
    }

    protected void changeTitleTextAreInput() throws Exception {
        this.getUIFormTextAreaInput(COMPOSER_TEXT_AREA_INPUT).setHTMLAttribute(HTML_ATTRIBUTE_TITLE, this.getLabel("What_Are_You_Working_On"));
    }

    private void initActivityComposerManager() throws Exception {
        UIExtensionManager uiExtensionManager = (UIExtensionManager)PortalContainer.getInstance().getComponentInstanceOfType(UIExtensionManager.class);
        List extensionList = uiExtensionManager.getUIExtensions(UIActivityComposer.class.getName());
        if (extensionList != null) {
            int j = extensionList.size();
            for (int i = 0; i < j; ++i) {
                UIExtension composerExtension = (UIExtension)extensionList.get(i);
                if (composerExtension.getName().equals("DEFAULT_ACTIVITY_COMPOSER")) {
                    UIActivityComposer uiDefaultComposer = (UIActivityComposer)uiExtensionManager.addUIExtension(composerExtension, null, (UIContainer)this.composerContainer);
                    this.composerContainer.removeChildById(uiDefaultComposer.getId());
                    uiDefaultComposer.setRendered(false);
                    uiDefaultComposer.setActivityComposerManager(this.activityComposerManager);
                    this.activityComposerManager.setDefaultActivityComposer(uiDefaultComposer);
                    continue;
                }
                UIActivityComposer uiActivityComposer = (UIActivityComposer)uiExtensionManager.addUIExtension(composerExtension, null, (UIContainer)this.composerContainer);
                uiActivityComposer.setRendered(false);
                uiActivityComposer.setActivityComposerManager(this.activityComposerManager);
                this.activityComposerManager.registerActivityComposer(uiActivityComposer);
            }
        }
        this.activityComposerManager.setUiComposer(this);
        this.activityComposerManager.setInitialized();
    }

    public void setActivityDisplay(UIContainer uiContainer) {
        this.activityComposerManager.setActivityDisplay(uiContainer);
    }

    public void setDefaultActivityComposer() {
        this.activityComposerManager.setDefaultActivityComposer();
    }

    public UIActivityComposerContainer getComposerContainer() {
        return this.composerContainer;
    }

    public UIActivityComposerManager getActivityComposerManager() {
        return this.activityComposerManager;
    }

    public List<UIActivityComposer> getActivityComposers() {
        return this.activityComposerManager.getAllComposers();
    }

    public String getMessage() {
        return (String)this.getUIFormTextAreaInput(COMPOSER_TEXT_AREA_INPUT).getValue();
    }

    public PostContext getPostContext() {
        return this.postContext;
    }

    public void setPostContext(PostContext postContext) {
        this.postContext = postContext;
    }

    public void setOptionContainer(UIContainer optionContainer) {
        this.optionContainer = optionContainer;
    }

    public UIContainer getOptionContainer() {
        return this.optionContainer;
    }

    public String getActivateEvent(String activityComposerId) {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        String activityComposerFormId = context instanceof PortletRequestContext ? ((PortletRequestContext)context).getWindowId() + "#" + activityComposerId : activityComposerId;
        StringBuilder b = new StringBuilder();
        b.append("javascript:eXo.webui.UIForm.submitForm('").append(activityComposerFormId).append("','");
        b.append("Activate").append("',true)");
        return b.toString();
    }

    public static class PostMessageActionListener
    extends EventListener<UIComposer> {
        public void execute(Event<UIComposer> event) throws Exception {
            UIComposer uiComposer = (UIComposer)((Object)event.getSource());
            UIActivityComposerManager activityComposerManager = uiComposer.getActivityComposerManager();
            PostContext postContext = uiComposer.getPostContext();
            UIActivityComposer activityComposer = activityComposerManager.getCurrentActivityComposer();
            if (activityComposer.isDisplayed() && !activityComposer.isReadyForPostingActivity()) {
                activityComposerManager.setDefaultActivityComposer();
            }
            UIFormTextAreaInput textAreaInput = uiComposer.getUIFormTextAreaInput(UIComposer.COMPOSER_TEXT_AREA_INPUT);
            String message = (String)textAreaInput.getValue();
            textAreaInput.setValue((Object)"");
            message = message == null || uiComposer.getLabel("Write_Something").equals(message) || uiComposer.getLabel("What_Are_You_Working_On").equals(message) ? "" : message;
            activityComposerManager.getCurrentActivityComposer().postActivity(postContext, (UIComponent)uiComposer, event.getRequestContext(), message);
        }
    }

    public static enum PostContext {
        SPACE,
        USER;

    }
}

