/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.profile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.profile.UIProfileUserSearch;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(template="classpath:groovy/social/webui/connections/UIAllPeople.gtmpl", events={@EventConfig(listeners={ConnectActionListener.class}), @EventConfig(listeners={ConfirmActionListener.class}), @EventConfig(listeners={IgnoreActionListener.class}), @EventConfig(listeners={SearchActionListener.class}), @EventConfig(listeners={LoadMorePeopleActionListener.class})})
public class UIDisplayProfileList
extends UIContainer {
    private static final Log LOG = ExoLogger.getLogger(UIDisplayProfileList.class);
    private static final String INVITATION_REVOKED_INFO = "UIDisplayProfileList.label.RevokedInfo";
    private static final String INVITATION_ESTABLISHED_INFO = "UIDisplayProfileList.label.InvitationEstablishedInfo";
    private static final Integer PEOPLE_PER_PAGE = 45;
    private static final String ALL_FILTER = "All";
    public static final String SEARCH = "Search";
    private static final char EMPTY_CHARACTER = '\u0000';
    UIProfileUserSearch uiProfileUserSearch = (UIProfileUserSearch)this.addChild(UIProfileUserSearch.class, null, null);
    private boolean loadAtEnd = false;
    private boolean hasUpdated = false;
    private int currentLoadIndex;
    private boolean enableLoadNext;
    private int loadingCapacity;
    private List<Identity> peopleList;
    private ListAccess<Identity> peopleListAccess;
    private int peopleNum;
    private boolean hasPeopleTab;
    String selectedChar = null;

    public boolean isHasPeopleTab() {
        return this.hasPeopleTab;
    }

    public void setHasPeopleTab(boolean hasPeopleTab) {
        this.hasPeopleTab = hasPeopleTab;
    }

    public final String getSelectedChar() {
        return this.selectedChar;
    }

    public final void setSelectedChar(String selectedChar) {
        this.selectedChar = selectedChar;
    }

    public String getSelectedNode() {
        PortalRequestContext pcontext = Util.getPortalRequestContext();
        String currentPath = pcontext.getControllerContext().getParameter(QualifiedName.parse((String)"gtn:path"));
        if (currentPath.split("/").length >= 2) {
            return currentPath.split("/")[1];
        }
        return currentPath;
    }

    public UIDisplayProfileList() throws Exception {
        this.setHasPeopleTab(false);
        this.uiProfileUserSearch.setHasConnectionLink(false);
        this.setSelectedChar(ALL_FILTER);
        this.init();
    }

    public void init() {
        try {
            this.setHasUpdatedIdentity(false);
            this.setLoadAtEnd(false);
            this.enableLoadNext = false;
            this.currentLoadIndex = 0;
            this.loadingCapacity = PEOPLE_PER_PAGE;
            this.peopleList = new ArrayList<Identity>();
            ArrayList<Identity> excludedIdentityList = new ArrayList<Identity>();
            excludedIdentityList.add(Utils.getViewerIdentity());
            this.uiProfileUserSearch.getProfileFilter().setExcludedIdentityList(excludedIdentityList);
            this.setPeopleList(this.loadPeople(this.currentLoadIndex, this.loadingCapacity));
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void setLoadingCapacity(int loadingCapacity) {
        this.loadingCapacity = loadingCapacity;
    }

    public boolean isEnableLoadNext() {
        return this.enableLoadNext;
    }

    public void setEnableLoadNext(boolean enableLoadNext) {
        this.enableLoadNext = enableLoadNext;
    }

    public boolean isLoadAtEnd() {
        return this.loadAtEnd;
    }

    public void setLoadAtEnd(boolean loadAtEnd) {
        this.loadAtEnd = loadAtEnd;
    }

    public boolean isHasUpdatedIdentity() {
        return this.hasUpdated;
    }

    public void setHasUpdatedIdentity(boolean hasUpdatedIdentity) {
        this.hasUpdated = hasUpdatedIdentity;
    }

    public List<Identity> getPeopleList() throws Exception {
        int realPeopleListSize;
        if (this.isHasUpdatedIdentity()) {
            this.setHasUpdatedIdentity(false);
            this.setPeopleList(this.loadPeople(0, this.peopleList.size()));
        }
        this.setEnableLoadNext((realPeopleListSize = this.peopleList.size()) >= PEOPLE_PER_PAGE && realPeopleListSize < this.getPeopleNum());
        return this.peopleList;
    }

    public void setPeopleList(List<Identity> peopleList) {
        this.peopleList = peopleList;
    }

    public int getPeopleNum() {
        return this.peopleNum;
    }

    public void setPeopleNum(int peopleNum) {
        this.peopleNum = peopleNum;
    }

    public ListAccess<Identity> getPeopleListAccess() {
        return this.peopleListAccess;
    }

    public void setPeopleListAccess(ListAccess<Identity> peopleListAccess) {
        this.peopleListAccess = peopleListAccess;
    }

    public void loadNext() throws Exception {
        this.currentLoadIndex += this.loadingCapacity;
        if (this.currentLoadIndex <= this.getPeopleNum()) {
            ArrayList<Identity> currentPeopleList = new ArrayList<Identity>(this.peopleList);
            ArrayList<Object> loadedPeople = new ArrayList<Object>(Arrays.asList(this.getPeopleListAccess().load(this.currentLoadIndex, this.loadingCapacity)));
            currentPeopleList.addAll(loadedPeople);
            this.setPeopleList(currentPeopleList);
        }
    }

    public void loadSearch() throws Exception {
        this.currentLoadIndex = 0;
        this.setPeopleList(this.loadPeople(this.currentLoadIndex, this.loadingCapacity));
    }

    private List<Identity> loadPeople(int index, int length) throws Exception {
        ProfileFilter filter = this.uiProfileUserSearch.getProfileFilter();
        this.setPeopleListAccess((ListAccess<Identity>)Utils.getIdentityManager().getIdentitiesByProfileFilter("organization", filter, true));
        this.setPeopleNum(this.getPeopleListAccess().getSize());
        this.uiProfileUserSearch.setPeopleNum(this.getPeopleNum());
        Identity[] people = (Identity[])this.getPeopleListAccess().load(index, length);
        return new ArrayList<Identity>(Arrays.asList(people));
    }

    public Relationship getRelationship(Identity identity) throws Exception {
        if (identity.equals((Object)Utils.getViewerIdentity())) {
            return null;
        }
        return Utils.getRelationshipManager().get(identity, Utils.getViewerIdentity());
    }

    public static class SearchActionListener
    extends EventListener<UIDisplayProfileList> {
        public void execute(Event<UIDisplayProfileList> event) throws Exception {
            WebuiRequestContext ctx = event.getRequestContext();
            UIDisplayProfileList uiAllPeople = (UIDisplayProfileList)((Object)event.getSource());
            UIProfileUserSearch uiSearch = uiAllPeople.uiProfileUserSearch;
            String charSearch = ctx.getRequestParameter("objectId");
            ResourceBundle resApp = ctx.getApplicationResourceBundle();
            String defaultNameVal = resApp.getString(uiSearch.getId() + ".label.Name");
            String defaultPosVal = resApp.getString(uiSearch.getId() + ".label.Position");
            String defaultSkillsVal = resApp.getString(uiSearch.getId() + ".label.Skills");
            ProfileFilter filter = uiAllPeople.uiProfileUserSearch.getProfileFilter();
            try {
                uiAllPeople.setSelectedChar(charSearch);
                if (charSearch != null) {
                    ((UIFormStringInput)uiSearch.getChildById(UIDisplayProfileList.SEARCH)).setValue((Object)defaultNameVal);
                    ((UIFormStringInput)uiSearch.getChildById("position")).setValue((Object)defaultPosVal);
                    ((UIFormStringInput)uiSearch.getChildById("skills")).setValue((Object)defaultSkillsVal);
                    filter.setName(charSearch);
                    filter.setPosition("");
                    filter.setSkills("");
                    filter.setFirstCharacterOfName(charSearch.toCharArray()[0]);
                    if (UIDisplayProfileList.ALL_FILTER.equals(charSearch)) {
                        filter.setFirstCharacterOfName('\u0000');
                        filter.setName("");
                    }
                    uiSearch.setRawSearchConditional("");
                }
                uiSearch.setProfileFilter(filter);
                uiSearch.setNewSearch(true);
            }
            catch (Exception e) {
                uiSearch.setIdentityList(new ArrayList<Identity>());
            }
            uiAllPeople.loadSearch();
            uiAllPeople.setLoadAtEnd(false);
        }
    }

    public static class IgnoreActionListener
    extends EventListener<UIDisplayProfileList> {
        public void execute(Event<UIDisplayProfileList> event) throws Exception {
            UIDisplayProfileList uiAllPeople = (UIDisplayProfileList)((Object)event.getSource());
            String userId = event.getRequestContext().getRequestParameter("objectId");
            Identity inviIdentityIdentity = Utils.getIdentityManager().getIdentity(userId, true);
            Identity invitingIdentity = Utils.getViewerIdentity();
            Relationship relationship = Utils.getRelationshipManager().get(invitingIdentity, inviIdentityIdentity);
            uiAllPeople.setLoadAtEnd(false);
            if (relationship != null && relationship.getStatus() == Relationship.Type.CONFIRMED) {
                Utils.getRelationshipManager().delete(relationship);
                return;
            }
            if (relationship == null) {
                UIApplication uiApplication = event.getRequestContext().getUIApplication();
                uiApplication.addMessage(new ApplicationMessage(UIDisplayProfileList.INVITATION_REVOKED_INFO, null, 2));
                return;
            }
            uiAllPeople.setHasUpdatedIdentity(true);
            Utils.getRelationshipManager().deny(inviIdentityIdentity, invitingIdentity);
        }
    }

    public static class ConfirmActionListener
    extends EventListener<UIDisplayProfileList> {
        public void execute(Event<UIDisplayProfileList> event) throws Exception {
            UIDisplayProfileList uiAllPeople = (UIDisplayProfileList)((Object)event.getSource());
            String userId = event.getRequestContext().getRequestParameter("objectId");
            Identity invitedIdentity = Utils.getIdentityManager().getIdentity(userId, true);
            Identity invitingIdentity = Utils.getViewerIdentity();
            Relationship relationship = Utils.getRelationshipManager().get(invitingIdentity, invitedIdentity);
            uiAllPeople.setLoadAtEnd(false);
            if (relationship == null || relationship.getStatus() != Relationship.Type.PENDING) {
                UIApplication uiApplication = event.getRequestContext().getUIApplication();
                uiApplication.addMessage(new ApplicationMessage(UIDisplayProfileList.INVITATION_REVOKED_INFO, null, 2));
                return;
            }
            uiAllPeople.setHasUpdatedIdentity(true);
            Utils.getRelationshipManager().confirm(invitedIdentity, invitingIdentity);
        }
    }

    public static class ConnectActionListener
    extends EventListener<UIDisplayProfileList> {
        public void execute(Event<UIDisplayProfileList> event) throws Exception {
            UIDisplayProfileList uiAllPeople = (UIDisplayProfileList)((Object)event.getSource());
            String userId = event.getRequestContext().getRequestParameter("objectId");
            Identity invitedIdentity = Utils.getIdentityManager().getIdentity(userId, true);
            Identity invitingIdentity = Utils.getViewerIdentity();
            Relationship relationship = Utils.getRelationshipManager().get(invitingIdentity, invitedIdentity);
            uiAllPeople.setLoadAtEnd(false);
            if (relationship != null) {
                UIApplication uiApplication = event.getRequestContext().getUIApplication();
                uiApplication.addMessage(new ApplicationMessage(UIDisplayProfileList.INVITATION_ESTABLISHED_INFO, null, 2));
                return;
            }
            uiAllPeople.setHasUpdatedIdentity(true);
            Utils.getRelationshipManager().inviteToConnect(invitingIdentity, invitedIdentity);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiAllPeople);
        }
    }

    public static class LoadMorePeopleActionListener
    extends EventListener<UIDisplayProfileList> {
        public void execute(Event<UIDisplayProfileList> event) throws Exception {
            UIDisplayProfileList uiAllPeople = (UIDisplayProfileList)((Object)event.getSource());
            if (uiAllPeople.currentLoadIndex < uiAllPeople.peopleNum) {
                uiAllPeople.loadNext();
            } else {
                uiAllPeople.setEnableLoadNext(false);
            }
        }
    }
}

