/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space.access;

import java.io.IOException;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.application.RequestNavigationData;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.router.ExoRouter;
import org.exoplatform.social.core.space.SpaceAccessType;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.web.application.Application;
import org.exoplatform.web.application.ApplicationLifecycle;
import org.exoplatform.web.application.RequestFailure;
import org.exoplatform.webui.application.WebuiRequestContext;

public class SpaceAccessApplicationLifecycle
implements ApplicationLifecycle<WebuiRequestContext> {
    private static final Log LOG = ExoLogger.getLogger(SpaceAccessApplicationLifecycle.class);

    public void onInit(Application app) throws Exception {
    }

    public void onStartRequest(Application app, WebuiRequestContext context) throws Exception {
        PortalRequestContext pcontext = (PortalRequestContext)context;
        String siteName = pcontext.getControllerContext().getParameter(RequestNavigationData.REQUEST_SITE_NAME);
        String siteType = pcontext.getControllerContext().getParameter(RequestNavigationData.REQUEST_SITE_TYPE);
        String requestPath = pcontext.getControllerContext().getParameter(RequestNavigationData.REQUEST_PATH);
        Utils.setCurrentNavigationData(siteType, siteName, requestPath);
        ExoRouter.Route route = ExoRouter.route((String)requestPath);
        if (route == null) {
            return;
        }
        String spacePrettyName = (String)route.localArgs.get("spacePrettyName");
        String appName = (String)route.localArgs.get("appName");
        String page = (String)route.localArgs.get("page");
        if (pcontext.getSiteType().equals((Object)SiteType.GROUP) && pcontext.getSiteName().startsWith("/spaces") && spacePrettyName != null && spacePrettyName.length() > 0) {
            Space space = Utils.getSpaceService().getSpaceByPrettyName(spacePrettyName);
            String remoteId = Utils.getViewerRemoteId();
            if (this.inSuperAdminGroup(remoteId, space)) {
                return;
            }
            if ("wiki".equals(appName) && page != null && page.length() > 0) {
                this.processWikiSpaceAccess(pcontext, remoteId, space, page);
            } else {
                this.processSpaceAccess(pcontext, remoteId, space);
            }
        }
    }

    private boolean inSuperAdminGroup(String remoteId, Space space) {
        return SpaceAccessType.SUPER_ADMINISTRATOR.doCheck(remoteId, space);
    }

    private void processWikiSpaceAccess(PortalRequestContext pcontext, String remoteId, Space space, String wikiPage) throws IOException {
        boolean gotStatus = SpaceAccessType.SPACE_NOT_FOUND.doCheck(remoteId, space);
        if (gotStatus) {
            this.sendRedirect(pcontext, SpaceAccessType.SPACE_NOT_FOUND, null);
            return;
        }
        gotStatus = SpaceAccessType.NOT_ACCESS_WIKI_SPACE.doCheck(remoteId, space);
        if (gotStatus) {
            pcontext.getRequest().getSession().setAttribute("social.accessed.space.wiki.page.key", (Object)wikiPage);
            this.sendRedirect(pcontext, SpaceAccessType.NOT_ACCESS_WIKI_SPACE, space.getPrettyName());
            return;
        }
    }

    private void processSpaceAccess(PortalRequestContext pcontext, String remoteId, Space space) throws IOException {
        boolean gotStatus = SpaceAccessType.SPACE_NOT_FOUND.doCheck(remoteId, space);
        if (gotStatus) {
            this.sendRedirect(pcontext, SpaceAccessType.SPACE_NOT_FOUND, null);
            return;
        }
        gotStatus = SpaceAccessType.INVITED_SPACE.doCheck(remoteId, space);
        if (gotStatus) {
            this.sendRedirect(pcontext, SpaceAccessType.INVITED_SPACE, space.getPrettyName());
            return;
        }
        gotStatus = SpaceAccessType.REQUESTED_JOIN_SPACE.doCheck(remoteId, space);
        if (gotStatus) {
            this.sendRedirect(pcontext, SpaceAccessType.REQUESTED_JOIN_SPACE, space.getPrettyName());
            return;
        }
        gotStatus = SpaceAccessType.JOIN_SPACE.doCheck(remoteId, space);
        if (gotStatus) {
            this.sendRedirect(pcontext, SpaceAccessType.JOIN_SPACE, space.getPrettyName());
            return;
        }
        gotStatus = SpaceAccessType.REQUEST_JOIN_SPACE.doCheck(remoteId, space);
        if (gotStatus) {
            this.sendRedirect(pcontext, SpaceAccessType.REQUEST_JOIN_SPACE, space.getPrettyName());
            return;
        }
        gotStatus = SpaceAccessType.CLOSED_SPACE.doCheck(remoteId, space);
        if (gotStatus) {
            this.sendRedirect(pcontext, SpaceAccessType.CLOSED_SPACE, space.getPrettyName());
            return;
        }
    }

    private void sendRedirect(PortalRequestContext pcontext, SpaceAccessType type, String spacePrettyName) throws IOException {
        String url = Utils.getURI("space-access");
        LOG.info((Object)type.toString());
        String requestPath = pcontext.getRequestURI();
        pcontext.getRequest().getSession().setAttribute("social.accessed.space.type.key", (Object)type);
        pcontext.getRequest().getSession().setAttribute("social.accessed.space.key", (Object)spacePrettyName);
        pcontext.getRequest().getSession().setAttribute("social.accessed.space.request.path.key", (Object)requestPath);
        pcontext.setResponseComplete(true);
        pcontext.sendRedirect(url);
    }

    public void onFailRequest(Application app, WebuiRequestContext context, RequestFailure failureType) {
    }

    public void onEndRequest(Application app, WebuiRequestContext context) throws Exception {
    }

    public void onDestroy(Application app) throws Exception {
    }
}

