/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.connections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.profile.UIProfileUserSearch;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfigs(value={@ComponentConfig(template="classpath:groovy/social/webui/connections/UIMyConnections.gtmpl", events={@EventConfig(listeners={RemoveConnectionActionListener.class}), @EventConfig(listeners={SearchActionListener.class}), @EventConfig(listeners={LoadMorePeopleActionListener.class})})})
public class UIMyConnections
extends UIContainer {
    private static final Log LOG = ExoLogger.getLogger(UIMyConnections.class);
    private static final String RELATION_DELETED_INFO = "UIMyConnections.label.DeletedInfo";
    private static final String CONFIRMED_STATUS = "confirmed";
    UIProfileUserSearch uiProfileUserSearch = (UIProfileUserSearch)this.createUIComponent(UIProfileUserSearch.class, null, "UIProfileUserSearch");
    private static final int MY_CONNECTION_PER_PAGE = 45;
    private boolean loadAtEnd = false;
    private int currentLoadIndex;
    private boolean enableLoadNext;
    private int loadingCapacity;
    private List<Identity> peopleList;
    private ListAccess<Identity> peopleListAccess;
    private int peopleNum;
    private boolean hasPeopleTab;
    String selectedChar = null;
    private Identity lastOwner = null;

    public boolean isHasPeopleTab() {
        return this.hasPeopleTab;
    }

    public void setHasPeopleTab(boolean hasPeopleTab) {
        this.hasPeopleTab = hasPeopleTab;
    }

    public final String getSelectedChar() {
        return this.selectedChar;
    }

    public final void setSelectedChar(String selectedChar) {
        this.selectedChar = selectedChar;
    }

    public String getSelectedNode() {
        PortalRequestContext pcontext = Util.getPortalRequestContext();
        String currentPath = pcontext.getControllerContext().getParameter(QualifiedName.parse((String)"gtn:path"));
        if (currentPath.split("/").length >= 2) {
            return currentPath.split("/")[1];
        }
        return currentPath;
    }

    public UIMyConnections() throws Exception {
        this.uiProfileUserSearch.setTypeOfRelation(CONFIRMED_STATUS);
        if (Utils.isOwner()) {
            this.setHasPeopleTab(true);
        } else {
            this.setHasPeopleTab(false);
        }
        this.uiProfileUserSearch.setHasConnectionLink(false);
        this.addChild((UIComponent)this.uiProfileUserSearch);
        this.init();
    }

    public void init() {
        try {
            this.setLoadAtEnd(false);
            this.enableLoadNext = false;
            this.currentLoadIndex = 0;
            this.loadingCapacity = 45;
            this.peopleList = new ArrayList<Identity>();
            ArrayList<Identity> excludedIdentityList = new ArrayList<Identity>();
            excludedIdentityList.add(Utils.getViewerIdentity());
            this.uiProfileUserSearch.getProfileFilter().setExcludedIdentityList(excludedIdentityList);
            this.setPeopleList(this.loadPeople(this.currentLoadIndex, this.loadingCapacity));
            if (Utils.isOwner()) {
                this.uiProfileUserSearch.setHasPeopleTab(true);
            } else {
                this.uiProfileUserSearch.setHasPeopleTab(false);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void setLoadingCapacity(int loadingCapacity) {
        this.loadingCapacity = loadingCapacity;
    }

    public boolean isEnableLoadNext() {
        return this.enableLoadNext;
    }

    public void setEnableLoadNext(boolean enableLoadNext) {
        this.enableLoadNext = enableLoadNext;
    }

    public boolean isLoadAtEnd() {
        return this.loadAtEnd;
    }

    public void setLoadAtEnd(boolean loadAtEnd) {
        this.loadAtEnd = loadAtEnd;
    }

    public List<Identity> getPeopleList() throws Exception {
        this.peopleList = this.loadPeople(0, this.currentLoadIndex + this.loadingCapacity);
        int realPeopleListSize = this.peopleList.size();
        this.setEnableLoadNext(realPeopleListSize >= 45 && realPeopleListSize < this.getPeopleNum());
        return this.peopleList;
    }

    public void setPeopleList(List<Identity> peopleList) {
        this.peopleList = peopleList;
    }

    public int getPeopleNum() {
        return this.peopleNum;
    }

    public void setPeopleNum(int peopleNum) {
        this.peopleNum = peopleNum;
    }

    public ListAccess<Identity> getPeopleListAccess() {
        return this.peopleListAccess;
    }

    public void setPeopleListAccess(ListAccess<Identity> peopleListAccess) {
        this.peopleListAccess = peopleListAccess;
    }

    public void increaseOffset() throws Exception {
        this.currentLoadIndex += this.loadingCapacity;
    }

    public void loadSearch() throws Exception {
        this.currentLoadIndex = 0;
        this.setPeopleList(this.loadPeople(this.currentLoadIndex, this.loadingCapacity));
    }

    private List<Identity> loadPeople(int index, int length) throws Exception {
        this.lastOwner = Utils.getOwnerIdentity();
        ProfileFilter filter = this.uiProfileUserSearch.getProfileFilter();
        ListAccess listAccess = Utils.getRelationshipManager().getConnectionsByFilter(this.lastOwner, filter);
        Identity[] identities = (Identity[])listAccess.load(index, length);
        this.setPeopleNum(listAccess.getSize());
        this.setPeopleListAccess((ListAccess<Identity>)listAccess);
        this.uiProfileUserSearch.setPeopleNum(listAccess.getSize());
        return Arrays.asList(identities);
    }

    protected boolean isNewOwner() {
        Identity current = Utils.getOwnerIdentity();
        if (this.lastOwner == null || current == null) {
            return false;
        }
        return !this.lastOwner.getRemoteId().equals(current.getRemoteId());
    }

    public boolean isEditable() {
        return Utils.isOwner();
    }

    public static class SearchActionListener
    extends EventListener<UIMyConnections> {
        public void execute(Event<UIMyConnections> event) throws Exception {
            UIMyConnections uiMyConnections = (UIMyConnections)((Object)event.getSource());
            WebuiRequestContext ctx = event.getRequestContext();
            UIProfileUserSearch uiSearch = uiMyConnections.uiProfileUserSearch;
            String charSearch = ctx.getRequestParameter("objectId");
            ResourceBundle resApp = ctx.getApplicationResourceBundle();
            String defaultNameVal = resApp.getString(uiSearch.getId() + ".label.Name");
            String defaultPosVal = resApp.getString(uiSearch.getId() + ".label.Position");
            String defaultSkillsVal = resApp.getString(uiSearch.getId() + ".label.Skills");
            ProfileFilter filter = uiMyConnections.uiProfileUserSearch.getProfileFilter();
            try {
                uiMyConnections.setSelectedChar(charSearch);
                if (charSearch != null) {
                    ((UIFormStringInput)uiSearch.getChildById("Search")).setValue((Object)defaultNameVal);
                    ((UIFormStringInput)uiSearch.getChildById("position")).setValue((Object)defaultPosVal);
                    ((UIFormStringInput)uiSearch.getChildById("skills")).setValue((Object)defaultSkillsVal);
                    filter.setName(charSearch);
                    filter.setPosition("");
                    filter.setSkills("");
                    filter.setFirstCharacterOfName(charSearch.toCharArray()[0]);
                    if ("All".equals(charSearch)) {
                        filter.setFirstCharacterOfName('\u0000');
                        filter.setName("");
                    }
                    uiSearch.setRawSearchConditional("");
                } else if ("All".equals(uiSearch.getRawSearchConditional())) {
                    uiMyConnections.setSelectedChar("All");
                }
                uiSearch.setProfileFilter(filter);
                uiSearch.setNewSearch(true);
            }
            catch (Exception e) {
                uiSearch.setIdentityList(new ArrayList<Identity>());
            }
            uiMyConnections.loadSearch();
            uiMyConnections.setLoadAtEnd(false);
        }
    }

    public static class RemoveConnectionActionListener
    extends EventListener<UIMyConnections> {
        public void execute(Event<UIMyConnections> event) throws Exception {
            UIMyConnections uiMyConnections = (UIMyConnections)((Object)event.getSource());
            String identityId = event.getRequestContext().getRequestParameter("objectId");
            Identity requestedIdentity = Utils.getIdentityManager().getIdentity(identityId, true);
            Relationship relationship = Utils.getRelationshipManager().get(Utils.getOwnerIdentity(), requestedIdentity);
            uiMyConnections.setLoadAtEnd(false);
            if (relationship == null || relationship.getStatus() != Relationship.Type.CONFIRMED) {
                UIApplication uiApplication = event.getRequestContext().getUIApplication();
                uiApplication.addMessage(new ApplicationMessage(UIMyConnections.RELATION_DELETED_INFO, null, 2));
                return;
            }
            Utils.getRelationshipManager().delete(relationship);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiMyConnections);
        }
    }

    public static class LoadMorePeopleActionListener
    extends EventListener<UIMyConnections> {
        public void execute(Event<UIMyConnections> event) throws Exception {
            UIMyConnections uiMyConnections = (UIMyConnections)((Object)event.getSource());
            if (uiMyConnections.currentLoadIndex < uiMyConnections.peopleNum) {
                uiMyConnections.increaseOffset();
            } else {
                uiMyConnections.setEnableLoadNext(false);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiMyConnections);
        }
    }
}

