/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.profile;

import java.util.ArrayList;
import java.util.Calendar;
import org.apache.commons.lang.Validate;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.activity.ActivitiesRealtimeListAccess;
import org.exoplatform.social.core.activity.filter.ActivityUpdateFilter;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.activity.UIActivitiesContainer;
import org.exoplatform.social.webui.activity.UIActivitiesLoader;
import org.exoplatform.social.webui.composer.UIComposer;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIDropDownControl;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfigs(value={@ComponentConfig(template="classpath:groovy/social/webui/profile/UIUserActivitiesDisplay.gtmpl", events={@EventConfig(listeners={RefreshStreamActionListener.class})}), @ComponentConfig(type=UIDropDownControl.class, id="DisplayModesDropDown", template="system:/groovy/webui/core/UIDropDownControl.gtmpl", events={@EventConfig(listeners={ChangeOptionActionListener.class})})})
public class UIUserActivitiesDisplay
extends UIContainer {
    private static final Log LOG = ExoLogger.getLogger(UIUserActivitiesDisplay.class);
    private static final int ACTIVITY_PER_PAGE = 20;
    private static final String SLASH = "/";
    public static final String ACTIVITY_STREAM_VISITED_PREFIX_COOKIED = "exo_social_activity_stream_%s_visited_%s";
    private Object locker = new Object();
    private boolean notChangedMode;
    private boolean postActivity;
    private int numberOfUpdatedActivities;
    private DisplayMode selectedDisplayMode = DisplayMode.ALL_ACTIVITIES;
    private boolean isActivityStreamOwner = false;
    private UIActivitiesLoader activitiesLoader;
    private String ownerName;
    private String viewerName;

    public UIUserActivitiesDisplay() throws Exception {
        ArrayList<SelectItemOption> displayModes = new ArrayList<SelectItemOption>(4);
        displayModes.add(new SelectItemOption("All_Updates", (Object)DisplayMode.ALL_ACTIVITIES.toString()));
        displayModes.add(new SelectItemOption("Space_Updates", (Object)DisplayMode.MY_SPACE.toString()));
        displayModes.add(new SelectItemOption("Network_Updates", (Object)DisplayMode.CONNECTIONS.toString()));
        displayModes.add(new SelectItemOption("My_Status", (Object)DisplayMode.MY_ACTIVITIES.toString()));
        UIDropDownControl uiDropDownControl = (UIDropDownControl)this.addChild(UIDropDownControl.class, "DisplayModesDropDown", null);
        uiDropDownControl.setOptions(displayModes);
        this.setSelectedMode(uiDropDownControl);
        this.addChild((UIComponent)uiDropDownControl);
        String remoteId = Utils.getOwnerRemoteId();
        this.setOwnerName(remoteId);
        String selectedDisplayMode = Utils.getCookies(String.format("exo_social_activity_stream_tab_selected_%s", Utils.getViewerRemoteId()));
        selectedDisplayMode = selectedDisplayMode != null ? selectedDisplayMode : DisplayMode.ALL_ACTIVITIES.name();
        this.setSelectedDisplayMode(selectedDisplayMode);
    }

    public UIActivitiesLoader getActivitiesLoader() {
        return this.activitiesLoader;
    }

    public boolean isActivityStreamOwner() {
        return this.isActivityStreamOwner;
    }

    public void setNumberOfUpdatedActivities(int numberOfUpdatedActivities) {
        this.numberOfUpdatedActivities = numberOfUpdatedActivities;
    }

    public int getNumberOfUpdatedActivities() {
        return this.numberOfUpdatedActivities;
    }

    public void setSelectedDisplayMode(DisplayMode displayMode) {
        this.selectedDisplayMode = displayMode;
        ((UIDropDownControl)this.getChild(UIDropDownControl.class)).setValue(this.selectedDisplayMode.toString());
    }

    public void setSelectedDisplayMode(String selectedDisplayMode) {
        DisplayMode[] displayModes = DisplayMode.values();
        for (int i = 0; i < displayModes.length; ++i) {
            if (!displayModes[i].name().equals(selectedDisplayMode)) continue;
            this.setSelectedDisplayMode(displayModes[i]);
            break;
        }
    }

    public DisplayMode getSelectedDisplayMode() {
        return this.selectedDisplayMode;
    }

    public String getCookiesKey(String displayMode) {
        return String.format(ACTIVITY_STREAM_VISITED_PREFIX_COOKIED, displayMode, Utils.getViewerRemoteId());
    }

    public void setOwnerName(String ownerName) throws Exception {
        this.ownerName = ownerName;
        this.viewerName = PortalRequestContext.getCurrentInstance().getRemoteUser();
        this.isActivityStreamOwner = this.viewerName.equals(ownerName);
        if (!this.isActivityStreamOwner) {
            this.selectedDisplayMode = DisplayMode.OWNER_STATUS;
        }
        this.init();
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws Exception {
        Validate.notNull((Object)this.ownerName, (String)"ownerName must not be null.");
        Validate.notNull((Object)this.viewerName, (String)"viewerName must not be null.");
        Object object = this.locker;
        synchronized (object) {
            this.removeChild(UIActivitiesLoader.class);
            this.activitiesLoader = (UIActivitiesLoader)this.addChild(UIActivitiesLoader.class, null, "UIActivitiesLoader");
        }
        this.activitiesLoader.setPostContext(UIComposer.PostContext.USER);
        this.activitiesLoader.setLoadingCapacity(20);
        this.activitiesLoader.setOwnerName(this.ownerName);
        this.activitiesLoader.setSelectedDisplayMode(this.selectedDisplayMode.toString());
        Identity ownerIdentity = Utils.getIdentityManager().getOrCreateIdentity("organization", this.ownerName, false);
        ActivityManager activityManager = Utils.getActivityManager();
        RealtimeListAccess activitiesListAccess = null;
        switch (this.selectedDisplayMode) {
            case MY_ACTIVITIES: {
                activitiesListAccess = activityManager.getActivitiesWithListAccess(ownerIdentity);
                this.activitiesLoader.setActivityListAccess((ListAccess<ExoSocialActivity>)activitiesListAccess);
                break;
            }
            case OWNER_STATUS: {
                if (!this.isActivityStreamOwner) {
                    Identity viewerIdentity = Utils.getIdentityManager().getOrCreateIdentity("organization", this.viewerName, false);
                    activitiesListAccess = activityManager.getActivitiesWithListAccess(ownerIdentity, viewerIdentity);
                    this.activitiesLoader.setActivityListAccess((ListAccess<ExoSocialActivity>)activitiesListAccess);
                    break;
                }
                activitiesListAccess = activityManager.getActivitiesWithListAccess(ownerIdentity);
                this.activitiesLoader.setActivityListAccess((ListAccess<ExoSocialActivity>)activitiesListAccess);
                break;
            }
            case CONNECTIONS: {
                activitiesListAccess = activityManager.getActivitiesOfConnectionsWithListAccess(ownerIdentity);
                this.activitiesLoader.setActivityListAccess((ListAccess<ExoSocialActivity>)activitiesListAccess);
                break;
            }
            case MY_SPACE: {
                activitiesListAccess = activityManager.getActivitiesOfUserSpacesWithListAccess(ownerIdentity);
                this.activitiesLoader.setActivityListAccess((ListAccess<ExoSocialActivity>)activitiesListAccess);
                break;
            }
            default: {
                activitiesListAccess = activityManager.getActivityFeedWithListAccess(ownerIdentity);
                this.activitiesLoader.setActivityListAccess((ListAccess<ExoSocialActivity>)activitiesListAccess);
            }
        }
        String lastVisitedModeCookieKey = String.format("exo_social_activity_stream_tab_selected_%s", Utils.getViewerRemoteId());
        String lastVisitedMode = Utils.getCookies(lastVisitedModeCookieKey);
        this.notChangedMode = lastVisitedMode == null ? true : this.selectedDisplayMode.toString().equals(lastVisitedMode.trim());
        this.setNumberOfUpdatedActivities(0);
        this.activitiesLoader.init();
    }

    private void setSelectedMode(UIDropDownControl uiDropDownControl) {
        if (this.selectedDisplayMode != null) {
            uiDropDownControl.setValue(this.selectedDisplayMode.toString());
        }
    }

    public void setChangedMode(boolean changedMode) {
        this.notChangedMode = changedMode;
    }

    protected long getCurrentServerTime() {
        return Calendar.getInstance().getTimeInMillis();
    }

    protected String getSitePath() {
        PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
        String siteName = portalRequestContext.getSiteName();
        SiteType siteType = portalRequestContext.getSiteType();
        return SLASH + siteType.getName() + SLASH + siteName + SLASH;
    }

    protected boolean hasActivities() {
        UIActivitiesLoader uiActivitiesLoader = (UIActivitiesLoader)this.getChild(UIActivitiesLoader.class);
        UIActivitiesContainer activitiesContainer = (UIActivitiesContainer)uiActivitiesLoader.getChild(UIActivitiesContainer.class);
        return activitiesContainer.getChildren().size() > 1;
    }

    private int getActivitiesUpdatedNum(boolean hasRefresh) {
        long lastNumber;
        if (this.postActivity) {
            this.resetCookies();
            this.postActivity = false;
            return 0;
        }
        UIActivitiesLoader activitiesLoader = (UIActivitiesLoader)this.getChild(UIActivitiesLoader.class);
        ActivitiesRealtimeListAccess activitiesListAccess = (ActivitiesRealtimeListAccess)activitiesLoader.getActivityListAccess();
        String mode = DisplayMode.ALL_ACTIVITIES.toString();
        ActivityUpdateFilter.ActivityFilterType.ACTIVITY_FEED.oldFromSinceTime(Long.valueOf(Utils.getLastVisited("old_from", mode))).fromSinceTime(Long.valueOf(Utils.getLastVisited("from", mode))).toSinceTime(Long.valueOf(Utils.getLastVisited("to", mode))).lastNumberOfUpdated(Long.valueOf(this.getLastUpdatedNum(mode)));
        mode = DisplayMode.CONNECTIONS.toString();
        ActivityUpdateFilter.ActivityFilterType.CONNECTIONS_ACTIVITIES.oldFromSinceTime(Long.valueOf(Utils.getLastVisited("old_from", mode))).fromSinceTime(Long.valueOf(Utils.getLastVisited("from", mode))).toSinceTime(Long.valueOf(Utils.getLastVisited("to", mode))).lastNumberOfUpdated(Long.valueOf(this.getLastUpdatedNum(mode)));
        mode = DisplayMode.MY_ACTIVITIES.toString();
        ActivityUpdateFilter.ActivityFilterType.USER_ACTIVITIES.oldFromSinceTime(Long.valueOf(Utils.getLastVisited("old_from", mode))).fromSinceTime(Long.valueOf(Utils.getLastVisited("from", mode))).toSinceTime(Long.valueOf(Utils.getLastVisited("to", mode))).lastNumberOfUpdated(Long.valueOf(this.getLastUpdatedNum(mode)));
        mode = DisplayMode.MY_SPACE.toString();
        ActivityUpdateFilter.ActivityFilterType.USER_SPACE_ACTIVITIES.oldFromSinceTime(Long.valueOf(Utils.getLastVisited("old_from", mode))).fromSinceTime(Long.valueOf(Utils.getLastVisited("from", mode))).toSinceTime(Long.valueOf(Utils.getLastVisited("to", mode))).lastNumberOfUpdated(Long.valueOf(this.getLastUpdatedNum(mode)));
        ActivityUpdateFilter updatedFilter = new ActivityUpdateFilter(hasRefresh);
        int gotNumber = activitiesListAccess.getNumberOfUpdated(updatedFilter);
        if (gotNumber == 0 && hasRefresh && (lastNumber = this.getLastUpdatedNum(this.selectedDisplayMode.toString())) > 0L) {
            this.resetCookies();
        }
        return gotNumber;
    }

    public void resetCookies() {
        Utils.setLastVisited(this.selectedDisplayMode.toString());
        if (this.selectedDisplayMode == DisplayMode.ALL_ACTIVITIES) {
            Utils.setLastVisited(DisplayMode.CONNECTIONS.toString());
            Utils.setLastVisited(DisplayMode.MY_ACTIVITIES.toString());
            Utils.setLastVisited(DisplayMode.MY_SPACE.toString());
        }
    }

    public void setPostActivity(boolean postActivity) {
        this.postActivity = postActivity;
    }

    protected boolean isWelcomeActivity() {
        this.viewerName = PortalRequestContext.getCurrentInstance().getRemoteUser();
        if (!this.viewerName.equals(this.ownerName)) {
            return false;
        }
        boolean hasActivities = this.getActivitiesLoader().getActivitiesContainer().getChildren().size() > 1;
        boolean isAllActivitiesModeOnHomePage = DisplayMode.ALL_ACTIVITIES.equals((Object)this.getSelectedDisplayMode());
        return Utils.isHomePage() ? !hasActivities && isAllActivitiesModeOnHomePage : !hasActivities;
    }

    private long getLastUpdatedNum(String mode) {
        String cookieKey = String.format("exo_social_last_updated_activities_num_on_%s_of_%s", mode, Utils.getViewerRemoteId());
        String strValue = Utils.getCookies(cookieKey);
        boolean refreshPage = Utils.isRefreshPage();
        if (strValue == null || !refreshPage && mode.equals(this.selectedDisplayMode.toString())) {
            return 0L;
        }
        return Long.parseLong(strValue);
    }

    private void setLastUpdatedNum(String mode, String value) {
        String cookieKey = String.format("exo_social_last_updated_activities_num_on_%s_of_%s", mode, Utils.getViewerRemoteId());
        Utils.setCookies(cookieKey, value);
    }

    public static class RefreshStreamActionListener
    extends EventListener<UIUserActivitiesDisplay> {
        public void execute(Event<UIUserActivitiesDisplay> event) throws Exception {
            UIUserActivitiesDisplay uiUserActivities = (UIUserActivitiesDisplay)((Object)event.getSource());
            WebuiRequestContext requestContext = event.getRequestContext();
            uiUserActivities.init();
            UIActivitiesLoader activitiesLoader = (UIActivitiesLoader)uiUserActivities.getChild(UIActivitiesLoader.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)activitiesLoader);
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiUserActivities);
        }
    }

    public static class ChangeOptionActionListener
    extends EventListener<UIDropDownControl> {
        public void execute(Event<UIDropDownControl> event) throws Exception {
            UIDropDownControl uiDropDown = (UIDropDownControl)event.getSource();
            UIUserActivitiesDisplay uiUserActivities = (UIUserActivitiesDisplay)uiDropDown.getParent();
            WebuiRequestContext requestContext = event.getRequestContext();
            String selectedDisplayMode = requestContext.getRequestParameter("objectId");
            if (selectedDisplayMode.equals(DisplayMode.ALL_ACTIVITIES.toString())) {
                uiUserActivities.setSelectedDisplayMode(DisplayMode.ALL_ACTIVITIES);
            } else if (selectedDisplayMode.equals(DisplayMode.MY_ACTIVITIES.toString())) {
                uiUserActivities.setSelectedDisplayMode(DisplayMode.MY_ACTIVITIES);
            } else if (selectedDisplayMode.equals(DisplayMode.MY_SPACE.toString())) {
                uiUserActivities.setSelectedDisplayMode(DisplayMode.MY_SPACE);
            } else {
                uiUserActivities.setSelectedDisplayMode(DisplayMode.CONNECTIONS);
            }
            if (selectedDisplayMode != null) {
                uiUserActivities.setSelectedDisplayMode(selectedDisplayMode);
                uiUserActivities.init();
                uiUserActivities.setChangedMode(false);
                UIActivitiesLoader activitiesLoader = (UIActivitiesLoader)uiUserActivities.getChild(UIActivitiesLoader.class);
                event.getRequestContext().getJavascriptManager().require("SHARED/social-ui-activity-updates", "activityUpdates").addScripts("activityUpdates.resetCookie('" + String.format("exo_social_activity_stream_tab_selected_%s", Utils.getViewerRemoteId()) + "','" + selectedDisplayMode + "');");
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)activitiesLoader);
            }
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiUserActivities);
        }
    }

    public static enum DisplayMode {
        OWNER_STATUS,
        ALL_ACTIVITIES,
        CONNECTIONS,
        MY_SPACE,
        MY_ACTIVITIES;

    }
}

