/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import java.util.ResourceBundle;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.validator.ExpressionValidator;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.StringLengthValidator;

public class UISpaceSettings
extends UIFormInputSet {
    private final String SPACE_DISPLAY_NAME = "displayName";
    private final String SPACE_DESCRIPTION = "description";
    private final String MSG_INVALID_SPACE_NAME = "UISpaceSettings.msg.invalid_space_name";
    private static final String HTML_ATTRIBUTE_TITLE = "title";

    public UISpaceSettings(String name) throws Exception {
        super(name);
        WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle resourceBundle = requestContext.getApplicationResourceBundle();
        UIFormStringInput spaceDisplayName = new UIFormStringInput("displayName", "displayName", null);
        spaceDisplayName.setHTMLAttribute(HTML_ATTRIBUTE_TITLE, resourceBundle.getString("UISpaceSettings.label.spaceDisplayName"));
        this.addUIFormInput((UIFormInput)spaceDisplayName.addValidator(MandatoryValidator.class, new Object[0]).addValidator(ExpressionValidator.class, new Object[]{"^([\\p{L}\\s\\d']+[\\s]?)+$", "UISpaceSettings.msg.invalid_space_name"}).addValidator(StringLengthValidator.class, new Object[]{3, 30}));
        UIFormTextAreaInput description = new UIFormTextAreaInput("description", "description", null);
        description.setHTMLAttribute(HTML_ATTRIBUTE_TITLE, resourceBundle.getString("UISpaceSettings.label.spaceDescription"));
        this.addUIFormInput((UIFormInput)description.addValidator(StringLengthValidator.class, new Object[]{0, 255}));
    }
}

