/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.ResourceBundle;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.core.identity.SpaceMemberFilterListAccess;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="war:/groovy/social/webui/UIUserInvitation.gtmpl", events={@EventConfig(listeners={InviteActionListener.class})})
public class UIUserInvitation
extends UIForm {
    private static final String USER = "user";
    private SpaceService spaceService;
    private String spaceUrl;
    private ApplicationMessage msg;
    private static final String SPACE_PREFIX = "space::";

    public UIUserInvitation() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(USER, null, null));
        this.spaceUrl = SpaceUtils.getSpaceUrlByContext();
    }

    private SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        }
        return this.spaceService;
    }

    public String getRestURL() {
        StringBuilder builder = new StringBuilder();
        builder.append("/").append(PortalContainer.getCurrentRestContextName()).append("/social/people/suggest.json?");
        builder.append("currentUser=").append(RequestContext.getCurrentInstance().getRemoteUser());
        builder.append("&spaceURL=").append(this.spaceUrl);
        builder.append("&typeOfRelation=").append("user_to_invite");
        return builder.toString();
    }

    public void addMessage(ApplicationMessage msg) {
        if (msg != null) {
            ResourceBundle rb = WebuiRequestContext.getCurrentInstance().getApplicationResourceBundle();
            msg.setResourceBundle(rb);
        }
        this.msg = msg;
    }

    public ApplicationMessage getMessage() {
        return this.msg;
    }

    public String getValue() {
        return (String)this.getUIStringInput(USER).getValue();
    }

    private String validateInvitedUser(String userNameForInvite) throws Exception {
        String[] invitedUserList = userNameForInvite.split(",");
        String invitedUser = null;
        String invitedUserNames = null;
        HashSet<String> validUsers = new HashSet<String>();
        HashSet<String> notExistUsers = new HashSet<String>();
        SpaceService spaceService = this.getSpaceService();
        boolean isValidInput = true;
        for (String userStr : invitedUserList) {
            if (userStr.startsWith(SPACE_PREFIX)) {
                Identity[] identities;
                String spaceName = userStr.substring(SPACE_PREFIX.length());
                Space space = spaceService.getSpaceByPrettyName(spaceName);
                if (space == null) {
                    notExistUsers.add(spaceName);
                    isValidInput = false;
                    continue;
                }
                if (!isValidInput) continue;
                ProfileFilter filter = new ProfileFilter();
                ListAccess loader = Utils.getIdentityManager().getSpaceIdentityByProfileFilter(space, filter, SpaceMemberFilterListAccess.Type.MEMBER, true);
                for (Identity i : identities = (Identity[])loader.load(0, loader.getSize())) {
                    invitedUser = i.getRemoteId();
                    validUsers.add(invitedUser);
                }
                continue;
            }
            invitedUser = userStr.trim();
            if (invitedUser.length() == 0) continue;
            if (this.isNotExisted(invitedUser)) {
                notExistUsers.add(invitedUser);
                isValidInput = false;
                continue;
            }
            if (!isValidInput) continue;
            validUsers.add(invitedUser);
        }
        if (notExistUsers.size() > 0) {
            StringBuilder sb = new StringBuilder();
            boolean isSeparated = false;
            for (String i : notExistUsers) {
                if (isSeparated) {
                    sb.append(", ");
                }
                sb.append("'").append(i).append("'");
                isSeparated = true;
            }
            ((UIPortletApplication)this.getAncestorOfType(UIPortletApplication.class)).addMessage(new ApplicationMessage("UIUserInvitation.msg.invalid-input", (Object[])new String[]{sb.toString()}, 0));
            return null;
        }
        if (validUsers.size() > 0) {
            invitedUserNames = StringUtils.join(validUsers, (char)',');
        }
        return invitedUserNames;
    }

    protected boolean isMember(String userId) {
        Space space = Utils.getSpaceByContext();
        try {
            if (ArrayUtils.contains((Object[])space.getMembers(), (Object)userId)) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    private boolean hasInvited(String userId) {
        SpaceService spaceService = this.getSpaceService();
        Space space = Utils.getSpaceByContext();
        try {
            if (spaceService.isInvitedUser(space, userId) || spaceService.isMember(space, userId)) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    private boolean isNotExisted(String userId) {
        OrganizationService orgService = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
        try {
            User user = orgService.getUserHandler().findUserByName(userId);
            if (user != null) {
                return false;
            }
        }
        catch (Exception e) {
            return true;
        }
        return true;
    }

    public static class InviteActionListener
    extends EventListener<UIUserInvitation> {
        public void execute(Event<UIUserInvitation> event) throws Exception {
            UIUserInvitation uicomponent = (UIUserInvitation)((Object)event.getSource());
            UIFormStringInput input = uicomponent.getUIStringInput(UIUserInvitation.USER);
            String value = (String)input.getValue();
            if (value == null || value.trim().isEmpty()) {
                ((UIPortletApplication)uicomponent.getAncestorOfType(UIPortletApplication.class)).addMessage(new ApplicationMessage("UIUserInvitation.msg.empty-input", null));
                return;
            }
            SpaceService spaceService = (SpaceService)uicomponent.getApplicationComponent(SpaceService.class);
            String invitedUserNames = uicomponent.validateInvitedUser(value);
            Space space = Utils.getSpaceByContext();
            if (invitedUserNames != null) {
                String[] invitedUsers = invitedUserNames.split(",");
                String name = null;
                ArrayList<String> usersForInviting = new ArrayList<String>();
                if (invitedUsers != null) {
                    for (int idx = 0; idx < invitedUsers.length; ++idx) {
                        name = invitedUsers[idx].trim();
                        if (name.length() <= 0) continue;
                        UserACL userACL = (UserACL)uicomponent.getApplicationComponent(UserACL.class);
                        if (name.equals(userACL.getSuperUser())) {
                            spaceService.addMember(space, name);
                            continue;
                        }
                        if (usersForInviting.contains(name) || spaceService.isMember(space, name)) continue;
                        usersForInviting.add(name);
                    }
                }
                if (usersForInviting.size() > 0) {
                    ExoContainer container = ExoContainerContext.getCurrentContainer();
                    IdentityManager idm = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
                    for (String userName : usersForInviting) {
                        Identity identity = idm.getOrCreateIdentity("organization", userName, false);
                        if (identity == null) continue;
                        spaceService.addInvitedUser(space, userName);
                    }
                    if (usersForInviting.size() == 1) {
                        Identity identity = idm.getOrCreateIdentity("organization", (String)usersForInviting.get(0), true);
                        uicomponent.addMessage(new ApplicationMessage("UIUserInvitation.msg.user-invited", (Object[])new String[]{StringEscapeUtils.escapeHtml((String)identity.getProfile().getFullName())}));
                    } else {
                        uicomponent.addMessage(new ApplicationMessage("UIUserInvitation.msg.users-invited", (Object[])new String[]{String.valueOf(usersForInviting.size())}));
                    }
                } else if (invitedUsers.length == 1) {
                    uicomponent.addMessage(new ApplicationMessage("UIUserInvitation.msg.user-is-member", (Object[])new String[]{invitedUsers[0]}));
                } else {
                    uicomponent.addMessage(new ApplicationMessage("UIUserInvitation.msg.users-already-members", null));
                }
                input.setValue((Object)"");
            }
        }
    }
}

