/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.activity;

import java.util.Hashtable;
import java.util.Map;
import javax.inject.Provider;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.social.webui.activity.BaseUIActivityBuilder;
import org.exoplatform.social.webui.activity.UIActivityExtension;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.ext.UIExtension;
import org.exoplatform.webui.ext.UIExtensionManager;

public class UIActivityFactory
extends BaseComponentPlugin {
    private static final Log LOG = ExoLogger.getLogger(UIActivityFactory.class);
    private Map<String, Provider<BaseUIActivityBuilder>> builders = new Hashtable<String, Provider<BaseUIActivityBuilder>>();
    private UIExtensionManager extensionManager = (UIExtensionManager)PortalContainer.getInstance().getComponentInstanceOfType(UIExtensionManager.class);

    public BaseUIActivity addChild(ExoSocialActivity activity, UIContainer parent) throws Exception {
        String type = activity.getType();
        String externalId = activity.getExternalId();
        if (type != null) {
            return this.buildActivity(activity, parent, type);
        }
        if (externalId != null) {
            return this.buildActivity(activity, parent, externalId);
        }
        return this.buildActivity(activity, parent, "DEFAULT_ACTIVITY");
    }

    private BaseUIActivity buildActivity(ExoSocialActivity activity, UIContainer parent, String type) throws Exception {
        UIExtension activityExtension = this.extensionManager.getUIExtension(BaseUIActivity.class.getName(), type);
        if (activityExtension == null) {
            activityExtension = this.extensionManager.getUIExtension(BaseUIActivity.class.getName(), "DEFAULT_ACTIVITY");
        }
        BaseUIActivity uiActivity = (BaseUIActivity)this.extensionManager.addUIExtension(activityExtension, null, parent);
        uiActivity.setId(uiActivity.getId().replace(":", "_") + "_" + ((Object)((Object)uiActivity)).hashCode());
        this.registerBuilder((UIActivityExtension)activityExtension);
        BaseUIActivityBuilder builder = this.getBuilder(type);
        return builder.populateData(uiActivity, activity);
    }

    private BaseUIActivityBuilder getBuilder(String activityType) {
        Provider<BaseUIActivityBuilder> providerBuilder = this.builders.get(activityType);
        if (providerBuilder == null) {
            providerBuilder = this.builders.get("DEFAULT_ACTIVITY");
        }
        return (BaseUIActivityBuilder)providerBuilder.get();
    }

    private void registerBuilder(UIActivityExtension activityExtension) throws Exception {
        String activityType = activityExtension.getName();
        if (!this.builders.containsKey(activityType)) {
            this.builders.put(activityType, new BuilderProvider(activityExtension));
        }
    }

    static class BuilderProvider<T extends BaseUIActivityBuilder>
    implements Provider<T> {
        final UIActivityExtension activityExtension;
        T instance = null;

        public BuilderProvider(UIActivityExtension activityExtension) {
            this.activityExtension = activityExtension;
        }

        public T get() {
            if (this.instance != null) {
                return this.instance;
            }
            try {
                Class<?> builderClass = Thread.currentThread().getContextClassLoader().loadClass(this.activityExtension.getActivityBuiderClass());
                this.instance = (BaseUIActivityBuilder)builderClass.newInstance();
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
            return this.instance;
        }
    }
}

