/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(template="war:/groovy/social/webui/space/UIInvitation.gtmpl")
public class UIInvitation
extends UIContainer {
    private final String USERS_SPACES = "users-spaces";
    private final String SPACE_PREFIX = "space::";

    public UIInvitation() {
        UIFormStringInput uiFormStringInput = new UIFormStringInput("users-spaces", null, null);
        this.addChild((UIComponent)uiFormStringInput);
    }

    public List<Identity> getSelectedIdentities() {
        UIFormStringInput uiFormStringInput = (UIFormStringInput)this.getChild(UIFormStringInput.class);
        String input = (String)uiFormStringInput.getValue();
        return this.getIdentities(input);
    }

    public String getRestURL() {
        StringBuilder builder = new StringBuilder();
        builder.append("/").append(PortalContainer.getCurrentRestContextName()).append("/social/people/suggest.json?");
        builder.append("currentUser=").append(RequestContext.getCurrentInstance().getRemoteUser());
        builder.append("&typeOfRelation=").append("user_to_invite");
        return builder.toString();
    }

    private List<Identity> getIdentities(String input) {
        ArrayList<Identity> identityList = new ArrayList<Identity>();
        if (input != null) {
            String[] invitedList = input.split(",");
            IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
            for (String invited : invitedList) {
                if (invited.startsWith("space::")) {
                    String spaceName = invited.substring("space::".length());
                    Identity spaceIdentity = identityManager.getOrCreateIdentity("space", spaceName, false);
                    identityList.add(spaceIdentity);
                    continue;
                }
                Identity identity = identityManager.getOrCreateIdentity("organization", invited, false);
                identityList.add(identity);
            }
        }
        return identityList;
    }
}

