/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.Described;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.portal.mop.description.DescriptionService;
import org.exoplatform.portal.mop.navigation.NavigationError;
import org.exoplatform.portal.mop.navigation.NavigationServiceException;
import org.exoplatform.portal.mop.navigation.NodeChangeListener;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.page.PageService;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserNodeFilterConfig;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.portal.UIPortalComposer;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIEditInlineWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIPortalToolPanel;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.space.TreeNode;
import org.exoplatform.social.webui.space.UIPageNodeForm;
import org.exoplatform.social.webui.space.UISpaceNavigationManagement;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UIRightClickPopupMenu;
import org.exoplatform.webui.core.UITree;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.gatein.common.util.ParameterValidation;

@ComponentConfigs(value={@ComponentConfig(template="war:/groovy/social/webui/space/UISpaceNavigationNodeSelector.gtmpl", events={@EventConfig(listeners={ChangeNodeActionListener.class})}), @ComponentConfig(id="SpaceNavigationNodePopupMenu", type=UIRightClickPopupMenu.class, template="system:/groovy/webui/core/UIRightClickPopupMenu.gtmpl", events={@EventConfig(listeners={AddNodeActionListener.class}), @EventConfig(listeners={EditPageNodeActionListener.class}), @EventConfig(listeners={EditSelectedNodeActionListener.class}), @EventConfig(listeners={CopyNodeActionListener.class}), @EventConfig(listeners={CutNodeActionListener.class}), @EventConfig(listeners={CloneNodeActionListener.class}), @EventConfig(listeners={PasteNodeActionListener.class}), @EventConfig(listeners={MoveUpActionListener.class}), @EventConfig(listeners={MoveDownActionListener.class}), @EventConfig(listeners={DeleteNodeActionListener.class}, confirm="UIPageNodeSelector.deleteNavigation")}), @ComponentConfig(id="UISpaceNavigationNodeSelectorPopupMenu", type=UIRightClickPopupMenu.class, template="system:/groovy/webui/core/UIRightClickPopupMenu.gtmpl", events={@EventConfig(listeners={AddNodeActionListener.class}), @EventConfig(listeners={PasteNodeActionListener.class})})})
public class UISpaceNavigationNodeSelector
extends UIContainer {
    private UserNavigation edittedNavigation;
    private TreeNode copyOfTreeNodeData;
    private TreeNode rootNode;
    private UserPortal userPortal;
    private UserNodeFilterConfig filterConfig;
    private Map<String, Map<Locale, Described.State>> userNodeLabels;
    private static final Scope NODE_SCOPE = Scope.GRANDCHILDREN;
    private static final String CHILDNODES_DELIMITER = "/";

    public UISpaceNavigationNodeSelector() throws Exception {
        UIRightClickPopupMenu rightClickPopup = (UIRightClickPopupMenu)((UIRightClickPopupMenu)this.addChild(UIRightClickPopupMenu.class, "UISpaceNavigationNodeSelectorPopupMenu", null)).setRendered(true);
        rightClickPopup.setActions(new String[]{"AddNode", "PasteNode"});
        UITree uiTree = (UITree)this.addChild(UITree.class, null, "TreeNodeSelector");
        uiTree.setIcon("DefaultPageIcon");
        uiTree.setSelectedIcon("DefaultPageIcon");
        uiTree.setBeanIdField("Id");
        uiTree.setBeanChildCountField("childrenCount");
        uiTree.setBeanLabelField("encodedResolvedLabel");
        uiTree.setBeanIconField("icon");
        UIRightClickPopupMenu uiPopupMenu = (UIRightClickPopupMenu)this.createUIComponent(UIRightClickPopupMenu.class, "SpaceNavigationNodePopupMenu", null);
        uiPopupMenu.setActions(new String[]{"AddNode", "EditPageNode", "EditSelectedNode", "CopyNode", "CloneNode", "CutNode", "DeleteNode", "MoveUp", "MoveDown"});
        uiTree.setUIRightClickPopupMenu(uiPopupMenu);
        this.userNodeLabels = new HashMap<String, Map<Locale, Described.State>>();
    }

    public Map<String, Map<Locale, Described.State>> getUserNodeLabels() {
        return this.userNodeLabels;
    }

    public void setUserNodeLabels(Map<String, Map<Locale, Described.State>> userNodeLabels) {
        this.userNodeLabels = userNodeLabels;
    }

    public void initTreeData() throws Exception {
        if (this.edittedNavigation == null || this.userPortal == null) {
            throw new IllegalStateException("edittedNavigation and userPortal must be initialized first");
        }
        try {
            TreeNode node = this.rootNode = new TreeNode(this.edittedNavigation, this.userPortal.getNode(this.edittedNavigation, NODE_SCOPE, this.filterConfig, null));
            if (this.rootNode.getChildren().size() > 0 && (node = this.rebaseNode(this.rootNode.getChild(0), NODE_SCOPE)) == null) {
                this.initTreeData();
                return;
            }
            this.selectNode(node);
        }
        catch (Exception ex) {
            this.rootNode = null;
            WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            context.getUIApplication().addMessage(new ApplicationMessage("UINavigationNodeSelector.msg." + NavigationError.NAVIGATION_NO_SITE.name(), null, 0));
            UIPopupWindow popup = (UIPopupWindow)this.getAncestorOfType(UIPopupWindow.class);
            popup.createEvent("ClosePopup", Event.Phase.PROCESS, context).broadcast();
            PortalRequestContext prContext = Util.getPortalRequestContext();
            UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)Util.getUIPortalApplication().getChild(UIWorkingWorkspace.class);
            prContext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
            prContext.setFullRender(true);
        }
    }

    public TreeNode selectNode(TreeNode node) throws Exception {
        if (node == null) {
            return null;
        }
        UITree tree = (UITree)this.getChild(UITree.class);
        tree.setSelected((Object)node);
        if (node.getId().equals(this.rootNode.getId())) {
            tree.setChildren(null);
            tree.setSibbling(node.getChildren());
            tree.setParentSelected((Object)node);
        } else {
            TreeNode parentNode = node.getParent();
            tree.setChildren(node.getChildren());
            tree.setSibbling(parentNode.getChildren());
            tree.setParentSelected((Object)parentNode);
        }
        return node;
    }

    public TreeNode rebaseNode(TreeNode treeNode, Scope scope) throws Exception {
        if (treeNode == null || treeNode.getNode() == null) {
            return null;
        }
        UserNode userNode = treeNode.getNode();
        if (userNode.getId() == null) {
            return treeNode;
        }
        this.userPortal.rebaseNode(userNode, scope, (NodeChangeListener)this.getRootNode());
        return this.findNode(treeNode.getId());
    }

    public void save() {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        try {
            this.userPortal.saveNode(this.getRootNode().getNode(), (NodeChangeListener)this.getRootNode());
            DescriptionService descriptionService = (DescriptionService)this.getApplicationComponent(DescriptionService.class);
            Map<String, Map<Locale, Described.State>> i18nizedLabels = this.userNodeLabels;
            for (String treeNodeId : i18nizedLabels.keySet()) {
                TreeNode node = this.findNode(treeNodeId);
                if (node == null) continue;
                Map<Locale, Described.State> labels = i18nizedLabels.get(treeNodeId);
                node.setI18nizedLabels(labels);
                if (labels == null || labels.size() <= 0) continue;
                descriptionService.setDescriptions(node.getNode().getId(), labels);
            }
        }
        catch (NavigationServiceException ex) {
            context.getUIApplication().addMessage(new ApplicationMessage("UINavigationNodeSelector.msg." + ex.getError().name(), null, 0));
        }
    }

    public TreeNode getCopyNode() {
        return this.copyOfTreeNodeData;
    }

    public void setCopyNode(TreeNode copyNode) {
        this.copyOfTreeNodeData = copyNode;
    }

    public void setRootNode(TreeNode rNode) {
        this.rootNode = rNode;
    }

    public TreeNode getRootNode() {
        return this.rootNode;
    }

    public void setUserPortal(UserPortal userPortal) throws Exception {
        this.userPortal = userPortal;
        this.setFilterConfig(UserNodeFilterConfig.builder().withReadWriteCheck().build());
    }

    private void setFilterConfig(UserNodeFilterConfig config) {
        this.filterConfig = config;
    }

    public void setEdittedNavigation(UserNavigation nav) throws Exception {
        this.edittedNavigation = nav;
    }

    public UserNavigation getEdittedNavigation() {
        return this.edittedNavigation;
    }

    public TreeNode findNode(String nodeID) {
        if (this.getRootNode() == null) {
            return null;
        }
        return this.getRootNode().findNode(nodeID);
    }

    public TreeNode getSelectedNode() {
        return (TreeNode)((UITree)this.getChild(UITree.class)).getSelected();
    }

    private void invokeI18NizedLabels(TreeNode node) {
        DescriptionService descriptionService = (DescriptionService)this.getApplicationComponent(DescriptionService.class);
        try {
            Map labels = descriptionService.getDescriptions(node.getId());
            node.setI18nizedLabels(labels);
        }
        catch (NullPointerException npe) {
            node.setI18nizedLabels(null);
        }
    }

    public static class DeleteNodeActionListener
    extends EventListener<UIRightClickPopupMenu> {
        public void execute(Event<UIRightClickPopupMenu> event) throws Exception {
            WebuiRequestContext pcontext = event.getRequestContext();
            UISpaceNavigationNodeSelector uiNodeSelector = (UISpaceNavigationNodeSelector)((UIRightClickPopupMenu)event.getSource()).getAncestorOfType(UISpaceNavigationNodeSelector.class);
            pcontext.addUIComponentToUpdateByAjax((UIComponent)uiNodeSelector);
            String nodeID = pcontext.getRequestParameter("objectId");
            TreeNode childNode = uiNodeSelector.findNode(nodeID);
            if (childNode == null) {
                return;
            }
            if (!childNode.getURI().contains(UISpaceNavigationNodeSelector.CHILDNODES_DELIMITER)) {
                UIApplication uiApp = pcontext.getUIApplication();
                uiApp.addMessage(new ApplicationMessage("UINavigationNodeSelector.msg.systemnode-delete", null));
                return;
            }
            String pageRef = childNode.getPageRef();
            if (pageRef != null) {
                String[] spaceApps;
                String appName = pageRef.substring(pageRef.lastIndexOf(":") + 1);
                SpaceService spaceService = (SpaceService)uiNodeSelector.getApplicationComponent(SpaceService.class);
                UISpaceNavigationManagement uiSpaceNavManagement = (UISpaceNavigationManagement)uiNodeSelector.getParent();
                Space space = uiSpaceNavManagement.getSpace();
                String spaceAppList = space.getApp();
                for (String spaceApp : spaceApps = spaceAppList.split(",")) {
                    String rootNodeName;
                    String[] appConfig = spaceApp.split(":");
                    if (!appConfig[0].equals(appName)) continue;
                    if (!Boolean.parseBoolean(appConfig[2])) {
                        UIApplication uiApp = pcontext.getUIApplication();
                        uiApp.addMessage(new ApplicationMessage("UINavigationNodeSelector.msg.systemnode-delete", null));
                        return;
                    }
                    String parentNodeName = childNode.getParent().getName();
                    if (!parentNodeName.equals(rootNodeName = space.getPrettyName())) break;
                    spaceService.removeApplication(space.getId(), appName, appConfig[1]);
                    break;
                }
            }
            TreeNode parentNode = childNode.getParent();
            if (Visibility.SYSTEM.equals((Object)childNode.getVisibility())) {
                UIApplication uiApp = pcontext.getUIApplication();
                uiApp.addMessage(new ApplicationMessage("UINavigationNodeSelector.msg.systemnode-delete", null));
                return;
            }
            uiNodeSelector.getUserNodeLabels().remove(childNode.getId());
            parentNode.removeChild(childNode);
            uiNodeSelector.selectNode(parentNode);
            uiNodeSelector.save();
            SpaceUtils.updateWorkingWorkSpace();
        }
    }

    public static class MoveDownActionListener
    extends MoveUpActionListener {
        @Override
        public void execute(Event<UIRightClickPopupMenu> event) throws Exception {
            super.moveNode(event, 2);
        }
    }

    public static class MoveUpActionListener
    extends BaseActionListener<UIRightClickPopupMenu> {
        public void execute(Event<UIRightClickPopupMenu> event) throws Exception {
            this.moveNode(event, -1);
        }

        protected void moveNode(Event<UIRightClickPopupMenu> event, int i) throws Exception {
            int k;
            WebuiRequestContext context = event.getRequestContext();
            UISpaceNavigationNodeSelector uiNodeSelector = (UISpaceNavigationNodeSelector)((UIRightClickPopupMenu)event.getSource()).getAncestorOfType(UISpaceNavigationNodeSelector.class);
            context.addUIComponentToUpdateByAjax(uiNodeSelector.getParent());
            String nodeID = context.getRequestParameter("objectId");
            TreeNode targetNode = uiNodeSelector.findNode(nodeID);
            if (targetNode == null) {
                return;
            }
            TreeNode parentNode = targetNode.getParent();
            try {
                parentNode = this.rebaseNode(parentNode, uiNodeSelector);
                if (parentNode == null) {
                    return;
                }
                TreeNode temp = parentNode.getChild(targetNode.getName());
                if (temp == null || !temp.getId().equals(targetNode.getId())) {
                    context.getUIApplication().addMessage(new ApplicationMessage("UINavigationNodeSelector.msg.staleData", null, 1));
                    uiNodeSelector.selectNode(uiNodeSelector.getRootNode());
                    context.addUIComponentToUpdateByAjax((UIComponent)uiNodeSelector);
                    return;
                }
            }
            catch (NavigationServiceException ex) {
                this.handleError(ex.getError(), uiNodeSelector);
                return;
            }
            List<TreeNode> children = parentNode.getChildren();
            for (k = 0; k < children.size() && !parentNode.getChild(k).getId().equals(targetNode.getId()); ++k) {
            }
            if (k == 0 && i == -1) {
                return;
            }
            if (k == children.size() - 1 && i == 2) {
                return;
            }
            parentNode.addChild(k + i, targetNode);
            TreeNode selectedNode = uiNodeSelector.getSelectedNode();
            uiNodeSelector.selectNode(parentNode);
            uiNodeSelector.selectNode(selectedNode);
        }
    }

    public static class PasteNodeActionListener
    extends BaseActionListener<UIRightClickPopupMenu> {
        private UISpaceNavigationNodeSelector uiNodeSelector;
        private PageService pageService;

        public void execute(Event<UIRightClickPopupMenu> event) throws Exception {
            WebuiRequestContext context = event.getRequestContext();
            UIRightClickPopupMenu uiPopupMenu = (UIRightClickPopupMenu)event.getSource();
            this.uiNodeSelector = (UISpaceNavigationNodeSelector)uiPopupMenu.getAncestorOfType(UISpaceNavigationNodeSelector.class);
            context.addUIComponentToUpdateByAjax((UIComponent)this.uiNodeSelector);
            String nodeID = context.getRequestParameter("objectId");
            TreeNode targetNode = this.uiNodeSelector.findNode(nodeID);
            TreeNode sourceNode = this.uiNodeSelector.getCopyNode();
            if (sourceNode == null) {
                return;
            }
            try {
                targetNode = this.rebaseNode(targetNode, this.uiNodeSelector);
                if (targetNode == null) {
                    return;
                }
            }
            catch (NavigationServiceException ex) {
                this.handleError(ex.getError(), this.uiNodeSelector);
                return;
            }
            if (sourceNode.getId().equals(targetNode.getId())) {
                context.getUIApplication().addMessage(new ApplicationMessage("UIPageNodeSelector.msg.paste.sameSrcAndDes", null));
                return;
            }
            if (this.isExistChild(targetNode, sourceNode)) {
                context.getUIApplication().addMessage(new ApplicationMessage("UIPageNodeSelector.msg.paste.sameName", null));
                return;
            }
            UITree uitree = (UITree)this.uiNodeSelector.getChild(UITree.class);
            UIRightClickPopupMenu popup = uitree.getUIRightClickPopupMenu();
            popup.setActions(new String[]{"AddNode", "EditPageNode", "EditSelectedNode", "CopyNode", "CutNode", "CloneNode", "DeleteNode", "MoveUp", "MoveDown"});
            this.uiNodeSelector.setCopyNode(null);
            if (this.uiNodeSelector.findNode(sourceNode.getId()) == null) {
                context.getUIApplication().addMessage(new ApplicationMessage("UINavigationNodeSelector.msg.copiedNode.deleted", null, 1));
                this.uiNodeSelector.selectNode(this.uiNodeSelector.getRootNode());
                return;
            }
            if (sourceNode.isDeleteNode()) {
                targetNode.addChild(sourceNode);
                this.uiNodeSelector.selectNode(targetNode);
                return;
            }
            this.pageService = (PageService)this.uiNodeSelector.getApplicationComponent(PageService.class);
            this.pasteNode(sourceNode, targetNode, sourceNode.isCloneNode());
            this.uiNodeSelector.selectNode(targetNode);
        }

        private TreeNode pasteNode(TreeNode sourceNode, TreeNode parent, boolean isClone) throws Exception {
            TreeNode node = parent.addChild(sourceNode.getName());
            node.setLabel(sourceNode.getLabel());
            node.setVisibility(sourceNode.getVisibility());
            node.setIcon(sourceNode.getIcon());
            node.setStartPublicationTime(sourceNode.getStartPublicationTime());
            node.setEndPublicationTime(sourceNode.getEndPublicationTime());
            if (isClone) {
                String pageName = "page" + node.hashCode();
                node.setPageRef(this.clonePageFromNode(sourceNode, pageName, sourceNode.getPageNavigation().getKey()));
            } else {
                node.setPageRef(sourceNode.getPageRef());
            }
            for (TreeNode child : sourceNode.getChildren()) {
                this.pasteNode(child, node, isClone);
            }
            node.setI18nizedLabels(sourceNode.getI18nizedLabels());
            this.uiNodeSelector.getUserNodeLabels().put(node.getId(), node.getI18nizedLabels());
            return node;
        }

        private String clonePageFromNode(TreeNode node, String pageName, SiteKey siteKey) throws Exception {
            PageKey sourceKey;
            PageContext page;
            String pageId = node.getPageRef();
            if (pageId != null && (page = this.pageService.loadPage(sourceKey = PageKey.parse((String)pageId))) != null) {
                page = this.pageService.clone(sourceKey, siteKey.page(pageName));
                return page.getKey().format();
            }
            return null;
        }

        private boolean isExistChild(TreeNode parent, TreeNode child) {
            return parent != null && parent.getChild(child.getName()) != null;
        }
    }

    public static class CloneNodeActionListener
    extends CopyNodeActionListener {
        @Override
        public void execute(Event<UIRightClickPopupMenu> event) throws Exception {
            super.execute(event);
            UISpaceNavigationNodeSelector uiNodeSelector = (UISpaceNavigationNodeSelector)((UIRightClickPopupMenu)event.getSource()).getAncestorOfType(UISpaceNavigationNodeSelector.class);
            TreeNode currNode = uiNodeSelector.getCopyNode();
            String nodeID = event.getRequestContext().getRequestParameter("objectId");
            if (currNode != null && currNode.getId().equals(nodeID)) {
                currNode.setCloneNode(true);
            }
        }
    }

    public static class CutNodeActionListener
    extends BaseActionListener<UIRightClickPopupMenu> {
        public void execute(Event<UIRightClickPopupMenu> event) throws Exception {
            WebuiRequestContext context = event.getRequestContext();
            UISpaceNavigationNodeSelector uiNodeSelector = (UISpaceNavigationNodeSelector)((UIRightClickPopupMenu)event.getSource()).getAncestorOfType(UISpaceNavigationNodeSelector.class);
            context.addUIComponentToUpdateByAjax((UIComponent)uiNodeSelector);
            String nodeID = context.getRequestParameter("objectId");
            TreeNode node = uiNodeSelector.findNode(nodeID);
            try {
                node = this.rebaseNode(node, Scope.SINGLE, uiNodeSelector);
                if (node == null) {
                    return;
                }
            }
            catch (NavigationServiceException ex) {
                this.handleError(ex.getError(), uiNodeSelector);
                return;
            }
            if (node != null && Visibility.SYSTEM.equals((Object)node.getVisibility())) {
                context.getUIApplication().addMessage(new ApplicationMessage("UINavigationNodeSelector.msg.systemnode-move", null));
                return;
            }
            node.setDeleteNode(true);
            uiNodeSelector.setCopyNode(node);
            ((UIRightClickPopupMenu)event.getSource()).setActions(new String[]{"AddNode", "EditPageNode", "EditSelectedNode", "CopyNode", "CloneNode", "CutNode", "PasteNode", "DeleteNode", "MoveUp", "MoveDown"});
        }
    }

    public static class CopyNodeActionListener
    extends BaseActionListener<UIRightClickPopupMenu> {
        public void execute(Event<UIRightClickPopupMenu> event) throws Exception {
            WebuiRequestContext context = event.getRequestContext();
            UISpaceNavigationNodeSelector uiNodeSelector = (UISpaceNavigationNodeSelector)((UIRightClickPopupMenu)event.getSource()).getAncestorOfType(UISpaceNavigationNodeSelector.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiNodeSelector);
            String nodeID = context.getRequestParameter("objectId");
            TreeNode node = uiNodeSelector.findNode(nodeID);
            try {
                node = this.rebaseNode(node, Scope.ALL, uiNodeSelector);
                if (node == null) {
                    return;
                }
            }
            catch (NavigationServiceException ex) {
                this.handleError(ex.getError(), uiNodeSelector);
                return;
            }
            node.setDeleteNode(false);
            uiNodeSelector.setCopyNode(node);
            ((UIRightClickPopupMenu)event.getSource()).setActions(new String[]{"AddNode", "EditPageNode", "EditSelectedNode", "CopyNode", "CloneNode", "CutNode", "PasteNode", "DeleteNode", "MoveUp", "MoveDown"});
        }
    }

    public static class EditSelectedNodeActionListener
    extends BaseActionListener<UIRightClickPopupMenu> {
        public void execute(Event<UIRightClickPopupMenu> event) throws Exception {
            Page page;
            WebuiRequestContext context = event.getRequestContext();
            UIRightClickPopupMenu popupMenu = (UIRightClickPopupMenu)event.getSource();
            UISpaceNavigationNodeSelector uiNodeSelector = (UISpaceNavigationNodeSelector)popupMenu.getAncestorOfType(UISpaceNavigationNodeSelector.class);
            String nodeID = event.getRequestContext().getRequestParameter("objectId");
            TreeNode node = uiNodeSelector.findNode(nodeID);
            try {
                node = this.rebaseNode(node, uiNodeSelector);
                if (node == null) {
                    return;
                }
            }
            catch (NavigationServiceException ex) {
                this.handleError(ex.getError(), uiNodeSelector);
                return;
            }
            UIApplication uiApp = context.getUIApplication();
            DataStorage dataService = (DataStorage)uiNodeSelector.getApplicationComponent(DataStorage.class);
            String pageId = node.getPageRef();
            Page page2 = page = pageId != null ? dataService.getPage(pageId) : null;
            if (page != null) {
                UserACL userACL = (UserACL)uiApp.getApplicationComponent(UserACL.class);
                SpaceService spaceService = (SpaceService)uiNodeSelector.getApplicationComponent(SpaceService.class);
                UISpaceNavigationManagement uiSpaceNavigationManagement = (UISpaceNavigationManagement)uiNodeSelector.getParent();
                if (!(spaceService.isSuperManager(Utils.getViewerRemoteId()) || spaceService.isManager(uiSpaceNavigationManagement.getSpace(), Utils.getViewerRemoteId()) || userACL.hasPermission(page))) {
                    uiApp.addMessage(new ApplicationMessage("UIPageBrowser.msg.UserNotPermission", (Object[])new String[]{pageId}, 1));
                    return;
                }
            }
            if (node.getI18nizedLabels() == null) {
                uiNodeSelector.invokeI18NizedLabels(node);
            }
            UISpaceNavigationManagement uiSpaceNavigationManagement = (UISpaceNavigationManagement)uiNodeSelector.getParent();
            UIPopupWindow uiManagementPopup = (UIPopupWindow)uiSpaceNavigationManagement.getChild(UIPopupWindow.class);
            UIPageNodeForm uiNodeForm = (UIPageNodeForm)uiApp.createUIComponent(UIPageNodeForm.class, null, null);
            uiManagementPopup.setUIComponent((UIComponent)uiNodeForm);
            UserNavigation edittedNav = uiNodeSelector.getEdittedNavigation();
            uiNodeForm.setContextPageNavigation(edittedNav);
            uiNodeForm.setValues(node);
            uiNodeForm.setSelectedParent(node.getParent());
            uiManagementPopup.setWindowSize(800, 445);
            uiManagementPopup.setShow(true);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiManagementPopup.getParent());
        }
    }

    public static class EditPageNodeActionListener
    extends EventListener<UIRightClickPopupMenu> {
        public void execute(Event<UIRightClickPopupMenu> event) throws Exception {
            PageContext pageContext;
            String nodeID = event.getRequestContext().getRequestParameter("objectId");
            UIRightClickPopupMenu uiPopupMenu = (UIRightClickPopupMenu)event.getSource();
            UISpaceNavigationNodeSelector uiNodeSelector = (UISpaceNavigationNodeSelector)uiPopupMenu.getAncestorOfType(UISpaceNavigationNodeSelector.class);
            TreeNode selectedPageNode = uiNodeSelector.findNode(nodeID);
            UIPortalApplication uiApp = Util.getUIPortalApplication();
            if (selectedPageNode == null || selectedPageNode.getPageRef() == null) {
                uiApp.addMessage(new ApplicationMessage("UIPageNodeSelector.msg.notAvailable", null));
                return;
            }
            DataStorage dataService = (DataStorage)uiNodeSelector.getApplicationComponent(DataStorage.class);
            String pageId = selectedPageNode.getPageRef();
            UserPortalConfigService userService = (UserPortalConfigService)uiNodeSelector.getApplicationComponent(UserPortalConfigService.class);
            PageContext pageContext2 = pageContext = pageId != null ? userService.getPageService().loadPage(PageKey.parse((String)pageId)) : null;
            if (pageContext != null) {
                UserACL userACL = (UserACL)uiApp.getApplicationComponent(UserACL.class);
                if (!userACL.hasEditPermission(pageContext)) {
                    uiApp.addMessage(new ApplicationMessage("UIPageBrowser.msg.UserNotPermission", (Object[])new String[]{pageId}, 1));
                    return;
                }
                uiApp.setModeState(1);
                UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiApp.getChildById("UIWorkingWorkspace");
                UIPortalToolPanel uiToolPanel = (UIPortalToolPanel)((UIPortalToolPanel)uiWorkingWS.findFirstComponentOfType(UIPortalToolPanel.class)).setRendered(true);
                uiWorkingWS.setRenderedChild(UIEditInlineWorkspace.class);
                UIPortalComposer portalComposer = (UIPortalComposer)((UIPortalComposer)uiWorkingWS.findFirstComponentOfType(UIPortalComposer.class)).setRendered(true);
                portalComposer.setShowControl(true);
                portalComposer.setEditted(false);
                portalComposer.setCollapse(false);
                portalComposer.setId("UIPageEditor");
                portalComposer.setComponentConfig(UIPortalComposer.class, "UIPageEditor");
                uiToolPanel.setShowMaskLayer(false);
                uiToolPanel.setWorkingComponent(UIPage.class, null);
                UIPage uiPage = (UIPage)uiToolPanel.getUIComponent();
                Page selectPage = userService.getDataStorage().getPage(pageId);
                pageContext.update(selectPage);
                if (selectPage.getTitle() == null) {
                    selectPage.setTitle(selectedPageNode.getLabel());
                }
                PortalDataMapper.toUIPage((UIPage)uiPage, (Page)selectPage);
                Util.getPortalRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
                Util.getPortalRequestContext().setFullRender(true);
            } else {
                uiApp.addMessage(new ApplicationMessage("UIPageNodeSelector.msg.notAvailable", null));
            }
        }
    }

    public static class NodeModifiedActionListener
    extends BaseActionListener<UISpaceNavigationNodeSelector> {
        public void execute(Event<UISpaceNavigationNodeSelector> event) throws Exception {
            UISpaceNavigationNodeSelector uiNodeSelector = (UISpaceNavigationNodeSelector)((Object)event.getSource());
            try {
                this.rebaseNode(uiNodeSelector.getRootNode(), uiNodeSelector);
            }
            catch (NavigationServiceException ex) {
                this.handleError(ex.getError(), uiNodeSelector);
            }
        }
    }

    public static class AddNodeActionListener
    extends BaseActionListener<UIRightClickPopupMenu> {
        public void execute(Event<UIRightClickPopupMenu> event) throws Exception {
            TreeNode node;
            WebuiRequestContext context = event.getRequestContext();
            UIRightClickPopupMenu uiPopupMenu = (UIRightClickPopupMenu)event.getSource();
            UISpaceNavigationNodeSelector uiNodeSelector = (UISpaceNavigationNodeSelector)uiPopupMenu.getAncestorOfType(UISpaceNavigationNodeSelector.class);
            String nodeID = context.getRequestParameter("objectId");
            if (ParameterValidation.isNullOrEmpty((String)nodeID)) {
                String selectedNodeID = uiNodeSelector.getSelectedNode().getId();
                node = uiNodeSelector.findNode(selectedNodeID);
            } else {
                node = uiNodeSelector.findNode(nodeID);
            }
            TreeNode rootNode = uiNodeSelector.getRootNode();
            if (node.getId().equals(rootNode.getId())) {
                return;
            }
            try {
                node = this.rebaseNode(node, uiNodeSelector);
                if (node == null) {
                    return;
                }
            }
            catch (NavigationServiceException ex) {
                this.handleError(ex.getError(), uiNodeSelector);
                return;
            }
            UISpaceNavigationManagement uiSpaceNavigationManagement = (UISpaceNavigationManagement)uiNodeSelector.getParent();
            UIPopupWindow uiManagementPopup = (UIPopupWindow)uiSpaceNavigationManagement.getChild(UIPopupWindow.class);
            UIPageNodeForm uiNodeForm = (UIPageNodeForm)uiManagementPopup.createUIComponent(UIPageNodeForm.class, null, null);
            uiNodeForm.setValues(null);
            uiManagementPopup.setUIComponent((UIComponent)uiNodeForm);
            uiNodeForm.setSelectedParent(node);
            UserNavigation edittedNavigation = uiNodeSelector.getEdittedNavigation();
            uiNodeForm.setContextPageNavigation(edittedNavigation);
            uiManagementPopup.setWindowSize(800, 445);
            uiManagementPopup.setShow(true);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiManagementPopup.getParent());
        }
    }

    public static class ChangeNodeActionListener
    extends BaseActionListener<UITree> {
        public void execute(Event<UITree> event) throws Exception {
            WebuiRequestContext context = event.getRequestContext();
            UISpaceNavigationNodeSelector uiNodeSelector = (UISpaceNavigationNodeSelector)((UITree)event.getSource()).getParent();
            String nodeID = context.getRequestParameter("objectId");
            TreeNode node = uiNodeSelector.findNode(nodeID);
            TreeNode rootNode = uiNodeSelector.getRootNode();
            if (node.getId().equals(rootNode.getId())) {
                return;
            }
            try {
                node = this.rebaseNode(node, uiNodeSelector);
            }
            catch (NavigationServiceException ex) {
                this.handleError(ex.getError(), uiNodeSelector);
                return;
            }
            uiNodeSelector.selectNode(node);
            context.addUIComponentToUpdateByAjax(uiNodeSelector.getParent());
        }
    }

    public static abstract class BaseActionListener<T>
    extends EventListener<T> {
        protected TreeNode rebaseNode(TreeNode node, UISpaceNavigationNodeSelector selector) throws Exception {
            return this.rebaseNode(node, NODE_SCOPE, selector);
        }

        protected TreeNode rebaseNode(TreeNode node, Scope scope, UISpaceNavigationNodeSelector selector) throws Exception {
            WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            TreeNode rebased = selector.rebaseNode(node, scope);
            if (rebased == null) {
                selector.getUserNodeLabels().remove(node.getId());
                context.getUIApplication().addMessage(new ApplicationMessage("UINavigationNodeSelector.msg.staleData", null, 1));
                selector.selectNode(selector.getRootNode());
                context.addUIComponentToUpdateByAjax((UIComponent)selector);
            }
            return rebased;
        }

        protected void handleError(NavigationError error, UISpaceNavigationNodeSelector selector) throws Exception {
            selector.initTreeData();
            selector.getUserNodeLabels().clear();
            if (selector.getRootNode() != null) {
                WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
                UIApplication uiApp = context.getUIApplication();
                uiApp.addMessage(new ApplicationMessage("UINavigationNodeSelector.msg." + error.name(), null, 0));
            }
        }
    }
}

