/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import java.util.ArrayList;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormRadioBoxInput;

@ComponentConfig(template="war:/groovy/social/webui/space/UIVisibilityFormInputSet.gtmpl", events={@EventConfig(listeners={ChangeVisibilityActionListener.class})})
public class UISpaceVisibility
extends UIFormInputSet {
    public static final String UI_SPACE_REGISTRATION = "UIRegistration";
    private static final String REGISTRATION_BINDING = "registration";
    private String visibility;

    public UISpaceVisibility(String name) throws Exception {
        super(name);
        this.setComponentConfig(((Object)((Object)this)).getClass(), null);
        this.setVisibility("private");
        ArrayList<SelectItemOption> spaceRegistration = new ArrayList<SelectItemOption>(3);
        SelectItemOption openOption = new SelectItemOption((Object)"open");
        openOption.setSelected(true);
        spaceRegistration.add(openOption);
        SelectItemOption validationOption = new SelectItemOption((Object)"validation");
        spaceRegistration.add(validationOption);
        SelectItemOption closeOption = new SelectItemOption((Object)"close");
        spaceRegistration.add(closeOption);
        UIFormRadioBoxInput uiRadioRegistration = new UIFormRadioBoxInput(UI_SPACE_REGISTRATION, REGISTRATION_BINDING, spaceRegistration);
        uiRadioRegistration.setValue((Object)"open");
        this.addUIFormInput((UIFormInput)uiRadioRegistration);
    }

    public void setVisibility(String visibility) {
        this.visibility = visibility;
    }

    public String getVisibility() {
        return this.visibility;
    }

    public static class ChangeVisibilityActionListener
    extends EventListener<UISpaceVisibility> {
        public void execute(Event<UISpaceVisibility> event) throws Exception {
            UISpaceVisibility uiSpaceVisibility = (UISpaceVisibility)((Object)event.getSource());
            String oldVisibility = uiSpaceVisibility.getVisibility();
            String visibility = "hidden".equals(oldVisibility) ? "private" : "hidden";
            uiSpaceVisibility.setVisibility(visibility);
            WebuiRequestContext ctx = event.getRequestContext();
            ctx.addUIComponentToUpdateByAjax((UIComponent)uiSpaceVisibility);
        }
    }
}

