/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.extras.injection;

import java.util.HashMap;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.extras.injection.AbstractSocialInjector;
import org.exoplatform.social.extras.injection.utils.LoremIpsum4J;

public class ActivityMentionInjector
extends AbstractSocialInjector {
    private static final String NUMBER = "number";
    private static final String FROM_USER = "fromUser";
    private static final String TO_USER = "toUser";
    private static final String USER_PREFIX = "userPrefix";
    private static final String MENTIONER = "mentioner";

    public void inject(HashMap<String, String> params) throws Exception {
        int number = this.param(params, NUMBER);
        int from = this.param(params, FROM_USER);
        int to = this.param(params, TO_USER);
        String userPrefix = params.get(USER_PREFIX);
        String mentioner = params.get(MENTIONER);
        this.init(userPrefix, null);
        String provider = "organization";
        String base = this.userBase;
        Identity identityMentioner = this.identityManager.getOrCreateIdentity(provider, mentioner, false);
        String toMentioner = null;
        if (identityMentioner != null) {
            toMentioner = "@" + identityMentioner.getRemoteId();
        } else {
            this.getLog().info((Object)("'" + mentioner + "' is a wrong value for mentioner's remoteId parameter. Please set it correctly. Aborting injection ..."));
        }
        for (int i = from; i <= to; ++i) {
            String fromUser = base + i;
            Identity identity = this.identityManager.getOrCreateIdentity(provider, fromUser, false);
            for (int j = 0; j < number; ++j) {
                ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
                this.lorem = new LoremIpsum4J();
                activity.setBody(this.lorem.getWords(10));
                activity.setTitle(toMentioner + " " + this.lorem.getParagraphs());
                this.activityManager.saveActivity(identity, "DEFAULT_ACTIVITY", activity.getTitle());
                this.getLog().info((Object)("Activity for " + fromUser + " generated"));
            }
        }
    }
}

