/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.extras.injection;

import java.util.HashMap;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.extras.injection.AbstractSocialInjector;

public class MembershipInjector
extends AbstractSocialInjector {
    private static final String MEMBERSHIP_TYPE = "type";
    private static final String FROM_USER = "fromUser";
    private static final String TO_USER = "toUser";
    private static final String USER_PREFIX = "userPrefix";
    private static final String FROM_SPACE = "fromSpace";
    private static final String TO_SPACE = "toSpace";
    private static final String SPACE_PREFIX = "spacePrefix";
    private String identitiesInfo = "";

    public void inject(HashMap<String, String> params) throws Exception {
        int floor;
        String type = params.get(MEMBERSHIP_TYPE);
        int fromUser = this.param(params, FROM_USER);
        int toUser = this.param(params, TO_USER);
        String userPrefix = params.get(USER_PREFIX);
        int fromSpace = this.param(params, FROM_SPACE);
        int toSpace = this.param(params, TO_SPACE);
        String spacePrefix = params.get(SPACE_PREFIX);
        if (!"manager".equals(type) && !"member".equals(type)) {
            this.getLog().info((Object)("'" + type + "' is a wrong value for membership type parameter. Please set it to 'member' or 'manager'. Aborting injection ..."));
            return;
        }
        this.init(userPrefix, spacePrefix);
        this.getLog().info((Object)"About to inject Space Members :");
        this.getLog().info((Object)("" + (toSpace - fromSpace + 1) + " space(s) has prefix '" + spacePrefix + " ' with " + (toUser - fromUser + 1) + " member(s) has prefix '" + userPrefix + "'"));
        for (int i = floor = fromSpace; i <= toSpace; ++i) {
            this.generate(i, type, fromUser, toUser);
        }
        this.getLog().info((Object)"completed to inject Space Members");
    }

    private void generate(int spaceIdx, String type, int from, int to) {
        String spacePrettyBaseName = this.spaceBase.replace(".", "");
        String spaceName = spacePrettyBaseName + spaceIdx;
        Space space = this.spaceService.getSpaceByPrettyName(spaceName);
        if (space == null) {
            this.getLog().info((Object)("space with display name: " + spaceName + "is not existing"));
            return;
        }
        this.getLog().info((Object)("added users " + this.identitiesInfo + " to " + type + " of '" + spaceName + "' space."));
        Identity identity = null;
        for (int i = from; i <= to; ++i) {
            String username = this.userBase + i;
            identity = this.identityManager.getOrCreateIdentity("organization", username, false);
            if ("member".endsWith(type)) {
                this.spaceService.addMember(space, identity.getRemoteId());
                continue;
            }
            if (!"manager".endsWith(type)) continue;
            this.spaceService.setManager(space, identity.getRemoteId(), true);
        }
    }
}

