/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.extras.injection;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.extras.injection.AbstractSocialInjector;

public class RelationshipInjector
extends AbstractSocialInjector {
    private static final String NUMBER = "number";
    private static final String FROM_USER = "fromUser";
    private static final String TO_USER = "toUser";
    private static final String PREFIX = "prefix";

    public void inject(HashMap<String, String> params) throws Exception {
        int number = this.param(params, NUMBER);
        int from = this.param(params, FROM_USER);
        int to = this.param(params, TO_USER);
        String prefix = params.get(PREFIX);
        this.init(prefix, null);
        if (number <= 0) {
            this.getLog().error((Object)("Number have to be positive. Value '" + number + "' incorrect. Aborting injection ..."));
            return;
        }
        Map<Integer, Integer> computed = this.compute(from, to, number);
        this.getLog().info((Object)"About to inject relationships :");
        for (Map.Entry<Integer, Integer> e : computed.entrySet()) {
            this.getLog().info((Object)("" + e.getKey() + " user(s) with " + e.getValue() + " connection(s)"));
        }
        int floor = from;
        for (Map.Entry<Integer, Integer> e : computed.entrySet()) {
            this.generate(e, floor);
            floor += e.getKey().intValue();
        }
    }

    private void generate(Map.Entry<Integer, Integer> e, int floor) {
        for (int i = floor; i < floor + e.getKey(); ++i) {
            for (int j = floor; j < floor + e.getKey(); ++j) {
                String fromUser = this.userBase + i;
                String toUser = this.userBase + j;
                if (i > j) {
                    this.getLog().info((Object)("Relationship between " + fromUser + " and " + toUser + " already exists"));
                    continue;
                }
                if (i == j) continue;
                Identity identity1 = this.identityManager.getOrCreateIdentity("organization", fromUser, false);
                Identity identity2 = this.identityManager.getOrCreateIdentity("organization", toUser, false);
                Relationship r = new Relationship(identity1, identity2, Relationship.Type.CONFIRMED);
                this.relationshipManager.saveRelationship(r);
                this.getLog().info((Object)("Relationship between " + fromUser + " and " + toUser + " generated"));
            }
        }
    }

    public boolean isPossible(int a, int b, int c) {
        return ((float)(b - a) + 1.0f) % ((float)c + 1.0f) == 0.0f;
    }

    public Map<Integer, Integer> compute(int a, int b, int c) {
        LinkedHashMap<Integer, Integer> result = new LinkedHashMap<Integer, Integer>();
        if (c > b - a) {
            result.put(b - a + 1, b - a);
        } else if (this.isPossible(a, b, c)) {
            result.put(b - a + 1, c);
        } else {
            int group = (int)(((float)(b - a) + 1.0f) / ((float)c + 1.0f));
            int exact = group * (c + 1);
            int remaining = b - a + 1 - exact;
            result.put(exact, c);
            result.put(remaining, remaining - 1);
        }
        return result;
    }
}

