/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.extras.injection;

import java.util.HashMap;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.extras.injection.AbstractSocialInjector;
import org.exoplatform.social.extras.injection.PatternInjectorConfig;
import org.exoplatform.social.extras.injection.utils.LoremIpsum4J;

public class ActivityInjector
extends AbstractSocialInjector {
    private static final String NUMBER = "number";
    private static final String FROM_USER = "fromUser";
    private static final String TO_USER = "toUser";
    private static final String TYPE = "type";
    private static final String USER_PREFIX = "userPrefix";
    private static final String SPACE_PREFIX = "spacePrefix";

    public ActivityInjector(PatternInjectorConfig pattern) {
        super(pattern);
    }

    public void inject(HashMap<String, String> params) throws Exception {
        int number = this.param(params, NUMBER);
        int from = this.param(params, FROM_USER);
        int to = this.param(params, TO_USER);
        String type = params.get(TYPE);
        String userPrefix = params.get(USER_PREFIX);
        String spacePrefix = params.get(SPACE_PREFIX);
        this.init(userPrefix, spacePrefix, userSuffixValue, spaceSuffixValue);
        if (!"space".equals(type) && !"user".equals(type)) {
            this.getLog().info((Object)("'" + type + "' is a wrong value for type parameter. Please set it to 'user' or 'space'. Aborting injection ..."));
            return;
        }
        String provider = null;
        if ("space".equals(type)) {
            provider = "space";
        } else if ("user".equals(type)) {
            provider = "organization";
        }
        for (int i = from; i <= to; ++i) {
            String fromUser;
            if (provider.equalsIgnoreCase("organization")) {
                fromUser = this.userNameSuffixPattern(i);
            } else {
                fromUser = this.spaceNameSuffixPattern(i);
                fromUser = fromUser.replace(".", "");
            }
            Identity identity = this.identityManager.getOrCreateIdentity(provider, fromUser, false);
            for (int j = 0; j < number; ++j) {
                ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
                this.lorem = new LoremIpsum4J();
                activity.setBody(this.lorem.getWords(10));
                activity.setTitle(this.lorem.getParagraphs());
                this.activityManager.saveActivity(identity, "DEFAULT_ACTIVITY", activity.getTitle());
                this.getLog().info((Object)("Activity for " + fromUser + " generated"));
            }
        }
    }
}

