/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.portlet.userNotification;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.View;
import juzu.impl.common.JSON;
import juzu.request.RenderContext;
import juzu.template.Template;
import org.exoplatform.commons.api.notification.model.GroupProvider;
import org.exoplatform.commons.api.notification.model.PluginInfo;
import org.exoplatform.commons.api.notification.model.UserSetting;
import org.exoplatform.commons.api.notification.plugin.config.PluginConfig;
import org.exoplatform.commons.api.notification.service.setting.PluginSettingService;
import org.exoplatform.commons.api.notification.service.setting.UserSettingService;
import org.exoplatform.commons.juzu.ajax.Ajax;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.webui.application.WebuiRequestContext;

public class UserNotificationSetting {
    private static final Log LOG = ExoLogger.getLogger(UserNotificationSetting.class);
    @Inject
    @Path(value="index.gtmpl")
    Template index;
    @Inject
    ResourceBundle bundle;
    @Inject
    PluginSettingService providerSettingService;
    @Inject
    UserSettingService userSettingService;
    private static final String DAILY = "Daily";
    private static final String WEEKLY = "Weekly";
    private static final String NEVER = "Never";
    private static final String CHECK_BOX_DEACTIVATE_ID = "checkBoxDeactivate";
    private static final String SELECT_BOX_PREFIX = "SelectBox";
    private Locale locale = Locale.ENGLISH;

    @View
    public void index(RenderContext renderContext) {
        if (!CommonsUtils.isFeatureActive((String)"notification")) {
            this.redirectToHomePage();
            return;
        }
        if (renderContext != null) {
            this.locale = renderContext.getUserContext().getLocale();
        }
        if (this.bundle == null) {
            this.bundle = renderContext.getApplicationContext().resolveBundle(this.locale);
        }
        this.index.render(this.parameters());
    }

    @Ajax
    @Resource
    public Response saveSetting(String params) {
        JSON data = new JSON();
        try {
            UserSetting setting = UserSetting.getInstance();
            Map<String, String> datas = this.parserParams(params);
            for (String pluginId : datas.keySet()) {
                if (pluginId.indexOf(SELECT_BOX_PREFIX) > 0) {
                    String value = datas.get(pluginId);
                    pluginId = pluginId.replaceFirst(SELECT_BOX_PREFIX, "");
                    if (WEEKLY.equals(value)) {
                        setting.addProvider(pluginId, UserSetting.FREQUENCY.WEEKLY);
                    }
                    if (!DAILY.equals(value)) continue;
                    setting.addProvider(pluginId, UserSetting.FREQUENCY.DAILY);
                    continue;
                }
                if (CHECK_BOX_DEACTIVATE_ID.equals(pluginId)) continue;
                setting.addProvider(pluginId, UserSetting.FREQUENCY.INSTANTLY);
            }
            boolean status = !"on".equals(datas.get(CHECK_BOX_DEACTIVATE_ID));
            setting.setUserId(Utils.getOwnerRemoteId()).setActive(status);
            this.userSettingService.save(setting);
            data.set("ok", (Object)"true");
            data.set("status", (Object)String.valueOf(status));
        }
        catch (Exception e) {
            data.set("ok", (Object)"false");
            data.set("status", (Object)e.toString());
        }
        return Response.ok((CharSequence)data.toString()).withMimeType("application/json");
    }

    @Ajax
    @Resource
    public Response resetSetting(String params) {
        try {
            UserSetting setting = UserSetting.getDefaultInstance();
            this.userSettingService.save(setting.setUserId(Utils.getOwnerRemoteId()));
        }
        catch (Exception e) {
            return new Response.Error("Error to save default notification user setting" + e.toString());
        }
        return this.index.ok(this.parameters()).withMimeType("text/html");
    }

    private Map<String, Object> parameters() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Context context = new Context(this.bundle);
        parameters.put("_ctx", context);
        UserSetting setting = this.userSettingService.get(Utils.getOwnerRemoteId());
        String checkbox = setting.isActive() ? "" : "checked";
        parameters.put("checkbox", checkbox);
        parameters.put("checkboxId", CHECK_BOX_DEACTIVATE_ID);
        List groups = this.providerSettingService.getGroupPlugins();
        parameters.put("groups", groups);
        boolean hasActivePlugin = false;
        block0: for (GroupProvider group : groups) {
            for (PluginInfo plugin : group.getProviderDatas()) {
                if (!plugin.isActive()) continue;
                hasActivePlugin = true;
                continue block0;
            }
        }
        parameters.put("hasActivePlugin", hasActivePlugin);
        HashMap<String, String> selectBoxList = new HashMap<String, String>();
        HashMap<String, String> checkBoxList = new HashMap<String, String>();
        Map<String, String> options = this.buildOptions(context);
        for (String pluginId : this.providerSettingService.getActivePluginIds()) {
            selectBoxList.put(pluginId, this.buildSelectBox(pluginId, options, this.getValue(setting, pluginId)));
            checkBoxList.put(pluginId, this.buildCheckBox(pluginId, this.isInInstantly(setting, pluginId)));
        }
        parameters.put("checkBoxs", checkBoxList);
        parameters.put("selectBoxs", selectBoxList);
        return parameters;
    }

    private boolean isInInstantly(UserSetting setting, String pluginId) {
        return setting.isInInstantly(pluginId);
    }

    private String makeSelectBoxId(String providerId) {
        return new StringBuffer(providerId).append(SELECT_BOX_PREFIX).toString();
    }

    private String getValue(UserSetting setting, String providerId) {
        if (setting.isInWeekly(providerId)) {
            return WEEKLY;
        }
        if (setting.isInDaily(providerId)) {
            return DAILY;
        }
        return NEVER;
    }

    private Map<String, String> buildOptions(Context context) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(DAILY, context.appRes("UINotification.label.Daily"));
        options.put(WEEKLY, context.appRes("UINotification.label.Weekly"));
        options.put(NEVER, context.appRes("UINotification.label.Never"));
        return options;
    }

    private String buildCheckBox(String name, boolean isChecked) {
        StringBuffer buffer = new StringBuffer("<span class=\"uiCheckbox\">");
        buffer.append("<input type=\"checkbox\" class=\"checkbox\" ").append(isChecked ? "checked " : "").append("name=\"").append(name).append("\" id=\"").append(name).append("\" />").append("<span></span></span>");
        return buffer.toString();
    }

    private String buildSelectBox(String name, Map<String, String> options, String selectedId) {
        String selected = "";
        String id = this.makeSelectBoxId(name);
        StringBuffer buffer = new StringBuffer("<span class=\"uiSelectbox\">");
        buffer.append("<select name=\"").append(id).append("\" id=\"").append(id).append("\" class=\"selectbox\">");
        for (String key : options.keySet()) {
            selected = key.equals(selectedId) ? " selected=\"selected\" " : "";
            buffer.append("<option value=\"").append(key).append("\" class=\"option\"").append(selected).append(">").append(options.get(key)).append("</option>");
        }
        buffer.append("</select>").append("</span>");
        return buffer.toString();
    }

    private Map<String, String> parserParams(String params) {
        HashMap<String, String> datas = new HashMap<String, String>();
        String[] arrays = params.split("&");
        for (int i = 0; i < arrays.length; ++i) {
            String[] data = arrays[i].split("=");
            datas.put(data[0], data[1]);
        }
        return datas;
    }

    private void redirectToHomePage() {
        PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
        HttpServletRequest currentServletRequest = portalRequestContext.getRequest();
        StringBuilder sb = new StringBuilder();
        sb.append(currentServletRequest.getScheme()).append("://").append(currentServletRequest.getServerName()).append(":").append(currentServletRequest.getServerPort()).append("/").append(PortalContainer.getCurrentPortalContainerName()).append("/").append(portalRequestContext.getPortalOwner());
        WebuiRequestContext ctx = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        JavascriptManager jsManager = ctx.getJavascriptManager();
        jsManager.addJavascript((CharSequence)("try { window.location.href='" + sb.toString() + "' } catch(e) {" + "window.location.href('" + sb.toString() + "') }"));
    }

    public class Context {
        ResourceBundle rs;

        public Context(ResourceBundle rs) {
            this.rs = rs;
        }

        public String appRes(String key) {
            try {
                return this.rs.getString(key).replaceAll("'", "&#39;").replaceAll("\"", "&#34;");
            }
            catch (MissingResourceException e) {
                LOG.warn((Object)("Can't find resource for bundle key " + key));
            }
            catch (Exception e) {
                LOG.debug((Object)("Error when get resource bundle key " + key), (Throwable)e);
            }
            return key;
        }

        private String getBundlePath(String id) {
            PluginConfig pluginConfig = UserNotificationSetting.this.providerSettingService.getPluginConfig(id);
            if (pluginConfig != null) {
                return pluginConfig.getTemplateConfig().getBundlePath();
            }
            if (GroupProvider.defaultGroupIds.contains(id)) {
                return UserNotificationSetting.this.providerSettingService.getPluginConfig("DigestDailyPlugin").getTemplateConfig().getBundlePath();
            }
            List groups = UserNotificationSetting.this.providerSettingService.getGroupPlugins();
            for (GroupProvider groupProvider : groups) {
                if (!groupProvider.getGroupId().equals(id)) continue;
                return ((PluginInfo)groupProvider.getProviderDatas().get(0)).getBundlePath();
            }
            return "";
        }

        public String pluginRes(String key, String id) {
            String path = this.getBundlePath(id);
            return TemplateUtils.getResourceBundle((String)key, (Locale)UserNotificationSetting.this.locale, (String)path);
        }
    }
}

