/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.user.portlet;

import java.io.Writer;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.user.portlet.UIRelationshipAction;
import org.exoplatform.social.user.portlet.UserProfileHelper;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;

@ComponentConfig(lifecycle=UIContainerLifecycle.class, events={@EventConfig(listeners={ConnectActionListener.class}), @EventConfig(listeners={CancelActionListener.class}), @EventConfig(listeners={AcceptActionListener.class}), @EventConfig(listeners={DenyActionListener.class}), @EventConfig(listeners={DisconnectActionListener.class})})
public class UIRelationshipAction
extends UIContainer {
    private boolean isRenderedActions = true;

    public UIRelationshipAction setRenderedActions(boolean isRenderedActions) {
        this.isRenderedActions = isRenderedActions;
        return this;
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        Identity viewerIdentity = Utils.getViewerIdentity();
        Identity ownerIdentity = Utils.getOwnerIdentity();
        Writer writer = context.getWriter();
        writer.append("<div class=\"uiRelationshipAction clearfix\" id=\"").append(this.getId()).append("\">");
        writer.append("<div class=\"user-actions pull-right\" data-user-action=\"").append(ownerIdentity.getRemoteId()).append("\">");
        if (this.isRenderedActions && !ownerIdentity.equals((Object)viewerIdentity)) {
            Relationship.Type status;
            Relationship relationship = Utils.getRelationshipManager().get(viewerIdentity, ownerIdentity);
            Relationship.Type type = status = relationship != null ? relationship.getStatus() : null;
            if (status == null) {
                writer.append("<button class=\"btn btn-primary connect-status\" onclick=\"").append(this.event("Connect")).append("\">").append("<i class=\"uiIconStatusConnect\"></i>").append(UserProfileHelper.getLabel((WebuiRequestContext)context, (String)"UIBasicProfile.action.label.Connect")).append("</button>");
            } else if (status == Relationship.Type.PENDING) {
                if (relationship.getSender().equals((Object)viewerIdentity)) {
                    writer.append("<button class=\"btn\" onclick=\"").append(this.event("Cancel")).append("\">").append(UserProfileHelper.getLabel((WebuiRequestContext)context, (String)"UIBasicProfile.action.CancelRequest")).append("</button>");
                } else {
                    writer.append("&nbsp;<button class=\"btn btn-primary\" onclick=\"").append(this.event("Accept")).append("\">").append("<i class=\"uiIconStatusAccept\"></i> ").append(UserProfileHelper.getLabel((WebuiRequestContext)context, (String)"UIBasicProfile.action.AcceptRequest")).append("</button>");
                    writer.append("<button class=\"btn\" onclick=\"").append(this.event("Deny")).append("\">").append("<i class=\"uiIconStatusDeny\"></i> ").append(UserProfileHelper.getLabel((WebuiRequestContext)context, (String)"UIBasicProfile.action.Deny")).append("</button>");
                }
            } else if (status == Relationship.Type.CONFIRMED) {
                writer.append("<button class=\"btn show-default\">").append("<i class=\"uiIconStatusConnected\"></i> ").append(UserProfileHelper.getLabel((WebuiRequestContext)context, (String)"UIBasicProfile.label.Connected")).append("</button>");
                writer.append("<button class=\"btn hide-default\" onclick=\"").append(this.event("Disconnect")).append("\">").append("<i class=\"uiIconStatusDisconnect\"></i> ").append(UserProfileHelper.getLabel((WebuiRequestContext)context, (String)"UIBasicProfile.action.RemoveConnection")).append("</button>");
            }
            writer.append("</div>");
            writer.append("</div>");
        } else {
            super.processRender(context);
        }
    }
}

