/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.user.profile;

import java.util.List;
import java.util.Map;
import org.exoplatform.social.core.identity.model.Profile;

public abstract class UserProfileComparator {
    abstract boolean hasChanged();

    public boolean hasChanged(Profile profile, String key, String newValue) {
        String oldValue = (String)profile.getProperty(key);
        if (oldValue != null ? !oldValue.equals(newValue) : newValue != null) {
            profile.setProperty(key, (Object)newValue);
            return true;
        }
        return false;
    }

    public boolean hasChanged(Profile profile, String key, List<Map<String, String>> newValue) {
        List oldValue = (List)profile.getProperty(key);
        if ((oldValue == null || oldValue.isEmpty()) && (newValue == null || newValue.isEmpty())) {
            return false;
        }
        if (oldValue == null || !this.isEquals(oldValue, newValue)) {
            profile.setProperty(key, newValue);
            return true;
        }
        return false;
    }

    private boolean isEquals(List<Map<String, String>> list1, List<Map<String, String>> list2) {
        if (list2 == null) {
            return true;
        }
        if (list1.size() != list2.size()) {
            return false;
        }
        int size = list1.size();
        for (int i = 0; i < size; ++i) {
            if (this.isEqual(list1.get(i), list2.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isEqual(Map<String, String> m1, Map<String, String> m2) {
        if (m1.size() != m2.size()) {
            return false;
        }
        for (String key : m1.keySet()) {
            String val1 = String.valueOf(m1.get(key));
            String val2 = String.valueOf(m2.get(key));
            if ((val1 != null || val2 == null) && (val1 == null || val1.equals(val2))) continue;
            return false;
        }
        return true;
    }
}

