/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.user.portlet;

import java.util.List;
import javax.portlet.MimeResponse;
import javax.portlet.ResourceRequest;
import org.apache.commons.lang.StringEscapeUtils;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.user.portlet.UIAbstractUserPortlet;
import org.exoplatform.social.user.portlet.UIMiniConnectionsPortlet;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;
import org.json.JSONObject;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/groovy/social/portlet/user/UIMiniConnectionsPortlet.gtmpl", events={@EventConfig(listeners={RemoveConnectionActionListener.class})})
public class UIMiniConnectionsPortlet
extends UIAbstractUserPortlet {
    protected static final int MAX_DISPLAY = 12;
    private static final String PROFILE_LOADING_RESOURCE = "profile-loading";
    private static final String SIZE_LOADING_RESOURCE = "size-loading";
    private static int connectionSize = 0;

    public void afterProcessRender(WebuiRequestContext context) {
        super.afterProcessRender(context);
        context.getJavascriptManager().getRequireJS().require("SHARED/user-profile", "userprofile").addScripts("userprofile.loadingProfile('" + this.getId() + "');");
    }

    private int getAllSize() throws Exception {
        return Utils.getRelationshipManager().getConnectionsByFilter(this.currentProfile.getIdentity(), new ProfileFilter()).getSize();
    }

    public void serveResource(WebuiRequestContext context) throws Exception {
        super.serveResource(context);
        ResourceRequest req = (ResourceRequest)context.getRequest();
        MimeResponse res = (MimeResponse)context.getResponse();
        String resourceId = req.getResourceID();
        if (PROFILE_LOADING_RESOURCE.equals(resourceId)) {
            res.setContentType("text/html");
            res.getWriter().write(this.profileListHTML());
        } else if (SIZE_LOADING_RESOURCE.equals(resourceId)) {
            res.setContentType("application/json");
            int size = connectionSize < 12 ? connectionSize : this.getAllSize();
            JSONObject object = new JSONObject();
            object.put("size", size);
            object.put("showAll", size > 0);
            res.getWriter().write(object.toString());
        }
    }

    private String profileListHTML() throws Exception {
        StringBuilder html = new StringBuilder("");
        List identities = Utils.getRelationshipManager().getLastConnections(this.currentProfile.getIdentity(), 12);
        connectionSize = identities.size();
        for (Identity identity : identities) {
            ProfileBean profile = new ProfileBean(this, identity);
            html.append("<a href=\"").append(profile.getProfileURL()).append("\" class=\"avatarXSmall\" data-link=\"").append(this.event("RemoveConnection")).append("\">\n  <img alt=\"").append(StringEscapeUtils.escapeHtml((String)profile.getDisplayName())).append("\" src=\"").append(profile.getAvatarURL()).append("\"/>\n</a>\n");
        }
        return html.toString();
    }
}

