/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.user.portlet;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.user.UIRecentActivity;
import org.exoplatform.social.user.portlet.UIAbstractUserPortlet;
import org.exoplatform.social.user.portlet.UIRecentActivitiesPortlet;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="war:/groovy/social/portlet/user/UIRecentActivitiesPortlet.gtmpl", events={@EventConfig(listeners={LoadActivityActionListener.class})})
public class UIRecentActivitiesPortlet
extends UIAbstractUserPortlet {
    private static int LATEST_ACTIVITIES_NUM = 5;
    private static int ACTIVITIES_NUM_TO_CHECK = 6;
    protected boolean hasActivityBottomIcon = false;

    protected List<String> getRecentActivities() throws Exception {
        RealtimeListAccess activitiesListAccess = null;
        activitiesListAccess = this.currentProfile.getIdentity().getId().equals(Utils.getViewerIdentity().getId()) ? Utils.getActivityManager().getActivitiesWithListAccess(this.currentProfile.getIdentity()) : Utils.getActivityManager().getActivitiesWithListAccess(this.currentProfile.getIdentity(), Utils.getViewerIdentity());
        List<String> results = activitiesListAccess.loadIdsAsList(0, ACTIVITIES_NUM_TO_CHECK);
        boolean bl = this.hasActivityBottomIcon = results.size() <= LATEST_ACTIVITIES_NUM;
        if (!this.hasActivityBottomIcon) {
            results = results.subList(0, LATEST_ACTIVITIES_NUM);
        }
        for (String activityId : results) {
            String childId = UIRecentActivity.buildComponentId((String)activityId);
            if (this.getChildById(childId) != null) continue;
            this.addChild(UIRecentActivity.class, null, childId);
        }
        this.removeIfExisting(results);
        return results;
    }

    protected String getLoadActivityUrl() throws Exception {
        return this.event("LoadActivity").replace("javascript:ajaxGet('", "").replace("')", "&objectId=");
    }

    protected Identity getOwnerActivity(ExoSocialActivity activity) {
        return Utils.getIdentityManager().getIdentity(activity.getUserId(), true);
    }

    private void removeIfExisting(List<String> results) {
        ArrayList<UIComponent> removeChilds = new ArrayList<UIComponent>();
        for (UIComponent uiComponent : this.getChildren()) {
            if (results.contains(uiComponent.getId())) continue;
            removeChilds.add(uiComponent);
        }
        for (UIComponent uiComponent : removeChilds) {
            uiComponent.setParent(null);
            this.getChildren().remove(uiComponent);
        }
    }

    public void initProfilePopup() throws Exception {
        super.initProfilePopup();
    }

    public void initSpacePopup() throws Exception {
        super.initSpacePopup();
    }
}

