/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.user.form;

import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.social.user.form.UIInputSection;
import org.exoplatform.social.user.form.UIMultiValueSelection;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormDateTimeInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputBase;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormMultiValueInputSet;

public class UIInputSection
extends UIFormInputSet {
    private Map<String, List<ActionData>> actionFields = new HashMap();
    private boolean useGroupControl = true;
    private String title;
    private String cssClass;

    public UIInputSection() {
    }

    public String getCssClass() {
        return this.cssClass;
    }

    public UIInputSection setCssClass(String cssClass) {
        this.cssClass = cssClass;
        return this;
    }

    public UIInputSection(String name) {
        super(name);
    }

    public UIInputSection(String name, String title) {
        this(name);
        this.title = title;
    }

    public UIInputSection(String name, String title, String cssClass) {
        this(name, title);
        this.cssClass = cssClass;
    }

    public UIFormDateTimeInput getUIFormDateTimeInput(String name) {
        return (UIFormDateTimeInput)this.findComponentById(name);
    }

    public UIMultiValueSelection getUIMultiValueSelection(String id) {
        return (UIMultiValueSelection)this.findComponentById(id);
    }

    public UIFormMultiValueInputSet getUIFormMultiValueInputSet(String id) {
        return (UIFormMultiValueInputSet)this.findComponentById(id);
    }

    public UIFormInput<?> addUIFormInput(UIFormInput<?> input, List<ActionData> actions) {
        this.addUIFormInput(input);
        this.actionFields.put(input.getName(), actions);
        return input;
    }

    public UIInputSection setActionField(String name, List<ActionData> actions) {
        this.actionFields.put(name, actions);
        return this;
    }

    public UIFormInputBase<?> addUIFormInput(UIFormInputBase<?> input, String label) {
        input.setLabel(label);
        this.addUIFormInput(input);
        return input;
    }

    public boolean useGroupControl() {
        return this.useGroupControl;
    }

    public UIInputSection useGroupControl(boolean useGroupControl) {
        this.useGroupControl = useGroupControl;
        return this;
    }

    public UIInputSection setTitle(String title) {
        this.title = title;
        return this;
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        UIForm uiForm = (UIForm)this.getParent();
        Writer w = context.getWriter();
        w.append("<div class=\"form-horizontal ").append(this.cssClass != null ? this.cssClass : "").append("\" id=\"").append(this.getId()).append("\">");
        w.append("<h4 class=\"titleWithBorder\">");
        if (this.title != null && this.title.length() > 0) {
            w.append("<span class=\"nameTitle\">").append(uiForm.getLabel(this.title)).append("</span>");
        } else {
            w.append("&nbsp;");
        }
        w.append("</h4>");
        String classLable = this.useGroupControl ? "control-label" : "input-label";
        String classControlGroup = this.useGroupControl ? "control-group" : "input-group";
        String classControl = this.useGroupControl ? "controls" : "input-controls clearfix";
        for (UIComponent inputEntry : this.getChildren()) {
            if (!inputEntry.isRendered()) continue;
            String label = inputEntry instanceof UIFormInputBase ? ((UIFormInputBase)inputEntry).getLabel() : inputEntry.getId();
            w.append("<div class=\"").append(classControlGroup).append("\">");
            if (label != null && !label.isEmpty()) {
                w.append("<label class=\"").append(classLable).append("\" for=\"" + inputEntry.getId() + "\">");
                w.append(uiForm.getLabel(label)).append(":");
                w.append("</label>");
            }
            w.append("<div class=\"").append(classControl).append("\">");
            this.renderUIComponent(inputEntry);
            List actions = (List)this.actionFields.get(inputEntry.getName());
            if (actions != null) {
                for (ActionData action : actions) {
                    String link = action.getLink();
                    if (link == null && action.getAction() != null) {
                        link = uiForm.event(action.getAction(), action.getObjectId());
                    }
                    if (link != null) {
                        w.append("<a title=\"").append(action.getTooltip()).append("\" class=\"actionIcon\" rel=\"tooltip\" data-placement=\"bottom\" href=\"").append(link).append("\">");
                        if (action.getIcon() != null) {
                            w.append("<i class=\"" + action.getIcon() + " uiIconLightGray\"></i>");
                        }
                        if (action.getActionLabel() != null) {
                            w.append(action.getActionLabel());
                        }
                        w.append("</a>&nbsp;");
                        continue;
                    }
                    if (action.getActionLabel() == null) continue;
                    w.append("<span class=\"info-label\">").append(action.getActionLabel()).append("</span>&nbsp;");
                }
            }
            w.append("  </div>");
            w.append("</div>");
        }
        w.append("</div>");
    }
}

