/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.user.portlet;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.user.portlet.UIAbstractUserPortlet;
import org.exoplatform.social.user.portlet.UserProfileHelper;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;
import org.exoplatform.webui.utils.TimeConvertUtils;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="war:/groovy/social/portlet/user/UIExperienceProfilePortlet.gtmpl")
public class UIExperienceProfilePortlet
extends UIAbstractUserPortlet {
    private static final String DATE_FORMAT_MMDDYYYY = "MM/dd/yyyy";
    private static final String DATE_FORMAT_MMMMDDYYYY = "MMMM dd, yyyy";

    protected String getAboutMe() {
        String about = (String)this.currentProfile.getProperty("aboutMe");
        return StringUtils.isBlank((CharSequence)about) ? "" : StringEscapeUtils.escapeHtml4((String)about);
    }

    protected List<Map<String, String>> getExperiences() {
        List experiences = UserProfileHelper.getSortedExperiences((Profile)this.currentProfile);
        ArrayList<Map<String, String>> escapedExperiences = new ArrayList<Map<String, String>>();
        if (experiences != null) {
            for (Map experience : experiences) {
                String endDate;
                Map escapedExperience = UserProfileHelper.escapeExperience((Map)experience);
                String startDate = (String)escapedExperience.get("startDate");
                if (StringUtils.isNotBlank((CharSequence)startDate)) {
                    escapedExperience.put("startDate", this.convertDate(startDate));
                }
                if (StringUtils.isNotBlank((CharSequence)(endDate = (String)escapedExperience.get("endDate")))) {
                    escapedExperience.put("endDate", this.convertDate(endDate));
                }
                escapedExperiences.add(escapedExperience);
            }
        }
        return escapedExperiences;
    }

    private String convertDate(String sDate) {
        try {
            SimpleDateFormat sd = new SimpleDateFormat(DATE_FORMAT_MMDDYYYY, Locale.ENGLISH);
            return TimeConvertUtils.getFormatDate((Date)sd.parse(sDate), (String)DATE_FORMAT_MMMMDDYYYY);
        }
        catch (Exception e) {
            return sDate;
        }
    }
}

