/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.portlet;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.portlet.MimeResponse;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceURL;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.portal.mop.navigation.GenericScope;
import org.exoplatform.portal.mop.navigation.NodeChange;
import org.exoplatform.portal.mop.navigation.NodeChangeListener;
import org.exoplatform.portal.mop.navigation.NodeChangeQueue;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserNodeFilterConfig;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.portlet.UISpacesToolBarPortlet;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;
import org.json.JSONArray;
import org.json.JSONObject;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="war:/groovy/social/portlet/UISpacesToolBarPortlet.gtmpl")
public class UISpacesToolBarPortlet
extends UIPortletApplication {
    private static final String SPACE_SETTINGS = "settings";
    protected static final int DEFAULT_LEVEL = 2;
    private Scope toolbarScope;
    private UserNodeFilterConfig toolbarFilterConfig;
    private SpaceService spaceService = null;
    private String userId = null;

    public UISpacesToolBarPortlet() throws Exception {
        int level = 2;
        try {
            PortletRequestContext context = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
            PortletRequest prequest = context.getRequest();
            PortletPreferences prefers = prequest.getPreferences();
            level = Integer.valueOf(prefers.getValue("level", String.valueOf(2)));
        }
        catch (Exception ex) {
            log.warn((Object)"Preference for navigation level can only be integer");
        }
        this.toolbarScope = level <= 0 ? Scope.ALL : GenericScope.treeShape((int)level);
        UserNodeFilterConfig.Builder builder = UserNodeFilterConfig.builder();
        builder.withReadWriteCheck().withVisibility(Visibility.DISPLAYED, new Visibility[]{Visibility.TEMPORAL});
        builder.withTemporalCheck();
        this.toolbarFilterConfig = builder.build();
    }

    public List<UserNavigation> getSpaceNavigations() throws Exception {
        String remoteUser = this.getUserId();
        List spaces = this.getSpaceService().getAccessibleSpaces(remoteUser);
        UserPortal userPortal = SpaceUtils.getUserPortal();
        List allNavigations = userPortal.getNavigations();
        LinkedList<UserNavigation> navigations = new LinkedList<UserNavigation>();
        for (UserNavigation navi : allNavigations) {
            navigations.add(navi);
        }
        Iterator navigationItr = navigations.iterator();
        while (navigationItr.hasNext()) {
            String ownerId = ((UserNavigation)navigationItr.next()).getKey().getName();
            if (ownerId.startsWith("/spaces")) {
                String[] navigationParts = ownerId.split("/");
                Space space = this.spaceService.getSpaceByUrl(navigationParts[2]);
                if (space == null) {
                    space = this.spaceService.getSpaceByGroupId("/spaces/" + navigationParts[2]);
                }
                if (space == null) {
                    navigationItr.remove();
                }
                if (navigationParts[1].equals("spaces") || spaces.contains(space)) continue;
                navigationItr.remove();
                continue;
            }
            navigationItr.remove();
        }
        Collections.sort(navigations, new SpaceNameComparator(this, null));
        return navigations;
    }

    public boolean isRender(UserNode spaceNode, UserNode applicationNode) throws SpaceException {
        Space space;
        SpaceService spaceSrv = this.getSpaceService();
        String remoteUser = this.getUserId();
        String spaceUrl = spaceNode.getURI();
        if (spaceUrl.contains("/")) {
            spaceUrl = spaceUrl.split("/")[0];
        }
        if ((space = spaceSrv.getSpaceByUrl(spaceUrl)) == null) {
            return false;
        }
        if (spaceSrv.hasSettingPermission(space, remoteUser)) {
            return true;
        }
        return !SPACE_SETTINGS.equals(applicationNode.getName());
    }

    protected UserNode getSelectedNode() throws Exception {
        return Util.getUIPortal().getSelectedUserNode();
    }

    private SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        }
        return this.spaceService;
    }

    private String getUserId() {
        if (this.userId == null) {
            this.userId = Util.getPortalRequestContext().getRemoteUser();
        }
        return this.userId;
    }

    public Collection<UserNode> getNavigationNodes(UserNavigation nav) throws Exception {
        if (nav != null) {
            try {
                UserNode rootNodes = SpaceUtils.getUserPortal().getNode(nav, this.toolbarScope, this.toolbarFilterConfig, null);
                return rootNodes.getChildren();
            }
            catch (Exception ex) {
                log.warn((Object)(nav.getKey().getName() + " has been deleted"));
            }
        }
        return Collections.emptyList();
    }

    public void serveResource(WebuiRequestContext context) throws Exception {
        super.serveResource(context);
        ResourceRequest req = (ResourceRequest)context.getRequest();
        String id = req.getResourceID();
        JSONArray jsChilds = this.getChildrenAsJSON(this.getNodeFromResourceID(id));
        if (jsChilds == null) {
            return;
        }
        MimeResponse res = (MimeResponse)context.getResponse();
        res.setContentType("text/json");
        res.getWriter().write(jsChilds.toString());
    }

    private UserNode getNodeFromResourceID(String resourceId) throws Exception {
        UserNavigation currNav = this.getCurrentUserNavigation();
        if (currNav == null) {
            return null;
        }
        UserPortal userPortal = SpaceUtils.getUserPortal();
        UserNode node = userPortal.resolvePath(currNav, null, resourceId);
        if (node != null && node.getURI().equals(resourceId)) {
            return node;
        }
        return null;
    }

    public UserNavigation getCurrentUserNavigation() throws Exception {
        WebuiRequestContext rcontext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        return SpaceUtils.getUserPortal().getNavigation(SiteKey.user((String)rcontext.getRemoteUser()));
    }

    private JSONArray getChildrenAsJSON(UserNode userNode) throws Exception {
        if (userNode == null) {
            return null;
        }
        NodeChangeQueue queue = new NodeChangeQueue();
        SpaceUtils.getUserPortal().updateNode(userNode, this.toolbarScope, (NodeChangeListener)queue);
        for (NodeChange change : queue) {
            UserNode deletedNode;
            if (!(change instanceof NodeChange.Removed) || !this.hasRelationship(deletedNode = (UserNode)((NodeChange.Removed)change).getTarget(), userNode)) continue;
            return null;
        }
        Collection childs = userNode.getChildren();
        JSONArray jsChilds = new JSONArray();
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        MimeResponse res = (MimeResponse)context.getResponse();
        for (UserNode child : childs) {
            jsChilds.put((Object)this.toJSON(child, userNode.getNavigation().getKey().getName(), res));
        }
        return jsChilds;
    }

    private boolean hasRelationship(UserNode parent, UserNode userNode) {
        if (parent.getId().equals(userNode.getId())) {
            return true;
        }
        for (UserNode child : parent.getChildren()) {
            if (!this.hasRelationship(child, userNode)) continue;
            return true;
        }
        return false;
    }

    protected JSONObject toJSON(UserNode node, String navId, MimeResponse res) throws Exception {
        JSONObject json = new JSONObject();
        String nodeId = node.getId();
        json.put("label", (Object)node.getEncodedResolvedLabel());
        json.put("hasChild", node.getChildrenCount() > 0);
        json.put("isSelected", nodeId.equals(this.getSelectedNode().getId()));
        json.put("icon", (Object)node.getIcon());
        ResourceURL rsURL = res.createResourceURL();
        rsURL.setResourceID(res.encodeURL(this.getResourceIdFromNode(node, navId)));
        json.put("getNodeURL", (Object)rsURL.toString());
        json.put("actionLink", (Object)Utils.getSpaceURL((UserNode)node));
        JSONArray childs = new JSONArray();
        for (UserNode child : node.getChildren()) {
            childs.put((Object)this.toJSON(child, navId, res));
        }
        json.put("childs", (Object)childs);
        return json;
    }

    private String getResourceIdFromNode(UserNode node, String navId) throws Exception {
        if (node == null) {
            throw new IllegalArgumentException("node can't be null");
        }
        return node.getURI();
    }
}

