/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.swf.sonar.plugin.rules;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;

@Rule(key="RepositoryServiceUsage", name="Avoid using RepositoryService.getDefaultRepository() or RepositoryService.getRepository(name)", description="In order to support multi-tenancy, only RepositoryService.getCurrentRepository() must be used.", tags={"multi-tenancy"}, priority=Priority.BLOCKER)
@ActivatedByDefault
@SqaleConstantRemediation(value="15min")
public class RepositoryServiceUsageCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final String GET_DEFAULT_REPO_METHOD_NAME = "getDefaultRepository";
    private static final String GET_REPO_BY_NAME_METHOD_NAME = "getRepository";
    private static final String GET_DEFAULT_REPO_CLASS_NAME = "RepositoryService";
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitMethodInvocation(MethodInvocationTree tree) {
        String variableClassName;
        VariableTree variable;
        Symbol symbol;
        MemberSelectExpressionTree mset;
        if (tree.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && (mset = (MemberSelectExpressionTree)tree.methodSelect()).expression().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && (symbol = ((IdentifierTree)mset.expression()).symbol()).declaration() != null && symbol.declaration().is(new Tree.Kind[]{Tree.Kind.VARIABLE}) && (variable = (VariableTree)symbol.declaration()).type().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && GET_DEFAULT_REPO_CLASS_NAME.equals(variableClassName = ((IdentifierTree)variable.type()).name())) {
            if (GET_DEFAULT_REPO_METHOD_NAME.equals(mset.identifier().name())) {
                this.context.reportIssue((JavaCheck)this, (Tree)tree, "Don't use RepositoryService.getDefaultRepository()");
            } else if (GET_REPO_BY_NAME_METHOD_NAME.equals(mset.identifier().name())) {
                this.context.reportIssue((JavaCheck)this, (Tree)tree, "Don't use RepositoryService.getRepository(name)");
            }
        }
        super.visitMethodInvocation(tree);
    }
}

