/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.tcm;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.exoplatform.tcm.SummaryAggregator;
import org.exoplatform.tcm.TestCaseFunctionIdVsPriority;
import org.exoplatform.tcm.TestCaseFunctionInfo;
import org.exoplatform.tcm.TestCaseManager;
import org.jopendocument.dom.OOUtils;
import org.jopendocument.dom.spreadsheet.Sheet;
import org.jopendocument.dom.spreadsheet.SpreadSheet;
import org.jopendocument.dom.spreadsheet.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestCaseHelper {
    private static Logger logger = Logger.getLogger(TestCaseManager.class.getName());
    private final String INPUT_VALUE_SEPARATOR = ",";
    private final String TEST_DEFINITIONS_DIR = "TestDefinitions";
    private final String TESTRUN_PLAN_DIR = "TestPlan";
    private final String TESTRUN_PERFORMED_DIR = "TestRun";
    private final String COLUMN_NAME_PATH = "Path";
    private final String TEST_PLAN_SUFFIX = "_TestPlan.ods";
    private final String TEST_RESULT_SUFFIX = "_TestResults.ods";
    private final String TEST_CASES_DEFINITION_FILES_SUFFIX = "_TestDefinition.ods";
    private final String TEST_CASES_RUN_FILES_PREFIX = "TestCaseRun_";
    private final String TESTCAMPAIGN_PROPERTIES_FILENAME = "testcampaign.properties";
    private final String KEY_TEST_CAMPAIGN_TESTERS = "test.campaign.testers";
    private final String KEY_TEST_CAMPAIGN_NAME = "test.campaign.name";
    private final String KEY_TEST_CAMPAIGN_BROWSERS = "test.campaign.browsers";
    private final int COLUMN_CASE_NO_INDEX = 0;
    private final int COLUMN_RELATED_FUNCTION_INDEX = 1;
    private final int COLUMN_CASE_ID_INDEX = 2;
    private final int COLUMN_PATH_INDEX = 3;
    private final int COLUMN_STEP_DESC_INDEX = 5;
    private final int COLUMN_PRIORITY_INDEX = 8;
    private final String PRIORITY_HIGH = "High";
    private final String PRIORITY_MEDIUM = "Medium";
    private final String PRIORITY_LOW = "Low";
    private final String TOTAL_HIGH = "Total High";
    private final String TOTAL_MEDIUM = "Total Medium";
    private final String TOTAL_LOW = "Total Low";
    public final String TEST_PLAN_TEMPLATE = "TestPlanTemplate.ods";
    public final String TEST_RESULT_TEMPLATE = "TestResultTemplate.ods";

    public void generateAutoNumber(String testCampaignDirName) throws IOException {
        File dirname = new File(testCampaignDirName, "TestDefinitions");
        logger.log(Level.FINE, "Searching files prefixed by _TestDefinition.ods in " + dirname.getPath());
        File[] listFiles = this.getTestFiles(dirname);
        for (int i = 0; i < listFiles.length; ++i) {
            File file = listFiles[i];
            if (!file.getName().endsWith("_TestDefinition.ods")) continue;
            this.generateAutoNumberForSingleFile(file, testCampaignDirName);
        }
    }

    private void generateAutoNumberForSingleFile(File testDefinitionFile, String testCampaignDirName) throws IOException {
        SpreadSheet spreadSheet = SpreadSheet.createFromFile(testDefinitionFile);
        String filePath = testDefinitionFile.getPath();
        logger.log(Level.FINE, " Parsing file:" + filePath + " for generate auto number for CaseNo & CaseId columns");
        int sheetCount = spreadSheet.getSheetCount();
        for (int i = 0; i < sheetCount; ++i) {
            Integer caseNoCounter = 0;
            Integer caseIdCounter = 0;
            Sheet sheet = spreadSheet.getSheet(i);
            int rowCount = sheet.getRowCount();
            String sheetName = TestCaseHelper.getSheetName(sheet);
            if (!this.isTestCaseSheet(sheetName)) continue;
            String previousPath = null;
            int headerRow = 5;
            for (int row = headerRow + 1; row > 2 && row < rowCount; ++row) {
                String message = "row " + (row + 1) + " in sheet " + sheetName + " of " + filePath;
                String newPath = "" + sheet.getValueAt(3, row);
                String step = "" + sheet.getValueAt(5, row);
                if ("".equals(newPath)) break;
                if (!newPath.equals(previousPath)) {
                    caseIdCounter = 0;
                    previousPath = newPath;
                }
                if ("".equals(step)) continue;
                if (step.startsWith("Step 1:")) {
                    Integer n = caseNoCounter;
                    Integer n2 = caseNoCounter = Integer.valueOf(caseNoCounter + 1);
                    n = caseIdCounter;
                    n2 = caseIdCounter = Integer.valueOf(caseIdCounter + 1);
                    sheet.setValueAt(caseNoCounter, 0, row);
                    sheet.setValueAt(caseIdCounter, 2, row);
                    continue;
                }
                if (step.startsWith("Step ") && caseNoCounter > 0) {
                    sheet.setValueAt("", 0, row);
                    sheet.setValueAt(caseIdCounter, 2, row);
                    continue;
                }
                System.err.println("[ERROR] Step description missing at " + message);
            }
            testDefinitionFile = sheet.getSpreadSheet().saveAs(testDefinitionFile);
        }
    }

    private boolean validateTestDefinitionFormat(File testDefinitionFile) throws IOException {
        return this.validateNumbering(testDefinitionFile) && this.validatePriority(testDefinitionFile) && this.validateSamePriority(testDefinitionFile);
    }

    private boolean validateNumbering(File testDefinitionFile) throws IOException {
        boolean isOk = true;
        int errorCounter = 0;
        SpreadSheet spreadSheet = SpreadSheet.createFromFile(testDefinitionFile);
        String filePath = testDefinitionFile.getPath();
        logger.log(Level.FINE, " Parsing file:" + filePath + " for verifying Numbering");
        int sheetCount = spreadSheet.getSheetCount();
        block0: for (int i = 0; i < sheetCount; ++i) {
            Sheet sheet = spreadSheet.getSheet(i);
            int rowCount = sheet.getRowCount();
            String sheetName = TestCaseHelper.getSheetName(sheet);
            if (!this.isTestCaseSheet(sheetName)) continue;
            int headerRow = 5;
            int counter = 0;
            for (int row = headerRow + 1; row > 2 && row < rowCount; ++row) {
                String message = "row " + (row + 1) + " in sheet " + sheetName + " of " + filePath;
                String step = "" + sheet.getValueAt(5, row);
                if ("".equals(step)) continue block0;
                if (step.startsWith("Step 1:")) {
                    counter = 1;
                    continue;
                }
                if (!step.startsWith("Step ")) {
                    isOk = false;
                    if (counter < 1) {
                        ++errorCounter;
                        System.err.println("[ERROR] Numbering error at " + message + "\nPlease re-check your steps declaration at this row to make sure it follows this format (case sensitive): Step " + counter + ":");
                        continue;
                    }
                    ++errorCounter;
                    System.err.println("[ERROR] Numbering error at " + message + "\nPlease re-check your steps declaration at this row to make sure it follows these formats (case sensitive): Step " + (counter + 1) + ": or Step 1:");
                    continue;
                }
                ++counter;
            }
        }
        if (errorCounter > 0) {
            logger.log(Level.FINE, " Total " + errorCounter + " errors are detected for this step, please correct them before continue to next step!");
        } else {
            logger.log(Level.FINE, " Validation for this step finish successfully, move to next step...");
        }
        return isOk;
    }

    private boolean validatePriority(File testDefinitionFile) throws IOException {
        boolean isOk = true;
        int errorCounter = 0;
        SpreadSheet spreadSheet = SpreadSheet.createFromFile(testDefinitionFile);
        String filePath = testDefinitionFile.getPath();
        logger.log(Level.FINE, " Parsing file:" + filePath + " for verifying all priority are full filled");
        int sheetCount = spreadSheet.getSheetCount();
        block0: for (int i = 0; i < sheetCount; ++i) {
            Sheet sheet = spreadSheet.getSheet(i);
            int rowCount = sheet.getRowCount();
            String sheetName = TestCaseHelper.getSheetName(sheet);
            if (!this.isTestCaseSheet(sheetName)) continue;
            int headerRow = 5;
            for (int row = headerRow + 1; row > 2 && row < rowCount; ++row) {
                String message = "row " + (row + 1) + " in sheet " + sheetName + " of " + filePath;
                String priority = "" + sheet.getValueAt(8, row);
                String relatedFunction = "" + sheet.getValueAt(1, row);
                if ("".equals(relatedFunction)) continue block0;
                if ("".equals(priority)) {
                    isOk = false;
                    System.err.println("[ERROR] Empty data in Priority column at " + message);
                    ++errorCounter;
                    continue;
                }
                if (priority.trim().equalsIgnoreCase("High") || priority.trim().equalsIgnoreCase("Medium") || priority.trim().equalsIgnoreCase("Low")) continue;
                isOk = false;
                System.err.println("[ERROR] Priority type undefined for type : " + priority + " at " + message);
                ++errorCounter;
            }
        }
        if (errorCounter > 0) {
            logger.info(" Total " + errorCounter + " errors are detected for this step, please correct them before continue to next step!");
        } else {
            logger.log(Level.FINE, " Validation for this step finish successfully, move to next step...");
        }
        return isOk;
    }

    private boolean validateSamePriority(File testDefinitionFile) throws IOException {
        boolean isOk = true;
        int errorCounter = 0;
        SpreadSheet spreadSheet = SpreadSheet.createFromFile(testDefinitionFile);
        String filePath = testDefinitionFile.getPath();
        logger.log(Level.FINE, " Parsing file:" + filePath + " for verifying all steps in any test case have the same priority");
        int sheetCount = spreadSheet.getSheetCount();
        block0: for (int i = 0; i < sheetCount; ++i) {
            Sheet sheet = spreadSheet.getSheet(i);
            int rowCount = sheet.getRowCount();
            String sheetName = TestCaseHelper.getSheetName(sheet);
            if (!this.isTestCaseSheet(sheetName)) continue;
            int headerRow = 5;
            Float previousCaseId = new Float(0.0f);
            String previousPriority = null;
            for (int row = headerRow + 1; row > 2 && row < rowCount; ++row) {
                String message = "row " + (row + 1) + " in sheet " + sheetName + " of " + filePath;
                Object newCaseId = sheet.getValueAt(2, row);
                String newPriority = "" + sheet.getValueAt(8, row);
                String step = "" + sheet.getValueAt(5, row);
                if ("".equals(step)) continue block0;
                if (step.startsWith("Step 1:")) {
                    previousPriority = newPriority;
                    if (!(newCaseId instanceof Float)) continue;
                    previousCaseId = (Float)newCaseId;
                    continue;
                }
                if ("".equals(newPriority) || newPriority.equalsIgnoreCase(previousPriority) || !(newCaseId instanceof Float) || !newCaseId.equals(previousCaseId)) continue;
                isOk = false;
                ++errorCounter;
                System.err.println("[ERROR] Not the same priority for the same testcase at " + message);
            }
        }
        if (errorCounter > 0) {
            logger.info(" Total " + errorCounter + " errors are detected for this step, please correct them before continue to generate TestPlan process!");
        } else {
            logger.log(Level.FINE, " All validation steps for this file : \"" + testDefinitionFile.getName() + "\" finish successfully, move to next step...");
        }
        return isOk;
    }

    public void generateTestPlan(String testCampaignDirName) throws IOException {
        this.generateAutoNumber(testCampaignDirName);
        HashSet<Boolean> resultSet = new HashSet<Boolean>();
        HashMap<String, TestCaseFunctionInfo> theFunctionsByPaths = new HashMap<String, TestCaseFunctionInfo>();
        Properties testCampaignInfo = this.readTestCampaignInfo(testCampaignDirName);
        String testCampaignBrowsers = testCampaignInfo.getProperty("test.campaign.browsers", "ie,ff");
        String[] browsers = testCampaignBrowsers.split(",");
        File dirname = new File(testCampaignDirName, "TestDefinitions");
        logger.log(Level.FINE, " Searching files prefixed by _TestDefinition.ods in " + dirname.getPath());
        File[] listFiles = this.getTestFiles(dirname);
        for (int i = 0; i < listFiles.length; ++i) {
            File file = listFiles[i];
            if (!file.getName().endsWith("_TestDefinition.ods")) continue;
            Boolean isOk = this.validateTestDefinitionFormat(file);
            resultSet.add(isOk);
            if (!isOk.booleanValue()) continue;
            this.fillTestCaseFunctionsMap(file, theFunctionsByPaths, browsers, 1);
        }
        if (resultSet.contains(Boolean.TRUE)) {
            int i;
            int startTesterColumnChar;
            int startDataRow;
            String testersValue = testCampaignInfo.getProperty("test.campaign.testers", "tester1,tester2");
            String[] testers = testersValue.split(",");
            ArrayList functionIds = new ArrayList(theFunctionsByPaths.keySet());
            Collections.sort(functionIds);
            File file = new File("TestPlanTemplate.ods");
            InputStream template = TestCaseHelper.class.getResourceAsStream("/TestPlanTemplate.ods");
            this.convertInputStreamToFile(file, template);
            SpreadSheet testPlanSpreadSheet = SpreadSheet.createFromFile(file);
            Sheet sheet = testPlanSpreadSheet.getSheet(0);
            sheet.getElement().setAttribute("name", "TestPlan for " + testCampaignDirName, testPlanSpreadSheet.getNS().getTABLE());
            Sheet sheetColorPicker = testPlanSpreadSheet.getSheet("ColorPicker");
            Map<String, String> colorMap = this.getColorPickerList(sheetColorPicker);
            int headerRow = 3;
            int presentedColumnCount = -1;
            Object valueAt = null;
            while (!"".equals(valueAt)) {
                valueAt = sheet.getValueAt(++presentedColumnCount, headerRow);
            }
            int currentColumnCount = presentedColumnCount + testers.length;
            sheet.ensureColumnCount(currentColumnCount + 1);
            for (int i2 = 0; i2 < testers.length; ++i2) {
                sheet.setValueAt(testers[i2], presentedColumnCount + i2, headerRow);
            }
            sheet.setValueAt("Path", currentColumnCount, headerRow);
            int rowIndex = startDataRow = 4;
            sheet.ensureRowCount(functionIds.size() * 3 + rowIndex);
            for (String path : functionIds) {
                TestCaseFunctionInfo functionInfo = (TestCaseFunctionInfo)theFunctionsByPaths.get(path);
                sheet.setValueAt(functionInfo.getId(), 0, rowIndex);
                sheet.setValueAt(functionInfo.getRelatedFunction(), 1, rowIndex);
                sheet.setValueAt("High", 2, rowIndex);
                sheet.setValueAt(functionInfo.getHighPriorityNumber(), 3, rowIndex);
                sheet.setValueAt(functionInfo.getPath(), currentColumnCount, rowIndex);
                sheet.setValueAt(functionInfo.getId(), 0, ++rowIndex);
                sheet.setValueAt(functionInfo.getRelatedFunction(), 1, rowIndex);
                sheet.setValueAt("Medium", 2, rowIndex);
                sheet.setValueAt(functionInfo.getMediumPriorityNumber(), 3, rowIndex);
                sheet.setValueAt(functionInfo.getPath(), currentColumnCount, rowIndex);
                sheet.setValueAt(functionInfo.getId(), 0, ++rowIndex);
                sheet.setValueAt(functionInfo.getRelatedFunction(), 1, rowIndex);
                sheet.setValueAt("Low", 2, rowIndex);
                sheet.setValueAt(functionInfo.getLowPriorityNumber(), 3, rowIndex);
                sheet.setValueAt(functionInfo.getPath(), currentColumnCount, rowIndex);
                ++rowIndex;
            }
            int endDataRow = rowIndex;
            int priorityColumnPosition = 2;
            rowIndex = 0;
            sheet.setValueAt("Total High", priorityColumnPosition, rowIndex);
            sheet.getCellAt(priorityColumnPosition, rowIndex).setStyleName(colorMap.get("lightGreen"));
            sheet.setValueAt("=SUMIF(C" + (startDataRow + 1) + ":C" + endDataRow + ";\"" + "High" + "\";D" + (startDataRow + 1) + ":D" + endDataRow + ")", priorityColumnPosition + 1, rowIndex);
            sheet.setValueAt("Total Medium", priorityColumnPosition, ++rowIndex);
            sheet.getCellAt(priorityColumnPosition, rowIndex).setStyleName(colorMap.get("yellow"));
            sheet.setValueAt("=SUMIF(C" + (startDataRow + 1) + ":C" + endDataRow + ";\"" + "Medium" + "\";D" + (startDataRow + 1) + ":D" + endDataRow + ")", priorityColumnPosition + 1, rowIndex);
            sheet.setValueAt("Total Low", priorityColumnPosition, ++rowIndex);
            sheet.getCellAt(priorityColumnPosition, rowIndex).setStyleName(colorMap.get("blue"));
            sheet.setValueAt("=SUMIF(C" + (startDataRow + 1) + ":C" + endDataRow + ";\"" + "Low" + "\";D" + (startDataRow + 1) + ":D" + endDataRow + ")", priorityColumnPosition + 1, rowIndex);
            ++rowIndex;
            int startTesterColumnCodePointAt = startTesterColumnChar = 69;
            rowIndex -= 3;
            for (i = 0; i < testers.length; ++i) {
                sheet.setValueAt("=SUMPRODUCT((C" + (startDataRow + 1) + ":C" + endDataRow + "=\"" + "High" + "\")*(" + (char)(startTesterColumnCodePointAt + i) + (startDataRow + 1) + ":" + (char)(startTesterColumnCodePointAt + i) + endDataRow + "=\"x\")*D" + (startDataRow + 1) + ":D" + endDataRow + ")", priorityColumnPosition + 2 + i, rowIndex);
            }
            ++rowIndex;
            for (i = 0; i < testers.length; ++i) {
                sheet.setValueAt("=SUMPRODUCT((C" + (startDataRow + 1) + ":C" + endDataRow + "=\"" + "Medium" + "\")*(" + (char)(startTesterColumnCodePointAt + i) + (startDataRow + 1) + ":" + (char)(startTesterColumnCodePointAt + i) + endDataRow + "=\"x\")*D" + (startDataRow + 1) + ":D" + endDataRow + ")", priorityColumnPosition + 2 + i, rowIndex);
            }
            ++rowIndex;
            for (i = 0; i < testers.length; ++i) {
                sheet.setValueAt("=SUMPRODUCT((C" + (startDataRow + 1) + ":C" + endDataRow + "=\"" + "Low" + "\")*(" + (char)(startTesterColumnCodePointAt + i) + (startDataRow + 1) + ":" + (char)(startTesterColumnCodePointAt + i) + endDataRow + "=\"x\")*D" + (startDataRow + 1) + ":D" + endDataRow + ")", priorityColumnPosition + 2 + i, rowIndex);
            }
            ++rowIndex;
            int COLUMN_TC_COUNT_INDEX = 3;
            for (int i3 = 4; i3 < sheet.getRowCount(); ++i3) {
                for (int j = 0; j < sheet.getColumnCount(); ++j) {
                    if ((i3 - 1) / 3 % 2 == 0) {
                        sheet.getCellAt(j, i3).setStyleName("Default");
                        continue;
                    }
                    if (j == 3) {
                        sheet.getCellAt(j, i3).setStyleName(colorMap.get("grayRight"));
                        continue;
                    }
                    sheet.getCellAt(j, i3).setStyleName(colorMap.get("gray"));
                }
            }
            this.saveAsFile(testPlanSpreadSheet, testCampaignDirName + "/", testCampaignDirName + "_TestPlan.ods", false);
        }
    }

    private void convertInputStreamToFile(File file, InputStream inputStream) {
        try {
            int len;
            FileOutputStream out = new FileOutputStream(file);
            byte[] buf = new byte[1024];
            while ((len = inputStream.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((OutputStream)out).close();
            inputStream.close();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private Properties readTestCampaignInfo(String testCampaignDirName) throws IOException, FileNotFoundException {
        Properties properties = new Properties();
        File file = new File(testCampaignDirName, "testcampaign.properties");
        logger.log(Level.FINE, " Loading test campaign params in " + file.getPath());
        properties.load(new FileInputStream(file));
        return properties;
    }

    private File[] getTestFiles(File testDefDir) {
        if (!testDefDir.isDirectory()) {
            throw new RuntimeException("[ERROR] Dir expected for " + testDefDir);
        }
        return testDefDir.listFiles();
    }

    public boolean isTestCaseSheet(String sheetName) {
        return !"Summary_Report".equals(sheetName) && !"Notes".equals(sheetName) && !"Cover".equals(sheetName) && !"Check_List".equals(sheetName) && !sheetName.contains("#");
    }

    private void fillTestCaseFunctionsMap(File testDefinitionFile, Map<String, TestCaseFunctionInfo> theFunctionsById, String[] browsers, int functionIndex) throws IOException {
        int row;
        SpreadSheet spreadSheet = SpreadSheet.createFromFile(testDefinitionFile);
        String fileName = testDefinitionFile.getName();
        String filePath = testDefinitionFile.getPath();
        logger.log(Level.FINE, " Parsing file:" + filePath);
        String functionGroup = fileName.split("_")[functionIndex];
        int sheetCount = spreadSheet.getSheetCount();
        Table summarySheet = null;
        for (int i = 0; i < sheetCount; ++i) {
            Sheet sheet = spreadSheet.getSheet(i);
            int rowCount = sheet.getRowCount();
            int columnCount = sheet.getColumnCount();
            String sheetName = TestCaseHelper.getSheetName(sheet);
            if ("Summary_Report".equals(sheetName)) {
                summarySheet = sheet;
            }
            if (!this.isTestCaseSheet(sheetName)) continue;
            if (columnCount < 9 || rowCount < 7) {
                System.err.println("[ERROR] Empty data in sheet " + sheetName);
                continue;
            }
            int headerRow = 5;
            int columnTester = -1;
            for (int c = 0; c < columnCount - 1 && rowCount > headerRow; ++c) {
                String columnName = "" + sheet.getValueAt(c, headerRow);
                if ("Tester".equals(columnName)) {
                    columnTester = c;
                }
                if ("".equals(columnName)) break;
            }
            String previousPath = null;
            TestCaseFunctionInfo functionInfo = null;
            Float currentCaseId = new Float(0.0f);
            int autoCaseNo = 1;
            String comments = "";
            for (int row2 = headerRow + 1; row2 > 2 && row2 < rowCount; ++row2) {
                String relatedFunction = "" + sheet.getValueAt(1, row2);
                Object caseId = sheet.getValueAt(2, row2);
                String newPath = "" + sheet.getValueAt(3, row2);
                String stepDesc = "" + sheet.getValueAt(5, row2);
                String priority = "" + sheet.getValueAt(8, row2);
                String message = "row " + (row2 + 1) + " in sheet " + sheetName + " of " + filePath;
                if ("".equals(newPath)) {
                    if ("".equals(relatedFunction) && "".equals(stepDesc)) continue;
                    System.err.println("[ERROR] Empty cell in " + message);
                    continue;
                }
                if ("".equals(relatedFunction)) {
                    System.err.println("[ERROR] Empty related function : " + message);
                }
                boolean isDifference = false;
                if (!newPath.equals(previousPath)) {
                    comments = "";
                    isDifference = true;
                    functionInfo = theFunctionsById.get(relatedFunction);
                    if (functionInfo != null && !functionInfo.getPath().equals(newPath)) {
                        System.err.println("[ERROR] Related Function/Path not identical for " + relatedFunction + " had  [" + functionInfo.getPath() + "] expected [" + newPath + "] " + message);
                    } else if (functionInfo == null) {
                        functionInfo = new TestCaseFunctionInfo(newPath, relatedFunction);
                    }
                    theFunctionsById.put(relatedFunction, functionInfo);
                    currentCaseId = new Float(0.0f);
                    previousPath = newPath;
                }
                if (functionInfo != null) {
                    functionInfo.getPriorityList().add(priority.trim().toUpperCase());
                }
                if (!(caseId instanceof Float)) {
                    System.err.println("[ERROR] Wrong CaseID [" + caseId + "] " + message);
                } else if (((Float)caseId).intValue() == 0) {
                    System.err.println("[ERROR] Wrong CaseID value [" + caseId + "] " + message);
                } else if (!currentCaseId.equals((Float)caseId)) {
                    currentCaseId = (Float)caseId;
                    if (priority.trim().equalsIgnoreCase("High")) {
                        functionInfo.increaseHighPriorityNumber();
                    } else if (priority.trim().equalsIgnoreCase("Medium")) {
                        functionInfo.increaseMediumPriorityNumber();
                    } else if (priority.trim().equalsIgnoreCase("Low")) {
                        functionInfo.increaseLowPriorityNumber();
                    }
                } else if (!isDifference) {
                    if (priority.trim().equalsIgnoreCase("High")) {
                        functionInfo.increaseHighPriorityNumber();
                    } else if (priority.trim().equalsIgnoreCase("Medium")) {
                        functionInfo.increaseMediumPriorityNumber();
                    } else if (priority.trim().equalsIgnoreCase("Low")) {
                        functionInfo.increaseLowPriorityNumber();
                    }
                }
                if (columnTester <= 0) continue;
                int colShiftBrowser = 1;
                String tester = "" + sheet.getValueAt(columnTester, row2);
                for (String browser : browsers) {
                    int column = columnTester + colShiftBrowser++;
                    String browserResult = "" + sheet.getValueAt(column, row2);
                    boolean result = false;
                    if (priority.trim().equalsIgnoreCase("High")) {
                        result = functionInfo.increaseTestResult(browser, "" + autoCaseNo++, browserResult, "High", functionInfo, message);
                    }
                    if (priority.trim().equalsIgnoreCase("Medium")) {
                        result = functionInfo.increaseTestResult(browser, "" + autoCaseNo++, browserResult, "Medium", functionInfo, message);
                    }
                    if (priority.trim().equalsIgnoreCase("Low")) {
                        result = functionInfo.increaseTestResult(browser, "" + autoCaseNo++, browserResult, "Low", functionInfo, message);
                    }
                    if (result) continue;
                    System.err.println("[ERROR] Wrong result value : [" + browserResult + "] column " + column + " " + message);
                }
                String comment = "" + sheet.getValueAt(columnTester + colShiftBrowser, row2);
                if (comment.trim().length() <= 0) continue;
                comments = Float.valueOf(caseId.toString()).intValue() > 99 ? tester + " commented at CaseId : " + Float.valueOf(caseId.toString()).intValue() + "\n\t" + comment + "\n" : (Float.valueOf(caseId.toString()).intValue() > 9 ? tester + " commented at CaseId : 0" + Float.valueOf(caseId.toString()).intValue() + "\n\t" + comment + "\n" : tester + " commented at CaseId : 00" + Float.valueOf(caseId.toString()).intValue() + "\n\t" + comment + "\n");
                functionInfo.setComments(functionInfo.getComments() + comments);
                functionInfo.addComment(Float.valueOf(caseId.toString()).intValue(), comment);
            }
        }
        int rowCount = summarySheet.getRowCount();
        int columnCount = summarySheet.getRowCount();
        int rowHeader = -1;
        int functionaliTyColumn = -1;
        int idColumn = 0;
        block4: for (row = 0; row < rowCount; ++row) {
            String columnName = "" + summarySheet.getValueAt(idColumn, row);
            if (!"Id".equalsIgnoreCase(columnName)) continue;
            for (int col = rowHeader = row; col < columnCount; ++col) {
                columnName = "" + summarySheet.getValueAt(col, row);
                if (!"Functionality".equals(columnName)) continue;
                functionaliTyColumn = col;
                break block4;
            }
            break;
        }
        if (functionaliTyColumn > 0) {
            for (row = rowHeader + 1; row < rowCount; ++row) {
                String id = "" + summarySheet.getValueAt(idColumn, row);
                String functionality = "" + summarySheet.getValueAt(functionaliTyColumn, row);
                TestCaseFunctionInfo testCaseFunctionInfo = theFunctionsById.get(id);
                if (testCaseFunctionInfo == null) continue;
                testCaseFunctionInfo.setRelatedFunction(functionGroup + " - " + functionality);
            }
        } else {
            System.err.println("[ERROR] Functionality column not found for " + filePath);
        }
    }

    private boolean verifyPlannedAssigned(String testCampaignDirName, String testPlanFileName) throws IOException {
        boolean isOk = true;
        File file = new File(testCampaignDirName, testPlanFileName);
        SpreadSheet spreadSheet = SpreadSheet.createFromFile(file);
        Sheet sheet = spreadSheet.getSheet(0);
        String sheetName = TestCaseHelper.getSheetName(sheet);
        String filePath = file.getPath();
        int rowCount = sheet.getRowCount();
        Properties testCampaignInfo = this.readTestCampaignInfo(testCampaignDirName);
        String testersValue = testCampaignInfo.getProperty("test.campaign.testers", "tester1,tester2");
        String[] testers = testersValue.split(",");
        int testerColumnStart = 4;
        int testerColumnEnd = testerColumnStart + testers.length;
        int testCaseCountColumn = 3;
        int headerRow = 3;
        int idColumn = 0;
        int errorCounter = 0;
        int fatalErrorCounter = 0;
        logger.log(Level.FINE, " Start verifying assigned status for testcases");
        for (int row = headerRow + 1; row < rowCount; ++row) {
            String message = "row " + (row + 1) + " in sheet \"" + sheetName + "\" of " + filePath;
            String id = "" + sheet.getValueAt(idColumn, row);
            Object testCaseCountValue = sheet.getValueAt(testCaseCountColumn, row);
            if ("".equals(id)) break;
            boolean isAssigned = false;
            for (int i = testerColumnStart; i < testerColumnEnd; ++i) {
                String assignedSymbol = "" + sheet.getValueAt(i, row);
                if (!"".equals(assignedSymbol) && assignedSymbol.equals("x")) {
                    isAssigned = true;
                } else if (testCaseCountValue instanceof Float) {
                    Float value = (Float)testCaseCountValue;
                    if (value.intValue() == 0) {
                        isAssigned = true;
                    }
                } else {
                    ++errorCounter;
                    ++fatalErrorCounter;
                    System.err.println("[ERROR] Invalid data at column \"TC Count\" " + message);
                }
                if (i == testerColumnEnd - 1 && !isAssigned) continue;
            }
            if (isAssigned) continue;
            isOk = false;
            ++errorCounter;
        }
        logger.log(Level.FINE, " Finish verifying number Planned = Assigned\n The result is:");
        if (errorCounter > 0) {
            // empty if block
        }
        if (fatalErrorCounter > 0) {
            System.err.println("[ERROR] Total " + fatalErrorCounter + " fatal errors are detected, please correct them before generate TestCaseRun files!");
            isOk = false;
        } else {
            logger.log(Level.FINE, " All planned testcases had been assigned!");
            isOk = true;
        }
        return isOk;
    }

    public void generateTestCaseRun(String testCampaignDirName, String testPlanFileName) throws IOException {
        boolean isOk = this.verifyPlannedAssigned(testCampaignDirName, testPlanFileName);
        if (isOk) {
            String testerColumnName;
            File file = new File(testCampaignDirName, testPlanFileName);
            SpreadSheet spreadSheet = SpreadSheet.createFromFile(file);
            Sheet sheet = spreadSheet.getSheet(0);
            int columnCount = sheet.getColumnCount();
            Properties testCampaignInfo = this.readTestCampaignInfo(testCampaignDirName);
            int testerColumnStart = 4;
            int testFunctionIdColumn = 0;
            int testCaseCountColumn = 3;
            int priorityColumn = 2;
            int headerRow = 3;
            for (int column = testerColumnStart; column < columnCount && (testerColumnName = "" + sheet.getValueAt(column, headerRow)).length() != 0 && !testerColumnName.equals("Path"); ++column) {
                int rowCount = sheet.getRowCount();
                int tcCount = 0;
                String priorityValue = "";
                HashSet<TestCaseFunctionIdVsPriority> functionIdsForTester = new HashSet<TestCaseFunctionIdVsPriority>();
                for (int row = headerRow + 1; row < rowCount; ++row) {
                    String functionId = "" + sheet.getValueAt(testFunctionIdColumn, row);
                    String affectedToTester = "" + sheet.getValueAt(column, row);
                    TestCaseFunctionIdVsPriority obj = new TestCaseFunctionIdVsPriority();
                    if (functionId.length() == 0) break;
                    if (affectedToTester.length() <= 0) continue;
                    tcCount += Float.valueOf("" + sheet.getValueAt(testCaseCountColumn, row)).intValue();
                    priorityValue = "" + sheet.getValueAt(priorityColumn, row);
                    obj.setFunctionId(functionId);
                    obj.setPriority(priorityValue);
                    functionIdsForTester.add(obj);
                }
                logger.log(Level.FINE, " " + testerColumnName + ": " + tcCount + " TestCases");
                File[] listFiles = this.getTestFiles(new File(testCampaignDirName, "TestDefinitions"));
                for (int i = 0; i < listFiles.length; ++i) {
                    File tcFile = listFiles[i];
                    String testCaseDefinitionFileName = tcFile.getAbsolutePath();
                    if (!testCaseDefinitionFileName.endsWith("_TestDefinition.ods")) continue;
                    this.generateSingleTestCaseRun(testCaseDefinitionFileName, testerColumnName, functionIdsForTester, testCampaignInfo, testCampaignDirName);
                }
            }
        }
    }

    private void generateSingleTestCaseRun(String testCaseDefinitionFileName, String testerName, Set<TestCaseFunctionIdVsPriority> testerFunctions, Properties testCampaignInfo, String testCampaignDirName) throws IOException {
        String testCampaignBrowsers = testCampaignInfo.getProperty("test.campaign.browsers", "");
        String[] browsers = testCampaignBrowsers.split(",");
        File testCaseDefinitionFile = new File(testCaseDefinitionFileName);
        SpreadSheet spreadSheet = SpreadSheet.createFromFile(testCaseDefinitionFile);
        int sheetCount = spreadSheet.getSheetCount();
        int assigned = 0;
        TreeSet<String> functions = new TreeSet<String>();
        block0: for (int i = 1; i < sheetCount; ++i) {
            Sheet sheet = spreadSheet.getSheet(i);
            String sheetName = TestCaseHelper.getSheetName(sheet);
            if (!this.isTestCaseSheet(sheetName)) continue;
            int columnCount = sheet.getColumnCount();
            int headerRow = 5;
            for (int j = 1; j < columnCount; ++j) {
                Object valueAt = sheet.getValueAt(j, headerRow);
                if (!"".equals(valueAt)) continue;
                sheet.setValueAt("Tester", j, headerRow);
                int colShift = 1;
                for (String browser : browsers) {
                    sheet.setValueAt(browser, j + colShift, headerRow);
                    ++colShift;
                }
                sheet.setValueAt("Comment/Bug", j + colShift, headerRow);
                int rowCount = sheet.getRowCount();
                for (int r = 6; r < rowCount; ++r) {
                    Object valueAtRow = sheet.getValueAt(1, r);
                    String functionIdValue = "" + sheet.getValueAt(1, r);
                    String priorityValue = "" + sheet.getValueAt(8, r);
                    if ("".equals(valueAtRow) && "".equals(functionIdValue)) continue block0;
                    for (TestCaseFunctionIdVsPriority obj : testerFunctions) {
                        if (!obj.getFunctionId().equals(functionIdValue) || !obj.getPriority().equalsIgnoreCase(priorityValue)) continue;
                        sheet.setValueAt(testerName, j, r);
                        functions.add(functionIdValue);
                        String step = "" + sheet.getValueAt(5, r);
                        if (!step.startsWith("Step ")) {
                            System.err.println("[ERROR] Wrong step content [" + step + "]. row " + (r + 1) + " of sheet " + sheetName + " of file " + testCaseDefinitionFile.getName());
                            continue;
                        }
                        ++assigned;
                    }
                }
                continue block0;
            }
        }
        String newFileName = "TestCaseRun_" + testerName + "_" + assigned + "_" + testCaseDefinitionFile.getName().replaceAll("_TestDefinition.ods", ".ods");
        this.saveAsFile(spreadSheet, testCampaignDirName + "/" + "TestPlan", newFileName, false);
        System.out.println("*[INFO] " + newFileName + " " + assigned + " cases. " + functions);
        File resultDir = new File(testCampaignDirName + "/" + "TestRun");
        resultDir.mkdirs();
        System.out.println("*[INFO] Created " + resultDir.getPath() + " for results.");
    }

    private static String getSheetName(Sheet sheet) {
        return sheet.getElement().getAttributeValue("name", sheet.getSpreadSheet().getNS().getTABLE());
    }

    public void saveAsFile(SpreadSheet spreadSheet, String targetDir, String fileName, boolean open) throws IOException, FileNotFoundException {
        File outputDir = new File(targetDir);
        outputDir.mkdirs();
        File outputFile = new File(outputDir, fileName);
        File fileSaved = spreadSheet.saveAs(outputFile);
        logger.log(Level.FINE, " Generated file:" + fileSaved.getPath());
        if (open) {
            OOUtils.open(fileSaved);
        }
    }

    public void listFailures(String testCampaignDirName, String testCampaignName) throws IOException {
        HashMap<String, TestCaseFunctionInfo> theFunctionsByIds = new HashMap<String, TestCaseFunctionInfo>();
        Properties testCampaignInfo = this.readTestCampaignInfo(testCampaignDirName);
        String testersValue = testCampaignInfo.getProperty("test.campaign.testers", "");
        String testCampaignBrowsers = testCampaignInfo.getProperty("test.campaign.browsers", "");
        String[] browsers = testCampaignBrowsers.split(",");
        int browserLength = browsers.length;
        logger.log(Level.FINE, " Gathering TestCaseRun information.....");
        File[] listFiles = this.getTestFiles(new File(testCampaignDirName, "TestRun"));
        for (int i = 0; i < listFiles.length; ++i) {
            File file = listFiles[i];
            if (!file.getName().startsWith("TestCaseRun_")) continue;
            this.fillTestCaseFunctionsMap(file, theFunctionsByIds, browsers, 4);
        }
        ArrayList functionIds = new ArrayList(theFunctionsByIds.keySet());
        Collections.sort(functionIds);
        for (String id : functionIds) {
            TestCaseFunctionInfo functionInfo = (TestCaseFunctionInfo)theFunctionsByIds.get(id);
            int failedCount = 0;
            int blockedCount = 0;
            for (String browser : browsers) {
                failedCount += functionInfo.getTestFailedCount(browser, null);
                blockedCount += functionInfo.getTestBlockedCount(browser, null);
            }
            StringBuffer aggComments = new StringBuffer();
            Map<Integer, String> comments = functionInfo.getCommentMap();
            for (String comment : comments.values()) {
                String oneLine = comment.trim().replaceAll("\n", "");
                aggComments.append(oneLine);
                if (oneLine.length() <= 0) continue;
                aggComments.append(" ");
            }
            if (failedCount + blockedCount <= 0 && aggComments.toString().trim().length() <= 0) continue;
            System.out.println("| " + testCampaignName + "| " + id + " | " + functionInfo.getRelatedFunction() + " | " + (failedCount > 0 ? "FAILED" : (blockedCount > 0 ? "BLOCKED" : "PASSED")) + " | " + aggComments.toString() + " |");
        }
    }

    public void generateTestPlanResult(String testCampaignDirName, String testCampaignName) throws IOException {
        HashMap<String, TestCaseFunctionInfo> theFunctionsByPaths = new HashMap<String, TestCaseFunctionInfo>();
        Properties testCampaignInfo = this.readTestCampaignInfo(testCampaignDirName);
        String testersValue = testCampaignInfo.getProperty("test.campaign.testers", "");
        String testCampaignBrowsers = testCampaignInfo.getProperty("test.campaign.browsers", "");
        String[] browsers = testCampaignBrowsers.split(",");
        int browserLength = browsers.length;
        logger.log(Level.FINE, " Gathering TestCaseRun information.....");
        File[] listFiles = this.getTestFiles(new File(testCampaignDirName, "TestRun"));
        for (int i = 0; i < listFiles.length; ++i) {
            File file = listFiles[i];
            if (!file.getName().startsWith("TestCaseRun_")) continue;
            this.fillTestCaseFunctionsMap(file, theFunctionsByPaths, browsers, 4);
        }
        logger.log(Level.FINE, " Gathering TestCaseRun information successful.....");
        String[] testers = testersValue.split(",");
        int columnCount = testers.length + 3;
        String[] columns = new String[columnCount];
        for (int i = 0; i < testers.length; ++i) {
            columns[i + 2] = testers[i];
            logger.log(Level.FINE, " Tester:" + testers[i]);
        }
        columns[columnCount - 1] = "Description";
        ArrayList functionIds = new ArrayList(theFunctionsByPaths.keySet());
        Collections.sort(functionIds);
        File file = new File("TestResultTemplate.ods");
        InputStream template = TestCaseHelper.class.getResourceAsStream("/TestResultTemplate.ods");
        this.convertInputStreamToFile(file, template);
        SpreadSheet testPlanResultSpreadSheet = SpreadSheet.createFromFile(file);
        Sheet testResultSheet = testPlanResultSpreadSheet.getSheet(0);
        Sheet sheetFeedbacks = testPlanResultSpreadSheet.getSheet(1);
        Sheet sheetColorPicker = testPlanResultSpreadSheet.getSheet("ColorPicker");
        Map<String, String> colorMap = this.getColorPickerList(sheetColorPicker);
        logger.log(Level.FINE, " Printing \"TestResults\" sheet....");
        int colShift = 0;
        testResultSheet.setValueAt("Id", colShift++, 8);
        testResultSheet.setValueAt("Function", colShift++, 8);
        testResultSheet.setValueAt("Priority", colShift++, 8);
        testResultSheet.setValueAt("TC Count", colShift++, 8);
        int expectedColumnCount = colShift + browsers.length * 5;
        int row = 9;
        testResultSheet.ensureRowCount(functionIds.size() * 3 + row + 1);
        testResultSheet.ensureColumnCount(expectedColumnCount + 1);
        int colShiftBrowsers = 0;
        for (String browser : browsers) {
            testResultSheet.setValueAt(browser, colShift + colShiftBrowsers, 0);
            testResultSheet.setValueAt("PASSED", colShift + colShiftBrowsers++, 8);
            testResultSheet.setValueAt("FAILED", colShift + colShiftBrowsers++, 8);
            testResultSheet.setValueAt("BLOCKED", colShift + colShiftBrowsers++, 8);
            testResultSheet.setValueAt("N/A", colShift + colShiftBrowsers++, 8);
            testResultSheet.setValueAt("NOT RUN", colShift + colShiftBrowsers++, 8);
        }
        SummaryAggregator summaryAggregator = new SummaryAggregator(testCampaignName);
        for (String id : functionIds) {
            TestCaseFunctionInfo functionInfo = (TestCaseFunctionInfo)theFunctionsByPaths.get(id);
            Set<String> priorityList = functionInfo.getPriorityList();
            if (priorityList.contains("High".toUpperCase())) {
                colShiftBrowsers = 0;
                for (String browser : browsers) {
                    colShiftBrowsers = this.fillDataToResultSheet(testResultSheet, functionInfo, browser, browserLength, row, colShift, colShiftBrowsers, "High", summaryAggregator);
                }
                ++row;
            }
            if (priorityList.contains("Medium".toUpperCase())) {
                colShiftBrowsers = 0;
                for (String browser : browsers) {
                    colShiftBrowsers = this.fillDataToResultSheet(testResultSheet, functionInfo, browser, browserLength, row, colShift, colShiftBrowsers, "Medium", summaryAggregator);
                }
                ++row;
            }
            if (!priorityList.contains("Low".toUpperCase())) continue;
            colShiftBrowsers = 0;
            for (String browser : browsers) {
                colShiftBrowsers = this.fillDataToResultSheet(testResultSheet, functionInfo, browser, browserLength, row, colShift, colShiftBrowsers, "Low", summaryAggregator);
            }
            ++row;
        }
        System.out.println(summaryAggregator.getSummary());
        int sheetBrowserIndex = 2;
        int browserSheetRow = 1;
        for (String browser : browsers) {
            logger.log(Level.FINE, " Printing \"" + browser + "\" sheet...");
            Sheet browserSheet = testPlanResultSpreadSheet.getSheet(sheetBrowserIndex);
            browserSheet.getElement().setAttribute("name", "" + browser, testPlanResultSpreadSheet.getNS().getTABLE());
            browserSheet.ensureRowCount(functionIds.size() * 5 * 3 + 1);
            browserSheetRow = 1;
            for (String id : functionIds) {
                TestCaseFunctionInfo functionInfo = (TestCaseFunctionInfo)theFunctionsByPaths.get(id);
                Set<String> priorityList = functionInfo.getPriorityList();
                if (priorityList.contains("High".toUpperCase())) {
                    browserSheetRow = this.fillDataToBrowserSheet(browserSheet, functionInfo, browser, browserLength, browserSheetRow, "High", colorMap);
                }
                if (priorityList.contains("Medium".toUpperCase())) {
                    browserSheetRow = this.fillDataToBrowserSheet(browserSheet, functionInfo, browser, browserLength, browserSheetRow, "Medium", colorMap);
                }
                if (!priorityList.contains("Low".toUpperCase())) continue;
                browserSheetRow = this.fillDataToBrowserSheet(browserSheet, functionInfo, browser, browserLength, browserSheetRow, "Low", colorMap);
            }
            ++sheetBrowserIndex;
        }
        logger.log(Level.FINE, " Printing \"Feedbacks\" sheet...");
        sheetFeedbacks.setValueAt("Id", 0, 6);
        sheetFeedbacks.setValueAt("Function", 1, 6);
        sheetFeedbacks.setValueAt("Comment", 2, 6);
        row = 7;
        sheetFeedbacks.ensureRowCount(functionIds.size());
        for (String path : functionIds) {
            TestCaseFunctionInfo functionInfo = (TestCaseFunctionInfo)theFunctionsByPaths.get(path);
            Map<Integer, String> commentMap = functionInfo.getCommentMap();
            Set<Integer> caseNoSet = commentMap.keySet();
            TreeSet<Integer> treeSet = new TreeSet<Integer>(caseNoSet);
            for (Integer caseId : treeSet) {
                sheetFeedbacks.ensureRowCount(row + 1);
                if (caseId > 99) {
                    sheetFeedbacks.setValueAt(functionInfo.getId() + "." + caseId, 0, row);
                } else if (caseId > 9) {
                    sheetFeedbacks.setValueAt(functionInfo.getId() + ".0" + caseId, 0, row);
                } else {
                    sheetFeedbacks.setValueAt(functionInfo.getId() + ".00" + caseId, 0, row);
                }
                sheetFeedbacks.setValueAt(functionInfo.getRelatedFunction(), 1, row);
                sheetFeedbacks.setValueAt(commentMap.get(caseId), 2, row);
                ++row;
            }
        }
        logger.log(Level.FINE, " Printing \"Feedbacks\" sheet successful...");
        this.saveAsFile(testPlanResultSpreadSheet, testCampaignDirName + "/", testCampaignDirName + "_TestResults.ods", false);
    }

    private int fillDataToResultSheet(Sheet testResultSheet, TestCaseFunctionInfo functionInfo, String browser, int browserLength, int row, int colShift, int colShiftBrowsers, String priorityType, SummaryAggregator summaryAggregator) {
        int returnedColShiftBrowsers = colShiftBrowsers;
        testResultSheet.setValueAt(functionInfo.getId(), 0, row);
        testResultSheet.setValueAt(functionInfo.getRelatedFunction(), 1, row);
        if (functionInfo.getRelatedFunction().length() == 0) {
            System.err.println("[ERROR] Missing Related Function for " + functionInfo.getId() + " (Please fix Definition file in summary).");
        }
        testResultSheet.setValueAt(priorityType, 2, row);
        if (priorityType.equalsIgnoreCase("High")) {
            testResultSheet.setValueAt(functionInfo.getHighPriorityNumber() / browserLength, 3, row);
        } else if (priorityType.equalsIgnoreCase("Medium")) {
            testResultSheet.setValueAt(functionInfo.getMediumPriorityNumber() / browserLength, 3, row);
        } else if (priorityType.equalsIgnoreCase("Low")) {
            testResultSheet.setValueAt(functionInfo.getLowPriorityNumber() / browserLength, 3, row);
        }
        summaryAggregator.addTestcase(functionInfo.getTestCount(browser, priorityType));
        testResultSheet.setValueAt(functionInfo.getTestPassedCount(browser, priorityType), colShift + returnedColShiftBrowsers++, row);
        summaryAggregator.addPassed(functionInfo.getTestPassedCount(browser, priorityType));
        testResultSheet.setValueAt(functionInfo.getTestFailedCount(browser, priorityType), colShift + returnedColShiftBrowsers++, row);
        summaryAggregator.addFailed(functionInfo.getTestFailedCount(browser, priorityType));
        testResultSheet.setValueAt(functionInfo.getTestBlockedCount(browser, priorityType), colShift + returnedColShiftBrowsers++, row);
        summaryAggregator.addBlocked(functionInfo.getTestBlockedCount(browser, priorityType));
        testResultSheet.setValueAt(functionInfo.getTestNACount(browser, priorityType), colShift + returnedColShiftBrowsers++, row);
        summaryAggregator.addNA(functionInfo.getTestNACount(browser, priorityType));
        testResultSheet.setValueAt(functionInfo.getTestNotRunCount(browser, priorityType), colShift + returnedColShiftBrowsers++, row);
        summaryAggregator.addNotrun(functionInfo.getTestNotRunCount(browser, priorityType));
        return returnedColShiftBrowsers;
    }

    private int fillDataToBrowserSheet(Sheet browserSheet, TestCaseFunctionInfo functionInfo, String browser, int browserLength, int browserSheetRow, String priorityType, Map<String, String> colorMap) {
        int startIndex = 3;
        int returnedBrowserSheetRow = browserSheetRow;
        browserSheet.setValueAt(functionInfo.getId(), 0, returnedBrowserSheetRow);
        browserSheet.setValueAt(priorityType, 1, returnedBrowserSheetRow);
        browserSheet.setValueAt(functionInfo.getComments(), 6, returnedBrowserSheetRow);
        int totalNumber = -1;
        if (priorityType.equalsIgnoreCase("High")) {
            totalNumber = functionInfo.getHighPriorityNumber() / browserLength;
            browserSheet.setValueAt(functionInfo.getHighPriorityNumber() / browserLength, 2, returnedBrowserSheetRow);
        } else if (priorityType.equalsIgnoreCase("Medium")) {
            totalNumber = functionInfo.getMediumPriorityNumber() / browserLength;
            browserSheet.setValueAt(functionInfo.getMediumPriorityNumber() / browserLength, 2, returnedBrowserSheetRow);
        } else if (priorityType.equalsIgnoreCase("Low")) {
            totalNumber = functionInfo.getLowPriorityNumber() / browserLength;
            browserSheet.setValueAt(functionInfo.getLowPriorityNumber() / browserLength, 2, returnedBrowserSheetRow);
        }
        int colShiftIndex = 0;
        browserSheet.setValueAt("Passed", startIndex + colShiftIndex++, returnedBrowserSheetRow);
        browserSheet.setValueAt(functionInfo.getTestPassedCount(browser, priorityType), startIndex + colShiftIndex++, returnedBrowserSheetRow);
        browserSheet.setValueAt(this.round((float)functionInfo.getTestPassedCount(browser, priorityType) * 100.0f / (float)totalNumber, 2) + "%", startIndex + colShiftIndex++, returnedBrowserSheetRow);
        startIndex = 3;
        colShiftIndex = 0;
        browserSheet.setValueAt("Failed", startIndex + colShiftIndex++, ++returnedBrowserSheetRow);
        browserSheet.setValueAt(functionInfo.getRelatedFunction(), 0, returnedBrowserSheetRow);
        browserSheet.setValueAt(functionInfo.getTestFailedCount(browser, priorityType), startIndex + colShiftIndex++, returnedBrowserSheetRow);
        browserSheet.setValueAt(this.round((float)functionInfo.getTestFailedCount(browser, priorityType) * 100.0f / (float)totalNumber, 2) + "%", startIndex + colShiftIndex++, returnedBrowserSheetRow);
        colShiftIndex = 0;
        browserSheet.setValueAt("Blocked", startIndex + colShiftIndex++, ++returnedBrowserSheetRow);
        browserSheet.setValueAt(functionInfo.getTestBlockedCount(browser, priorityType), startIndex + colShiftIndex++, returnedBrowserSheetRow);
        browserSheet.setValueAt(this.round((float)functionInfo.getTestBlockedCount(browser, priorityType) * 100.0f / (float)totalNumber, 2) + "%", startIndex + colShiftIndex++, returnedBrowserSheetRow);
        colShiftIndex = 0;
        browserSheet.setValueAt("N/A", startIndex + colShiftIndex++, ++returnedBrowserSheetRow);
        browserSheet.setValueAt(functionInfo.getTestNACount(browser, priorityType), startIndex + colShiftIndex++, returnedBrowserSheetRow);
        browserSheet.setValueAt(this.round((float)functionInfo.getTestNACount(browser, priorityType) * 100.0f / (float)totalNumber, 2) + "%", startIndex + colShiftIndex++, returnedBrowserSheetRow);
        colShiftIndex = 0;
        browserSheet.setValueAt("Not Run", startIndex + colShiftIndex++, ++returnedBrowserSheetRow);
        browserSheet.setValueAt(functionInfo.getTestNotRunCount(browser, priorityType), startIndex + colShiftIndex++, returnedBrowserSheetRow);
        browserSheet.setValueAt(this.round((float)functionInfo.getTestNotRunCount(browser, priorityType) * 100.0f / (float)totalNumber, 2) + "%", startIndex + colShiftIndex++, returnedBrowserSheetRow);
        return ++returnedBrowserSheetRow;
    }

    private Map<String, String> getColorPickerList(Sheet colorPickerSheet) {
        HashMap<String, String> colorStyleMap = new HashMap<String, String>();
        int colorIndex = 0;
        colorStyleMap.put("red", colorPickerSheet.getCellAt(colorIndex++, 0).getStyleName());
        colorStyleMap.put("yellow", colorPickerSheet.getCellAt(colorIndex++, 0).getStyleName());
        colorStyleMap.put("green", colorPickerSheet.getCellAt(colorIndex++, 0).getStyleName());
        colorStyleMap.put("lightGreen", colorPickerSheet.getCellAt(colorIndex++, 0).getStyleName());
        colorStyleMap.put("oceanBlue", colorPickerSheet.getCellAt(colorIndex++, 0).getStyleName());
        colorStyleMap.put("blue", colorPickerSheet.getCellAt(colorIndex++, 0).getStyleName());
        colorStyleMap.put("gray", colorPickerSheet.getCellAt(colorIndex++, 0).getStyleName());
        colorIndex = 0;
        colorStyleMap.put("redRight", colorPickerSheet.getCellAt(colorIndex++, 1).getStyleName());
        colorStyleMap.put("yellowRight", colorPickerSheet.getCellAt(colorIndex++, 1).getStyleName());
        colorStyleMap.put("greenRight", colorPickerSheet.getCellAt(colorIndex++, 1).getStyleName());
        colorStyleMap.put("lightGreenRight", colorPickerSheet.getCellAt(colorIndex++, 1).getStyleName());
        colorStyleMap.put("oceanBlueRight", colorPickerSheet.getCellAt(colorIndex++, 1).getStyleName());
        colorStyleMap.put("blueRight", colorPickerSheet.getCellAt(colorIndex++, 1).getStyleName());
        colorStyleMap.put("grayRight", colorPickerSheet.getCellAt(colorIndex++, 1).getStyleName());
        return colorStyleMap;
    }

    private double round(double val, int places) {
        long factor = (long)Math.pow(10.0, places);
        long tmp = Math.round(val *= (double)factor);
        return (double)tmp / (double)factor;
    }

    private float round(float val, int places) {
        return (float)this.round((double)val, places);
    }
}

