/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import java.util.EnumSet;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jopendocument.dom.NS;
import org.jopendocument.dom.ODNode;
import org.jopendocument.dom.ODValueType;
import org.jopendocument.dom.ODXMLDocument;

public class ODUserDefinedMeta
extends ODNode {
    private static final EnumSet<ODValueType> allowedTypes = EnumSet.of(ODValueType.FLOAT, ODValueType.DATE, ODValueType.TIME, ODValueType.BOOLEAN, ODValueType.STRING);
    private final ODXMLDocument parent;

    public static String getElemName() {
        return "user-defined";
    }

    static ODUserDefinedMeta create(String string, ODXMLDocument oDXMLDocument) {
        Element element = new Element(ODUserDefinedMeta.getElemName(), oDXMLDocument.getNS().getMETA());
        element.setAttribute("name", string, oDXMLDocument.getNS().getMETA());
        ODUserDefinedMeta oDUserDefinedMeta = new ODUserDefinedMeta(element, oDXMLDocument);
        oDUserDefinedMeta.setValue("");
        return oDUserDefinedMeta;
    }

    static String getPathTo(String string) {
        return "meta:" + ODUserDefinedMeta.getElemName() + "[@meta:name = '" + string + "']";
    }

    static String getNamesPath() {
        return "meta:" + ODUserDefinedMeta.getElemName() + "/@meta:name";
    }

    ODUserDefinedMeta(Element element, ODXMLDocument oDXMLDocument) {
        super(element);
        this.parent = oDXMLDocument;
    }

    protected final ODXMLDocument getParent() {
        return this.parent;
    }

    public final String getName() {
        return this.getElement().getAttributeValue("name", this.getNS().getMETA());
    }

    private final NS getNS() {
        return this.getParent().getNS();
    }

    private final Attribute getValueTypeAttr() {
        return this.getValueTypeAttr(true);
    }

    private final Attribute getValueTypeAttr(boolean bl) {
        Attribute attribute = this.getElement().getAttribute("value-type", this.getNS().getMETA());
        if (attribute == null && bl) {
            attribute = new Attribute("value-type", ODValueType.STRING.getName(), this.getNS().getMETA());
            this.getElement().setAttribute(attribute);
        }
        return attribute;
    }

    public final Object getValue() {
        return this.getValueType().parse(this.getElement().getTextTrim());
    }

    public final ODValueType getValueType() {
        return ODValueType.get(this.getValueTypeAttr().getValue());
    }

    public final void setValue(Object object) {
        this.setValue(object, ODValueType.forObject(object));
    }

    public final void setValue(Object object, ODValueType oDValueType) {
        if (!allowedTypes.contains((Object)oDValueType)) {
            throw new IllegalArgumentException((Object)((Object)oDValueType) + " is not allowed: " + allowedTypes);
        }
        if (oDValueType != ODValueType.STRING) {
            this.getValueTypeAttr().setValue(oDValueType.getName());
        } else {
            Attribute attribute = this.getValueTypeAttr(false);
            if (attribute != null) {
                attribute.detach();
            }
        }
        this.getElement().setText(oDValueType.format(object));
    }
}

