package org.exoplatform.tcm;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * @author Dimitri BAELI, CanhBX
 *
 */
public class RunResultAggregator {
	
	
	int STATUS_NOT_RUN = 1;//Untested or not run
	int STATUS_PASSED = 2;	
	int STATUS_NA = 3;
	int STATUS_BLOCKED = 4;
	int STATUS_FAILED = 5;
	
	Map<String, Integer> testCount = new HashMap<String, Integer>();
	Map<String, String> testCasePriority = new HashMap<String, String>();
	Map<String, String> rowDescriptionMap = new HashMap<String, String>();
	Map<String, String> browserResultDescription = new HashMap<String, String>();
	
	public boolean registerTesterResult(String caseId, String value, String priority,TestCaseFunctionInfo functionInfo, String message, String browser, String browserResult) {
		String key = caseId;		
		int level = STATUS_NOT_RUN;
		
		String cleanValue = value.trim();
		if ("PASSED".equalsIgnoreCase(cleanValue)||"OK".equalsIgnoreCase(cleanValue)||"PASS".equalsIgnoreCase(cleanValue)) {
			level=STATUS_PASSED;
		} else if ("FAILED".equalsIgnoreCase(cleanValue) ||"FAIL".equalsIgnoreCase(cleanValue)) {
			level=STATUS_FAILED;
		} else if ("BLOCKED".equalsIgnoreCase(cleanValue) || "BLOCK".equalsIgnoreCase(cleanValue)) {
			level=STATUS_BLOCKED;
		} else if ("N/A".equalsIgnoreCase(cleanValue) || "NA".equalsIgnoreCase(cleanValue)) {
			level=STATUS_NA;
		} else if ("".equals(cleanValue) || "Untested".equalsIgnoreCase(cleanValue) || "UNTEST".equalsIgnoreCase(cleanValue)){
			level=STATUS_NOT_RUN;
		} else {
			return false;
		}		
		
		/**
		 * IMPORTANCE NOTICE:
		 * When more than one tester run the same testcase:
     	 *	- When they have the same results: no conflict will occurred
     	 *	- When they do not have the same results:
         *       + the result priority will follow this : Failed > Blocked > N/A > Passed > Not Run
         *       + the alert message will displayed on the console to remind user about the problem and make decisions.
		 */
		Set<String> keySet = testCount.keySet();
		for (String id : keySet) {
			if(id.equalsIgnoreCase(key)){
				int oldLevel = testCount.get(id);
				if(oldLevel < level){					
					testCount.put(key, level);//Change to new higher level	
					if(oldLevel>STATUS_NOT_RUN){//Display error on console
						String description = rowDescriptionMap.get(id)+ browserResultDescription.get(id)+ "\n\t  "+message + " : Browser is "+ browser +" || Result is "+browserResult;
						System.err.println("[ERROR] More than one tester run the same testcase and they have a conflict between test results for this testcase \n\tat:\n\t  "+description+"\n");
					}
				}else if(oldLevel > level && level > STATUS_NOT_RUN){//No need to change level but need to inform user about this conflict
					String description = rowDescriptionMap.get(id)+ browserResultDescription.get(id) +"\n\t  "+message + " : Browser is "+ browser +" || Result is "+browserResult;					
					System.err.println("[ERROR] More than one tester run the same testcase and they have a conflict between test results for this testcase \n\tat:\n\t  "+description+"\n");
				}
				return true;//Importance
			}			
		}
		
		browserResultDescription.put(key, " : Browser is "+ browser +" || Result is "+browserResult);
		rowDescriptionMap.put(key, message);
		testCount.put(key, level);
		testCasePriority.put(key, priority);
		
		return true;
	}

    /**
     * Function to count number of testcase for specific status and priority
     * */
    private int countStatus(int status, String priorityType){
        int count=0;
        Set<String> keySet = testCount.keySet();
        for (String caseId : keySet) {
            int statusValue = testCount.get(caseId);
            String priorityValue = testCasePriority.get(caseId);
            if(statusValue == status && (priorityType == null || priorityValue.equalsIgnoreCase(priorityType))){
                count++;
            }
        }
        return count;
    }

    /**
     * Function to count number of testcase for specific status and priority
     * */
    private int count(String priorityType){
        int count=0;
        Set<String> keySet = testCount.keySet();
        for (String caseId : keySet) {
            String priorityValue = testCasePriority.get(caseId);
            if(priorityValue.equalsIgnoreCase(priorityType)){
                count++;
            }
        }
        return count;
    }


	public int getTestPassedCount(String priorityType) {
		return countStatus(STATUS_PASSED, priorityType);
	}			

	public int getTestFailedCount(String priorityType) {
		return countStatus(STATUS_FAILED, priorityType);
	}
	
	public int getTestBlockedCount(String priorityType) {
		return countStatus(STATUS_BLOCKED, priorityType);
	}
	
	public int getTestNACount(String priorityType){
		return countStatus(STATUS_NA, priorityType);
	}
	
    public int getTestNotRunCount(String priorityType) {
        return countStatus(STATUS_NOT_RUN, priorityType);
    }

    public int getTestCount(String priorityType) {
        return count(priorityType);
    }
}
