/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.Collection;
import microsoft.exchange.webservices.data.CreateFolderResponse;
import microsoft.exchange.webservices.data.CreateRequest;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.Folder;
import microsoft.exchange.webservices.data.ServiceErrorHandling;
import microsoft.exchange.webservices.data.ServiceResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CreateFolderRequest
extends CreateRequest<Folder, ServiceResponse> {
    protected CreateFolderRequest(ExchangeService service, ServiceErrorHandling errorHandlingMode) throws Exception {
        super(service, errorHandlingMode);
    }

    @Override
    protected void validate() throws Exception {
        super.validate();
        EwsUtilities.validateParam(this.getFolders(), "Folders");
        for (Folder folder : this.getFolders()) {
            folder.validate();
        }
    }

    @Override
    protected ServiceResponse createServiceResponse(ExchangeService service, int responseIndex) {
        return new CreateFolderResponse((Folder)EwsUtilities.getEnumeratedObjectAt(this.getFolders(), responseIndex));
    }

    @Override
    protected String getXmlElementName() {
        return "CreateFolder";
    }

    @Override
    protected String getResponseXmlElementName() {
        return "CreateFolderResponse";
    }

    @Override
    protected String getResponseMessageXmlElementName() {
        return "CreateFolderResponseMessage";
    }

    @Override
    protected String getParentFolderXmlElementName() {
        return "ParentFolderId";
    }

    @Override
    protected String getObjectCollectionXmlElementName() {
        return "Folders";
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    public Iterable<Folder> getFolders() {
        return this.getObjects();
    }

    public void setFolders(Iterable<Folder> folder) {
        this.setObjects((Collection)folder);
    }
}

