/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.ArrayList;
import microsoft.exchange.webservices.data.Attachable;
import microsoft.exchange.webservices.data.ConflictResolutionMode;
import microsoft.exchange.webservices.data.EmailAddress;
import microsoft.exchange.webservices.data.EmailAddressCollection;
import microsoft.exchange.webservices.data.EmailMessageSchema;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.FolderId;
import microsoft.exchange.webservices.data.Item;
import microsoft.exchange.webservices.data.ItemAttachment;
import microsoft.exchange.webservices.data.ItemId;
import microsoft.exchange.webservices.data.MessageBody;
import microsoft.exchange.webservices.data.MessageDisposition;
import microsoft.exchange.webservices.data.PropertySet;
import microsoft.exchange.webservices.data.ResponseMessage;
import microsoft.exchange.webservices.data.ResponseMessageType;
import microsoft.exchange.webservices.data.ServiceLocalException;
import microsoft.exchange.webservices.data.ServiceObjectDefinition;
import microsoft.exchange.webservices.data.ServiceObjectSchema;
import microsoft.exchange.webservices.data.SuppressReadReceipt;
import microsoft.exchange.webservices.data.WellKnownFolderName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Attachable
@ServiceObjectDefinition(xmlElementName="Message")
public class EmailMessage
extends Item {
    public EmailMessage(ExchangeService service) throws Exception {
        super(service);
    }

    protected EmailMessage(ItemAttachment parentAttachment) throws Exception {
        super(parentAttachment);
    }

    public static EmailMessage bind(ExchangeService service, ItemId id, PropertySet propertySet) throws Exception {
        return service.bindToItem(EmailMessage.class, id, propertySet);
    }

    public static EmailMessage bind(ExchangeService service, ItemId id) throws Exception {
        return EmailMessage.bind(service, id, PropertySet.getFirstClassProperties());
    }

    @Override
    protected ServiceObjectSchema getSchema() {
        return EmailMessageSchema.Instance;
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    private void internalSend(FolderId parentFolderId, MessageDisposition messageDisposition) throws Exception {
        this.throwIfThisIsAttachment();
        if (this.isNew()) {
            if (this.getAttachments().getCount() == 0 || messageDisposition == MessageDisposition.SaveOnly) {
                this.internalCreate(parentFolderId, messageDisposition, null);
            } else {
                this.internalCreate(null, MessageDisposition.SaveOnly, null);
                this.getService().sendItem(this, parentFolderId);
            }
        } else if (this.isDirty()) {
            this.getAttachments().validate();
            this.getAttachments().save();
            if (this.getPropertyBag().getIsUpdateCallNecessary()) {
                this.internalUpdate(parentFolderId, ConflictResolutionMode.AutoResolve, messageDisposition, null);
            } else {
                this.getService().sendItem(this, parentFolderId);
            }
        } else {
            this.getService().sendItem(this, parentFolderId);
        }
    }

    public ResponseMessage createReply(boolean replyAll) throws Exception {
        this.throwIfThisIsNew();
        return new ResponseMessage(this, replyAll ? ResponseMessageType.ReplyAll : ResponseMessageType.Reply);
    }

    public ResponseMessage createForward() throws Exception {
        this.throwIfThisIsNew();
        return new ResponseMessage(this, ResponseMessageType.Forward);
    }

    public void reply(MessageBody bodyPrefix, boolean replyAll) throws Exception {
        ResponseMessage responseMessage = this.createReply(replyAll);
        responseMessage.setBodyPrefix(bodyPrefix);
        responseMessage.sendAndSaveCopy();
    }

    public void forward(MessageBody bodyPrefix, EmailAddress ... toRecipients) throws Exception {
        if (null != toRecipients) {
            ArrayList<EmailAddress> list = new ArrayList<EmailAddress>();
            for (EmailAddress email : toRecipients) {
                list.add(email);
            }
            this.forward(bodyPrefix, list);
        }
    }

    public void forward(MessageBody bodyPrefix, Iterable<EmailAddress> toRecipients) throws Exception {
        ResponseMessage responseMessage = this.createForward();
        responseMessage.setBodyPrefix(bodyPrefix);
        responseMessage.getToRecipients().addEmailRange(toRecipients.iterator());
        responseMessage.sendAndSaveCopy();
    }

    public void send() throws Exception {
        this.internalSend(null, MessageDisposition.SendOnly);
    }

    public void sendAndSaveCopy(FolderId destinationFolderId) throws Exception {
        EwsUtilities.validateParam(destinationFolderId, "destinationFolderId");
        this.internalSend(destinationFolderId, MessageDisposition.SendAndSaveCopy);
    }

    public void sendAndSaveCopy(WellKnownFolderName destinationFolderName) throws Exception {
        this.internalSend(new FolderId(destinationFolderName), MessageDisposition.SendAndSaveCopy);
    }

    public void sendAndSaveCopy() throws Exception {
        this.internalSend(new FolderId(WellKnownFolderName.SentItems), MessageDisposition.SendAndSaveCopy);
    }

    public void suppressReadReceipt() throws Exception {
        this.throwIfThisIsNew();
        new SuppressReadReceipt(this).internalCreate(null, null);
    }

    public EmailAddressCollection getToRecipients() throws ServiceLocalException {
        return (EmailAddressCollection)this.getPropertyBag().getObjectFromPropertyDefinition(EmailMessageSchema.ToRecipients);
    }

    public EmailAddressCollection getBccRecipients() throws ServiceLocalException {
        return (EmailAddressCollection)this.getPropertyBag().getObjectFromPropertyDefinition(EmailMessageSchema.BccRecipients);
    }

    public EmailAddressCollection getCcRecipients() throws ServiceLocalException {
        return (EmailAddressCollection)this.getPropertyBag().getObjectFromPropertyDefinition(EmailMessageSchema.CcRecipients);
    }

    public String getConversationTopic() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(EmailMessageSchema.ConversationTopic);
    }

    public byte[] getConversationIndex() throws ServiceLocalException {
        return (byte[])this.getPropertyBag().getObjectFromPropertyDefinition(EmailMessageSchema.ConversationIndex);
    }

    public EmailAddress getFrom() throws ServiceLocalException {
        return (EmailAddress)this.getPropertyBag().getObjectFromPropertyDefinition(EmailMessageSchema.From);
    }

    public void setFrom(EmailAddress value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(EmailMessageSchema.From, value);
    }

    @Override
    public boolean getIsAssociated() throws ServiceLocalException {
        return super.getIsAssociated();
    }

    public void setIsAssociated(boolean value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(EmailMessageSchema.IsAssociated, value);
    }

    public Boolean getIsDeliveryReceiptRequested() throws ServiceLocalException {
        return (Boolean)this.getPropertyBag().getObjectFromPropertyDefinition(EmailMessageSchema.IsDeliveryReceiptRequested);
    }

    public void setIsDeliveryReceiptRequested(Boolean value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(EmailMessageSchema.IsDeliveryReceiptRequested, value);
    }

    public Boolean getIsRead() throws ServiceLocalException {
        return (Boolean)this.getPropertyBag().getObjectFromPropertyDefinition(EmailMessageSchema.IsRead);
    }

    public void setIsRead(Boolean value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(EmailMessageSchema.IsRead, value);
    }

    public Boolean getIsReadReceiptRequested() throws ServiceLocalException {
        return (Boolean)this.getPropertyBag().getObjectFromPropertyDefinition(EmailMessageSchema.IsReadReceiptRequested);
    }

    public void setIsReadReceiptRequested(Boolean value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(EmailMessageSchema.IsReadReceiptRequested, value);
    }

    public Boolean getIsResponseRequested() throws ServiceLocalException {
        return (Boolean)this.getPropertyBag().getObjectFromPropertyDefinition(EmailMessageSchema.IsResponseRequested);
    }

    public void setIsResponseRequested(Boolean value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(EmailMessageSchema.IsResponseRequested, value);
    }

    public String getInternetMessageId() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(EmailMessageSchema.InternetMessageId);
    }

    public String getReferences() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(EmailMessageSchema.References);
    }

    public void setReferences(String value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(EmailMessageSchema.References, value);
    }

    public EmailAddressCollection getReplyTo() throws ServiceLocalException {
        return (EmailAddressCollection)this.getPropertyBag().getObjectFromPropertyDefinition(EmailMessageSchema.ReplyTo);
    }

    public EmailAddress getSender() throws ServiceLocalException {
        return (EmailAddress)this.getPropertyBag().getObjectFromPropertyDefinition(EmailMessageSchema.Sender);
    }

    public void setSender(EmailAddress value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(EmailMessageSchema.Sender, value);
    }

    public EmailAddress getReceivedBy() throws ServiceLocalException {
        return (EmailAddress)this.getPropertyBag().getObjectFromPropertyDefinition(EmailMessageSchema.ReceivedBy);
    }

    public EmailAddress getReceivedRepresenting() throws ServiceLocalException {
        return (EmailAddress)this.getPropertyBag().getObjectFromPropertyDefinition(EmailMessageSchema.ReceivedRepresenting);
    }
}

