/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.GetServerTimeZonesResponse;
import microsoft.exchange.webservices.data.MultiResponseServiceRequest;
import microsoft.exchange.webservices.data.ServiceErrorHandling;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.XmlNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GetServerTimeZonesRequest
extends MultiResponseServiceRequest<GetServerTimeZonesResponse> {
    private Iterable<String> ids;

    @Override
    protected void validate() throws Exception {
        super.validate();
        if (this.ids != null) {
            EwsUtilities.validateParamCollection(this.getIds().iterator(), "Ids");
        }
    }

    protected GetServerTimeZonesRequest(ExchangeService service) throws Exception {
        super(service, ServiceErrorHandling.ThrowOnError);
    }

    @Override
    protected GetServerTimeZonesResponse createServiceResponse(ExchangeService service, int responseIndex) {
        return new GetServerTimeZonesResponse();
    }

    @Override
    protected String getResponseMessageXmlElementName() {
        return "GetServerTimeZonesResponseMessage";
    }

    @Override
    protected int getExpectedResponseMessageCount() {
        return 1;
    }

    @Override
    protected String getXmlElementName() {
        return "GetServerTimeZones";
    }

    @Override
    protected String getResponseXmlElementName() {
        return "GetServerTimeZonesResponse";
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2010;
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException, XMLStreamException {
        if (this.getIds() != null) {
            writer.writeStartElement(XmlNamespace.Messages, "Ids");
            for (String id : this.getIds()) {
                writer.writeElementValue(XmlNamespace.Types, "Id", id);
            }
            writer.writeEndElement();
        }
    }

    protected Iterable<String> getIds() {
        return this.ids;
    }

    protected void setIds(Iterable<String> ids) {
        this.ids = ids;
    }
}

