/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.ArrayList;
import java.util.List;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.GetStreamingEventsResults;
import microsoft.exchange.webservices.data.HangingRequestDisconnectReason;
import microsoft.exchange.webservices.data.HangingServiceRequestBase;
import microsoft.exchange.webservices.data.ServiceResponse;
import microsoft.exchange.webservices.data.XmlNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GetStreamingEventsResponse
extends ServiceResponse {
    private GetStreamingEventsResults results = new GetStreamingEventsResults();
    private HangingServiceRequestBase request;
    private List<String> errorSubscriptionIds;

    protected GetStreamingEventsResponse(HangingServiceRequestBase request) {
        ArrayList<String> string = new ArrayList<String>();
        this.setErrorSubscriptionIds(string);
        this.request = request;
    }

    @Override
    protected void readElementsFromXml(EwsServiceXmlReader reader) throws Exception {
        String connectionStatus;
        super.readElementsFromXml(reader);
        reader.read();
        if (reader.getLocalName() == "Notifications") {
            this.results.loadFromXml(reader);
        } else if (reader.getLocalName() == "ConnectionStatus" && (connectionStatus = reader.readElementValue(XmlNamespace.Messages, "ConnectionStatus")).equals(ConnectionStatus.Closed.toString())) {
            this.request.disconnect(HangingRequestDisconnectReason.Clean, null);
        }
    }

    @Override
    protected boolean loadExtraErrorDetailsFromXml(EwsServiceXmlReader reader, String xmlElementName) throws Exception {
        boolean baseReturnVal = super.loadExtraErrorDetailsFromXml(reader, xmlElementName);
        if (reader.isStartElement(XmlNamespace.Messages, "ErrorSubscriptionIds")) {
            do {
                reader.read();
                if (reader.getNodeType().getNodeType() != 1 || reader.getLocalName() != "SubscriptionId") continue;
                this.getErrorSubscriptionIds().add(reader.readElementValue(XmlNamespace.Messages, "SubscriptionId"));
            } while (!reader.isEndElement(XmlNamespace.Messages, "ErrorSubscriptionIds"));
            return true;
        }
        return baseReturnVal;
    }

    protected GetStreamingEventsResults getResults() {
        return this.results;
    }

    protected List<String> getErrorSubscriptionIds() {
        return this.errorSubscriptionIds;
    }

    private void setErrorSubscriptionIds(List<String> value) {
        this.errorSubscriptionIds = value;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ConnectionStatus {
        OK,
        Closed;

    }
}

