/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.Grouping;
import microsoft.exchange.webservices.data.ItemTraversal;
import microsoft.exchange.webservices.data.OffsetBasePoint;
import microsoft.exchange.webservices.data.OrderByCollection;
import microsoft.exchange.webservices.data.PagedView;
import microsoft.exchange.webservices.data.ServiceObjectType;
import microsoft.exchange.webservices.data.ServiceRequestBase;
import microsoft.exchange.webservices.data.ServiceValidationException;
import microsoft.exchange.webservices.data.ServiceVersionException;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;

public final class ItemView
extends PagedView {
    private ItemTraversal traversal = ItemTraversal.Shallow;
    private OrderByCollection orderBy = new OrderByCollection();

    protected String getViewXmlElementName() {
        return "IndexedPageItemView";
    }

    protected ServiceObjectType getServiceObjectType() {
        return ServiceObjectType.Item;
    }

    protected void internalValidate(ServiceRequestBase request) throws ServiceVersionException, ServiceValidationException {
        super.internalValidate(request);
        EwsUtilities.validateEnumVersionValue(this.traversal, request.getService().getRequestedServerVersion());
    }

    protected void writeAttributesToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
        writer.writeAttributeValue("Traversal", (Object)this.traversal);
    }

    protected void internalWriteSearchSettingsToXml(EwsServiceXmlWriter writer, Grouping groupBy) throws XMLStreamException, ServiceXmlSerializationException {
        super.internalWriteSearchSettingsToXml(writer, groupBy);
    }

    protected void writeOrderByToXml(EwsServiceXmlWriter writer) throws XMLStreamException, ServiceXmlSerializationException {
        this.orderBy.writeToXml(writer, "SortOrder");
    }

    public ItemView(int pageSize) {
        super(pageSize);
    }

    public ItemView(int pageSize, int offset) {
        super(pageSize, offset);
        this.setOffset(offset);
    }

    public ItemView(int pageSize, int offset, OffsetBasePoint offsetBasePoint) {
        super(pageSize, offset, offsetBasePoint);
    }

    public ItemTraversal getTraversal() {
        return this.traversal;
    }

    public void setTraversal(ItemTraversal value) {
        this.traversal = value;
    }

    public OrderByCollection getOrderBy() {
        return this.orderBy;
    }
}

