/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.FolderId;
import microsoft.exchange.webservices.data.Item;
import microsoft.exchange.webservices.data.MultiResponseServiceRequest;
import microsoft.exchange.webservices.data.ServiceErrorHandling;
import microsoft.exchange.webservices.data.ServiceLocalException;
import microsoft.exchange.webservices.data.ServiceResponse;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.XmlNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SendItemRequest
extends MultiResponseServiceRequest<ServiceResponse> {
    private Iterable<Item> items;
    private FolderId savedCopyDestinationFolderId;

    @Override
    protected void validate() throws Exception {
        super.validate();
        EwsUtilities.validateParam(this.items, "Items");
        if (this.savedCopyDestinationFolderId != null) {
            this.savedCopyDestinationFolderId.validate(this.getService().getRequestedServerVersion());
        }
    }

    @Override
    protected ServiceResponse createServiceResponse(ExchangeService service, int responseIndex) {
        return new ServiceResponse();
    }

    @Override
    protected int getExpectedResponseMessageCount() {
        return EwsUtilities.getEnumeratedObjectCount(this.items.iterator());
    }

    @Override
    protected String getXmlElementName() {
        return "SendItem";
    }

    @Override
    protected String getResponseXmlElementName() {
        return "SendItemResponse";
    }

    @Override
    protected String getResponseMessageXmlElementName() {
        return "SendItemResponseMessage";
    }

    @Override
    protected void writeAttributesToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
        super.writeAttributesToXml(writer);
        writer.writeAttributeValue("SaveItemToFolder", this.savedCopyDestinationFolderId != null);
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws ServiceLocalException, Exception {
        writer.writeStartElement(XmlNamespace.Messages, "ItemIds");
        for (Item item : this.getItems()) {
            item.getId().writeToXml(writer, "ItemId");
        }
        writer.writeEndElement();
        if (this.savedCopyDestinationFolderId != null) {
            writer.writeStartElement(XmlNamespace.Messages, "SavedItemFolderId");
            this.savedCopyDestinationFolderId.writeToXml(writer);
            writer.writeEndElement();
        }
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    protected SendItemRequest(ExchangeService service, ServiceErrorHandling errorHandlingMode) throws Exception {
        super(service, errorHandlingMode);
    }

    public Iterable<Item> getItems() {
        return this.items;
    }

    public void setItems(Iterable<Item> items) {
        this.items = items;
    }

    public FolderId getSavedCopyDestinationFolderId() {
        return this.savedCopyDestinationFolderId;
    }

    public void setSavedCopyDestinationFolderId(FolderId savedCopyDestinationFolderId) {
        this.savedCopyDestinationFolderId = savedCopyDestinationFolderId;
    }
}

