/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import microsoft.exchange.webservices.data.AsyncCallback;
import microsoft.exchange.webservices.data.AsyncExecutor;
import microsoft.exchange.webservices.data.AsyncRequestResult;
import microsoft.exchange.webservices.data.CallableMethod;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.HttpWebRequest;
import microsoft.exchange.webservices.data.IAsyncResult;
import microsoft.exchange.webservices.data.OutParam;
import microsoft.exchange.webservices.data.ServiceLocalException;
import microsoft.exchange.webservices.data.ServiceRequestBase;
import microsoft.exchange.webservices.data.ServiceRequestException;
import microsoft.exchange.webservices.data.Strings;
import microsoft.exchange.webservices.data.TraceFlags;
import microsoft.exchange.webservices.data.WebAsyncCallStateAnchor;
import org.apache.commons.httpclient.HttpException;

abstract class SimpleServiceRequestBase
extends ServiceRequestBase {
    protected SimpleServiceRequestBase(ExchangeService service) throws Exception {
        super(service);
    }

    protected Object internalExecute() throws ServiceLocalException, Exception {
        OutParam<HttpWebRequest> outParam = new OutParam<HttpWebRequest>();
        HttpWebRequest response = this.validateAndEmitRequest(outParam);
        try {
            Object object = this.readResponse(response);
            return object;
        }
        catch (IOException ex) {
            throw new ServiceRequestException(String.format(Strings.ServiceRequestFailed, ex.getMessage(), ex));
        }
        catch (Exception e) {
            if (response != null) {
                this.getService().processHttpResponseHeaders(TraceFlags.EwsResponseHttpHeaders, response);
            }
            throw new ServiceRequestException(String.format(Strings.ServiceRequestFailed, e.getMessage()), e);
        }
        finally {
            try {
                response.close();
            }
            catch (Exception e2) {
                response = null;
            }
        }
    }

    protected Object endInternalExecute(IAsyncResult asyncResult) throws Exception {
        FutureTask task = ((AsyncRequestResult)asyncResult).getTask();
        HttpWebRequest response = (HttpWebRequest)asyncResult.get();
        return this.readResponse(response);
    }

    protected AsyncRequestResult beginExecute(AsyncCallback callback, Object state) throws Exception {
        this.validate();
        HttpWebRequest request = (HttpWebRequest)this.buildEwsHttpWebRequest().getParam();
        WebAsyncCallStateAnchor wrappedState = new WebAsyncCallStateAnchor(this, request, callback, state);
        AsyncExecutor es = new AsyncExecutor();
        CallableMethod cl = new CallableMethod(request);
        Future task = es.submit(cl, callback);
        es.shutdown();
        AsyncRequestResult ft = new AsyncRequestResult(this, request, task, null);
        return ft;
    }

    private Object readResponse(HttpWebRequest response) throws Exception {
        Object serviceResponse;
        try {
            this.getService().processHttpResponseHeaders(TraceFlags.EwsResponseHttpHeaders, response);
            if (this.getService().isTraceEnabledFor(TraceFlags.EwsResponse)) {
                int data;
                ByteArrayOutputStream memoryStream = new ByteArrayOutputStream();
                InputStream serviceResponseStream = ServiceRequestBase.getResponseStream(response);
                while (-1 != (data = serviceResponseStream.read())) {
                    memoryStream.write(data);
                }
                this.traceResponse(response, memoryStream);
                ByteArrayInputStream memoryStreamIn = new ByteArrayInputStream(memoryStream.toByteArray());
                EwsServiceXmlReader ewsXmlReader = new EwsServiceXmlReader(memoryStreamIn, this.getService());
                serviceResponse = this.readResponse(ewsXmlReader);
                serviceResponseStream.close();
                memoryStream.flush();
            } else {
                InputStream responseStream = ServiceRequestBase.getResponseStream(response);
                EwsServiceXmlReader ewsXmlReader = new EwsServiceXmlReader(responseStream, this.getService());
                serviceResponse = this.readResponse(ewsXmlReader);
            }
        }
        catch (HttpException e) {
            if (e.getMessage() != null) {
                this.getService().processHttpResponseHeaders(TraceFlags.EwsResponseHttpHeaders, response);
            }
            throw new ServiceRequestException(String.format(Strings.ServiceRequestFailed, e.getMessage()), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new ServiceRequestException(String.format(Strings.ServiceRequestFailed, e.getMessage()), e);
        }
        return serviceResponse;
    }
}

