/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.TimeZoneDefinition;
import microsoft.exchange.webservices.data.TimeZoneTransition;
import microsoft.exchange.webservices.data.TimeZoneTransitionGroup;
import microsoft.exchange.webservices.data.XmlNamespace;

class AbsoluteDateTransition
extends TimeZoneTransition {
    private Date dateTime;

    protected String getXmlElementName() {
        return "AbsoluteDateTransition";
    }

    protected boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws ParseException, Exception {
        boolean result = super.tryReadElementFromXml(reader);
        if (!result && reader.getLocalName().equals("DateTime")) {
            SimpleDateFormat sdfin = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            this.dateTime = sdfin.parse(reader.readElementValue());
            result = true;
        }
        return result;
    }

    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException, XMLStreamException {
        super.writeElementsToXml(writer);
        writer.writeElementValue(XmlNamespace.Types, "DateTime", this.dateTime);
    }

    protected AbsoluteDateTransition(TimeZoneDefinition timeZoneDefinition) {
        super(timeZoneDefinition);
    }

    protected AbsoluteDateTransition(TimeZoneDefinition timeZoneDefinition, TimeZoneTransitionGroup targetGroup) {
        super(timeZoneDefinition, targetGroup);
    }

    protected Date getDateTime() {
        return this.dateTime;
    }

    protected void setDateTime(Date dateTime) {
        this.dateTime = dateTime;
    }
}

