/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.AutodiscoverErrorCode;
import microsoft.exchange.webservices.data.AutodiscoverResponse;
import microsoft.exchange.webservices.data.AutodiscoverResponseException;
import microsoft.exchange.webservices.data.AutodiscoverService;
import microsoft.exchange.webservices.data.EWSHttpException;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.EwsXmlReader;
import microsoft.exchange.webservices.data.ExchangeServerInfo;
import microsoft.exchange.webservices.data.HttpWebRequest;
import microsoft.exchange.webservices.data.ServiceLocalException;
import microsoft.exchange.webservices.data.ServiceRemoteException;
import microsoft.exchange.webservices.data.ServiceRequestException;
import microsoft.exchange.webservices.data.ServiceResponse;
import microsoft.exchange.webservices.data.ServiceResponseException;
import microsoft.exchange.webservices.data.ServiceXmlDeserializationException;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.SoapFaultDetails;
import microsoft.exchange.webservices.data.Strings;
import microsoft.exchange.webservices.data.TraceFlags;
import microsoft.exchange.webservices.data.XmlNamespace;

abstract class AutodiscoverRequest {
    private AutodiscoverService service;
    private URI url;

    protected AutodiscoverRequest(AutodiscoverService service, URI url) {
        this.service = service;
        this.url = url;
    }

    protected static boolean isRedirectionResponse(HttpWebRequest request) throws EWSHttpException {
        return request.getResponseCode() == 301 || request.getResponseCode() == 302 || request.getResponseCode() == 307 || request.getResponseCode() == 303;
    }

    protected void validate() throws ServiceLocalException, Exception {
        this.getService().validate();
    }

    protected AutodiscoverResponse internalExecute() throws ServiceLocalException, Exception {
        this.validate();
        HttpWebRequest request = null;
        try {
            int data;
            request = this.service.prepareHttpWebRequestForUrl(this.url);
            this.service.traceHttpRequestHeaders(TraceFlags.AutodiscoverRequestHttpHeaders, request);
            boolean needSignature = this.getService().getCredentials() != null && this.getService().getCredentials().isNeedSignature();
            boolean needTrace = this.getService().isTraceEnabledFor(TraceFlags.AutodiscoverRequest);
            OutputStream urlOutStream = request.getOutputStream();
            ByteArrayOutputStream memoryStream = new ByteArrayOutputStream();
            EwsServiceXmlWriter writer = new EwsServiceXmlWriter(this.getService(), memoryStream);
            writer.setRequireWSSecurityUtilityNamespace(needSignature);
            this.writeSoapRequest(this.url, writer);
            if (needSignature) {
                this.service.getCredentials().sign(memoryStream);
            }
            if (needTrace) {
                memoryStream.flush();
                this.service.traceXml(TraceFlags.AutodiscoverRequest, memoryStream);
            }
            memoryStream.writeTo(urlOutStream);
            urlOutStream.flush();
            urlOutStream.close();
            memoryStream.close();
            request.executeRequest();
            request.getResponseCode();
            if (AutodiscoverRequest.isRedirectionResponse(request)) {
                AutodiscoverResponse response = this.createRedirectionResponse(request);
                if (response != null) {
                    AutodiscoverResponse autodiscoverResponse = response;
                    return autodiscoverResponse;
                }
                throw new ServiceRemoteException(Strings.InvalidRedirectionResponseReturned);
            }
            memoryStream = new ByteArrayOutputStream();
            InputStream serviceResponseStream = request.getInputStream();
            while (-1 != (data = serviceResponseStream.read())) {
                memoryStream.write(data);
            }
            memoryStream.flush();
            serviceResponseStream.close();
            if (this.service.isTraceEnabled()) {
                this.service.traceResponse(request, memoryStream);
            }
            ByteArrayInputStream memoryStreamIn = new ByteArrayInputStream(memoryStream.toByteArray());
            EwsXmlReader ewsXmlReader = new EwsXmlReader(memoryStreamIn);
            ewsXmlReader.read();
            if (ewsXmlReader.getNodeType().getNodeType() == 7) {
                ewsXmlReader.readStartElement(XmlNamespace.Soap, "Envelope");
            } else if (ewsXmlReader.getNodeType().getNodeType() != 1 || !ewsXmlReader.getLocalName().equals("Envelope") || !ewsXmlReader.getNamespaceUri().equals(EwsUtilities.getNamespaceUri(XmlNamespace.Soap))) {
                throw new ServiceXmlDeserializationException(Strings.InvalidAutodiscoverServiceResponse);
            }
            this.readSoapHeaders(ewsXmlReader);
            AutodiscoverResponse response = this.readSoapBody(ewsXmlReader);
            ewsXmlReader.readEndElement(XmlNamespace.Soap, "Envelope");
            if (response.getErrorCode() == AutodiscoverErrorCode.NoError) {
                AutodiscoverResponse autodiscoverResponse = response;
                return autodiscoverResponse;
            }
            try {
                throw new AutodiscoverResponseException(response.getErrorCode(), response.getErrorMessage());
            }
            catch (XMLStreamException ex) {
                this.service.traceMessage(TraceFlags.AutodiscoverConfiguration, String.format("XML parsing error: %s", ex.getMessage()));
                throw new ServiceRequestException(String.format(Strings.ServiceRequestFailed, ex.getMessage()), ex);
            }
            catch (IOException ex) {
                this.service.traceMessage(TraceFlags.AutodiscoverConfiguration, String.format("I/O error: %s", ex.getMessage()));
                throw new ServiceRequestException(String.format(Strings.ServiceRequestFailed, ex.getMessage()), ex);
            }
            catch (Exception ex) {
                if (null != request && request.getResponseCode() == 7) {
                    if (AutodiscoverRequest.isRedirectionResponse(request)) {
                        this.service.processHttpResponseHeaders(TraceFlags.AutodiscoverResponseHttpHeaders, request);
                        AutodiscoverResponse response2 = this.createRedirectionResponse(request);
                        if (response2 != null) {
                            AutodiscoverResponse autodiscoverResponse = response2;
                            return autodiscoverResponse;
                        }
                    } else {
                        this.processWebException(ex, request);
                    }
                }
                throw new ServiceRequestException(String.format(Strings.ServiceRequestFailed, ex.getMessage()), ex);
            }
        }
        finally {
            try {
                request.close();
            }
            catch (Exception e2) {
                request = null;
            }
        }
    }

    private void processWebException(Exception exception, HttpWebRequest req) {
        SoapFaultDetails soapFaultDetails = null;
        if (null != req) {
            try {
                if (500 == req.getResponseCode()) {
                    if (this.service.isTraceEnabledFor(TraceFlags.AutodiscoverRequest)) {
                        int data;
                        ByteArrayOutputStream memoryStream = new ByteArrayOutputStream();
                        InputStream serviceResponseStream = AutodiscoverRequest.getResponseStream(req);
                        while (-1 != (data = serviceResponseStream.read())) {
                            memoryStream.write(data);
                        }
                        memoryStream.flush();
                        serviceResponseStream.close();
                        this.service.traceResponse(req, memoryStream);
                        ByteArrayInputStream memoryStreamIn = new ByteArrayInputStream(memoryStream.toByteArray());
                        EwsXmlReader reader = new EwsXmlReader(memoryStreamIn);
                        this.readSoapFault(reader);
                        memoryStream.close();
                    } else {
                        InputStream serviceResponseStream = AutodiscoverRequest.getResponseStream(req);
                        EwsXmlReader reader = new EwsXmlReader(serviceResponseStream);
                        soapFaultDetails = this.readSoapFault(reader);
                        serviceResponseStream.close();
                        if (soapFaultDetails != null) {
                            throw new ServiceResponseException(new ServiceResponse(soapFaultDetails));
                        }
                    }
                } else {
                    this.service.processHttpErrorResponse(req, exception);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private AutodiscoverResponse createRedirectionResponse(HttpWebRequest httpWebResponse) throws XMLStreamException, IOException, EWSHttpException {
        String location = httpWebResponse.getResponseHeaderField("Location");
        if (location != null && !location.isEmpty()) {
            try {
                URI redirectionUri = new URI(location);
                if (redirectionUri.getScheme().toLowerCase().equals("http") || redirectionUri.getScheme().toLowerCase().equals("https")) {
                    AutodiscoverResponse response = this.createServiceResponse();
                    response.setErrorCode(AutodiscoverErrorCode.RedirectUrl);
                    response.setRedirectionUrl(redirectionUri);
                    return response;
                }
                this.service.traceMessage(TraceFlags.AutodiscoverConfiguration, String.format("Invalid redirection URL '%s' returned by Autodiscover service.", redirectionUri.toString()));
            }
            catch (URISyntaxException ex) {
                this.service.traceMessage(TraceFlags.AutodiscoverConfiguration, String.format("Invalid redirection location '%s' returned by Autodiscover service.", location));
            }
        } else {
            this.service.traceMessage(TraceFlags.AutodiscoverConfiguration, "Redirection response returned by Autodiscover service without redirection location.");
        }
        return null;
    }

    private SoapFaultDetails readSoapFault(EwsXmlReader reader) {
        SoapFaultDetails soapFaultDetails = null;
        try {
            reader.read();
            if (reader.getNodeType().getNodeType() == 7) {
                reader.read();
            }
            if (!reader.isStartElement() || !reader.getLocalName().equals("Envelope")) {
                return soapFaultDetails;
            }
            XmlNamespace soapNamespace = EwsUtilities.getNamespaceFromUri(reader.getNamespaceUri());
            if (soapNamespace == XmlNamespace.NotSpecified) {
                return soapFaultDetails;
            }
            reader.read();
            if (reader.isStartElement(soapNamespace, "Header")) {
                do {
                    reader.read();
                } while (!reader.isEndElement(soapNamespace, "Header"));
                reader.read();
            }
            if (reader.isStartElement(soapNamespace, "Body")) {
                do {
                    reader.read();
                    if (!reader.isStartElement(soapNamespace, "Fault")) continue;
                    soapFaultDetails = SoapFaultDetails.parse(reader, soapNamespace);
                } while (!reader.isEndElement(soapNamespace, "Body"));
            }
            reader.readEndElement(soapNamespace, "Envelope");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return soapFaultDetails;
    }

    protected void writeSoapRequest(URI requestUrl, EwsServiceXmlWriter writer) throws XMLStreamException, ServiceXmlSerializationException {
        if (writer.isRequireWSSecurityUtilityNamespace()) {
            writer.writeAttributeValue("xmlns", "wsu", (Object)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        }
        writer.writeStartDocument();
        writer.writeStartElement(XmlNamespace.Soap, "Envelope");
        writer.writeAttributeValue("xmlns", EwsUtilities.getNamespacePrefix(XmlNamespace.Soap), (Object)EwsUtilities.getNamespaceUri(XmlNamespace.Soap));
        writer.writeAttributeValue("xmlns", "a", (Object)"http://schemas.microsoft.com/exchange/2010/Autodiscover");
        writer.writeAttributeValue("xmlns", "wsa", (Object)"http://www.w3.org/2005/08/addressing");
        writer.writeAttributeValue("xmlns", "xsi", (Object)"http://www.w3.org/2001/XMLSchema-instance");
        writer.writeStartElement(XmlNamespace.Soap, "Header");
        if (this.service.getCredentials() != null) {
            this.service.getCredentials().emitExtraSoapHeaderNamespaceAliases(writer.getInternalWriter());
        }
        writer.writeElementValue(XmlNamespace.Autodiscover, "RequestedServerVersion", this.service.getRequestedServerVersion().toString());
        writer.writeElementValue(XmlNamespace.WSAddressing, "Action", this.getWsAddressingActionName());
        writer.writeElementValue(XmlNamespace.WSAddressing, "To", requestUrl.toString());
        this.writeExtraCustomSoapHeadersToXml(writer);
        if (this.service.getCredentials() != null) {
            this.service.getCredentials().serializeWSSecurityHeaders(writer.getInternalWriter());
        }
        this.service.doOnSerializeCustomSoapHeaders(writer.getInternalWriter());
        writer.writeEndElement();
        writer.writeStartElement(XmlNamespace.Soap, "Body");
        this.writeBodyToXml(writer);
        writer.writeEndElement();
        writer.writeEndElement();
        writer.flush();
        writer.dispose();
    }

    protected void writeExtraCustomSoapHeadersToXml(EwsServiceXmlWriter writer) throws XMLStreamException, ServiceXmlSerializationException {
    }

    protected void writeBodyToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException, XMLStreamException {
        writer.writeStartElement(XmlNamespace.Autodiscover, this.getRequestXmlElementName());
        this.writeAttributesToXml(writer);
        this.writeElementsToXml(writer);
        writer.writeEndElement();
    }

    protected static InputStream getResponseStream(HttpWebRequest request) throws EWSHttpException, IOException {
        String contentEncoding = "";
        if (null != request.getContentEncoding()) {
            contentEncoding = request.getContentEncoding().toLowerCase();
        }
        InputStream responseStream = contentEncoding.contains("gzip") ? new GZIPInputStream(request.getInputStream()) : (contentEncoding.contains("deflate") ? new InflaterInputStream(request.getInputStream()) : request.getInputStream());
        return responseStream;
    }

    protected void readSoapHeaders(EwsXmlReader reader) throws Exception {
        reader.readStartElement(XmlNamespace.Soap, "Header");
        do {
            reader.read();
            this.readSoapHeader(reader);
        } while (!reader.isEndElement(XmlNamespace.Soap, "Header"));
    }

    protected void readSoapHeader(EwsXmlReader reader) throws Exception {
        if (reader.isStartElement(XmlNamespace.Autodiscover, "ServerVersionInfo")) {
            this.service.setServerInfo(this.readServerVersionInfo(reader));
        }
    }

    private ExchangeServerInfo readServerVersionInfo(EwsXmlReader reader) throws Exception {
        ExchangeServerInfo serverInfo = new ExchangeServerInfo();
        do {
            reader.read();
            if (!reader.isStartElement()) continue;
            if (reader.getLocalName().equals("MajorVersion")) {
                serverInfo.setMajorVersion(reader.readElementValue(Integer.class));
                continue;
            }
            if (reader.getLocalName().equals("MinorVersion")) {
                serverInfo.setMinorVersion(reader.readElementValue(Integer.class));
                continue;
            }
            if (reader.getLocalName().equals("MajorBuildNumber")) {
                serverInfo.setMajorBuildNumber(reader.readElementValue(Integer.class));
                continue;
            }
            if (reader.getLocalName().equals("MinorBuildNumber")) {
                serverInfo.setMinorBuildNumber(reader.readElementValue(Integer.class));
                continue;
            }
            if (!reader.getLocalName().equals("Version")) continue;
            serverInfo.setVersionString(reader.readElementValue());
        } while (!reader.isEndElement(XmlNamespace.Autodiscover, "ServerVersionInfo"));
        return serverInfo;
    }

    protected AutodiscoverResponse readSoapBody(EwsXmlReader reader) throws InstantiationException, IllegalAccessException, ParseException, Exception {
        reader.readStartElement(XmlNamespace.Soap, "Body");
        AutodiscoverResponse responses = this.loadFromXml(reader);
        reader.readEndElement(XmlNamespace.Soap, "Body");
        return responses;
    }

    protected AutodiscoverResponse loadFromXml(EwsXmlReader reader) throws InstantiationException, IllegalAccessException, ParseException, Exception {
        String elementName = this.getResponseXmlElementName();
        reader.readStartElement(XmlNamespace.Autodiscover, elementName);
        AutodiscoverResponse response = this.createServiceResponse();
        response.loadFromXml(reader, elementName);
        return response;
    }

    protected abstract String getRequestXmlElementName();

    protected abstract String getResponseXmlElementName();

    protected abstract String getWsAddressingActionName();

    protected abstract AutodiscoverResponse createServiceResponse();

    protected abstract void writeAttributesToXml(EwsServiceXmlWriter var1) throws ServiceXmlSerializationException;

    protected abstract void writeElementsToXml(EwsServiceXmlWriter var1) throws XMLStreamException, ServiceXmlSerializationException;

    protected AutodiscoverService getService() {
        return this.service;
    }

    protected URI getUrl() {
        return this.url;
    }
}

