/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.Date;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.FreeBusyViewType;
import microsoft.exchange.webservices.data.GetUserAvailabilityRequest;
import microsoft.exchange.webservices.data.Strings;
import microsoft.exchange.webservices.data.SuggestionQuality;
import microsoft.exchange.webservices.data.TimeWindow;
import microsoft.exchange.webservices.data.XmlNamespace;

public final class AvailabilityOptions {
    private int mergedFreeBusyInterval = 30;
    private FreeBusyViewType requestedFreeBusyView = FreeBusyViewType.Detailed;
    private int goodSuggestionThreshold = 25;
    private int maximumSuggestionsPerDay = 10;
    private int maximumNonWorkHoursSuggestionsPerDay = 0;
    private int meetingDuration = 60;
    private SuggestionQuality minimumSuggestionQuality = SuggestionQuality.Fair;
    private TimeWindow detailedSuggestionsWindow;
    private Date currentMeetingTime;
    private String globalObjectId;

    protected void validate(long timeWindow) throws Exception {
        if ((long)this.mergedFreeBusyInterval > timeWindow) {
            throw new IllegalArgumentException(String.format("%s,%s", Strings.MergedFreeBusyIntervalMustBeSmallerThanTimeWindow, "MergedFreeBusyInterval"));
        }
        EwsUtilities.validateParamAllowNull(this.detailedSuggestionsWindow, "DetailedSuggestionsWindow");
    }

    protected void writeToXml(EwsServiceXmlWriter writer, GetUserAvailabilityRequest request) throws Exception {
        if (request.isFreeBusyViewRequested()) {
            writer.writeStartElement(XmlNamespace.Types, "FreeBusyViewOptions");
            request.getTimeWindow().writeToXmlUnscopedDatesOnly(writer, "TimeWindow");
            writer.writeElementValue(XmlNamespace.Types, "MergedFreeBusyIntervalInMinutes", this.mergedFreeBusyInterval);
            writer.writeElementValue(XmlNamespace.Types, "RequestedView", (Object)this.requestedFreeBusyView);
            writer.writeEndElement();
        }
        if (request.isSuggestionsViewRequested()) {
            writer.writeStartElement(XmlNamespace.Types, "SuggestionsViewOptions");
            writer.writeElementValue(XmlNamespace.Types, "GoodThreshold", this.goodSuggestionThreshold);
            writer.writeElementValue(XmlNamespace.Types, "MaximumResultsByDay", this.maximumSuggestionsPerDay);
            writer.writeElementValue(XmlNamespace.Types, "MaximumNonWorkHourResultsByDay", this.maximumNonWorkHoursSuggestionsPerDay);
            writer.writeElementValue(XmlNamespace.Types, "MeetingDurationInMinutes", this.meetingDuration);
            writer.writeElementValue(XmlNamespace.Types, "MinimumSuggestionQuality", (Object)this.minimumSuggestionQuality);
            TimeWindow timeWindowToSerialize = this.detailedSuggestionsWindow == null ? request.getTimeWindow() : this.detailedSuggestionsWindow;
            timeWindowToSerialize.writeToXmlUnscopedDatesOnly(writer, "DetailedSuggestionsWindow");
            if (this.currentMeetingTime != null) {
                writer.writeElementValue(XmlNamespace.Types, "CurrentMeetingTime", this.currentMeetingTime);
            }
            writer.writeElementValue(XmlNamespace.Types, "GlobalObjectId", this.globalObjectId);
            writer.writeEndElement();
        }
    }

    public int getMergedFreeBusyInterval() {
        return this.mergedFreeBusyInterval;
    }

    public void setMergedFreeBusyInterval(int value) {
        if (value < 5 || value > 1440) {
            throw new IllegalArgumentException(String.format("%s,%s,%s,%s", Strings.InvalidPropertyValueNotInRange, "MergedFreeBusyInterval", 5, 1440));
        }
        this.mergedFreeBusyInterval = value;
    }

    public FreeBusyViewType getRequestedFreeBusyView() {
        return this.requestedFreeBusyView;
    }

    public void setRequestedFreeBusyView(FreeBusyViewType value) {
        this.requestedFreeBusyView = value;
    }

    public int getGoodSuggestionThreshold() {
        return this.goodSuggestionThreshold;
    }

    public void setGoodSuggestionThreshold(int value) {
        if (value < 1 || value > 49) {
            throw new IllegalArgumentException(String.format(Strings.InvalidPropertyValueNotInRange, "GoodSuggestionThreshold", 1, 49));
        }
        this.goodSuggestionThreshold = value;
    }

    public int getMaximumSuggestionsPerDay() {
        return this.maximumSuggestionsPerDay;
    }

    public void setMaximumSuggestionsPerDay(int value) {
        if (value < 0 || value > 48) {
            throw new IllegalArgumentException(String.format("%s,%s,%s,%s", Strings.InvalidPropertyValueNotInRange, "MaximumSuggestionsPerDay", 0, 48));
        }
        this.maximumSuggestionsPerDay = value;
    }

    public int getMaximumNonWorkHoursSuggestionsPerDay() {
        return this.maximumNonWorkHoursSuggestionsPerDay;
    }

    public void setMaximumNonWorkHoursSuggestionsPerDay(int value) {
        if (value < 0 || value > 48) {
            throw new IllegalArgumentException(String.format(Strings.InvalidPropertyValueNotInRange, "MaximumNonWorkHoursSuggestionsPerDay", 0, 48));
        }
        this.maximumNonWorkHoursSuggestionsPerDay = value;
    }

    public int getMeetingDuration() {
        return this.meetingDuration;
    }

    public void setMeetingDuration(int value) {
        if (value < 30 || value > 1440) {
            throw new IllegalArgumentException(String.format("%s,%s,%s,%s", Strings.InvalidPropertyValueNotInRange, "MeetingDuration", 30, 1440));
        }
        this.meetingDuration = value;
    }

    public SuggestionQuality getMinimumSuggestionQuality() {
        return this.minimumSuggestionQuality;
    }

    public void setMinimumSuggestionQuality(SuggestionQuality value) {
        this.minimumSuggestionQuality = value;
    }

    public TimeWindow getDetailedSuggestionsWindow() {
        return this.detailedSuggestionsWindow;
    }

    public void setDetailedSuggestionsWindow(TimeWindow value) {
        this.detailedSuggestionsWindow = value;
    }

    public Date getCurrentMeetingTime() {
        return this.currentMeetingTime;
    }

    public void setCurrentMeetingTime(Date value) {
        this.currentMeetingTime = value;
    }

    public String getGlobalObjectId() {
        return this.globalObjectId;
    }

    public void setGlobalObjectId(String value) {
        this.globalObjectId = value;
    }
}

