/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.EnumSet;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.FolderId;
import microsoft.exchange.webservices.data.GetUserConfigurationResponse;
import microsoft.exchange.webservices.data.MultiResponseServiceRequest;
import microsoft.exchange.webservices.data.ServiceErrorHandling;
import microsoft.exchange.webservices.data.ServiceLocalException;
import microsoft.exchange.webservices.data.UserConfiguration;
import microsoft.exchange.webservices.data.UserConfigurationProperties;
import microsoft.exchange.webservices.data.XmlNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GetUserConfigurationRequest
extends MultiResponseServiceRequest<GetUserConfigurationResponse> {
    private String name;
    private FolderId parentFolderId;
    private EnumSet<UserConfigurationProperties> properties;
    private UserConfiguration userConfiguration;

    @Override
    protected void validate() throws ServiceLocalException, Exception {
        super.validate();
        EwsUtilities.validateParam(this.name, "name");
        EwsUtilities.validateParam(this.parentFolderId, "parentFolderId");
        this.getParentFolderId().validate(this.getService().getRequestedServerVersion());
    }

    @Override
    protected GetUserConfigurationResponse createServiceResponse(ExchangeService service, int responseIndex) throws Exception {
        if (this.userConfiguration == null) {
            this.userConfiguration = new UserConfiguration(service, this.properties);
            this.userConfiguration.setName(this.name);
            this.userConfiguration.setParentFolderId(this.parentFolderId);
        }
        return new GetUserConfigurationResponse(this.userConfiguration);
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2010;
    }

    @Override
    protected int getExpectedResponseMessageCount() {
        return 1;
    }

    @Override
    protected String getXmlElementName() {
        return "GetUserConfiguration";
    }

    @Override
    protected String getResponseXmlElementName() {
        return "GetUserConfigurationResponse";
    }

    @Override
    protected String getResponseMessageXmlElementName() {
        return "GetUserConfigurationResponseMessage";
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        String EnumDelimiter = ",";
        UserConfiguration.writeUserConfigurationNameToXml(writer, XmlNamespace.Messages, this.name, this.parentFolderId);
        writer.writeElementValue(XmlNamespace.Messages, "UserConfigurationProperties", this.properties.toString().replace(",", "").replace("[", "").replace("]", ""));
    }

    protected GetUserConfigurationRequest(ExchangeService service) throws Exception {
        super(service, ServiceErrorHandling.ThrowOnError);
    }

    protected String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected FolderId getParentFolderId() {
        return this.parentFolderId;
    }

    protected void setParentFolderId(FolderId parentFolderId) {
        this.parentFolderId = parentFolderId;
    }

    protected UserConfiguration getUserConfiguration() {
        return this.userConfiguration;
    }

    protected void setUserConfiguration(UserConfiguration userConfiguration) {
        this.userConfiguration = userConfiguration;
        this.name = this.userConfiguration.getName();
        this.parentFolderId = this.userConfiguration.getParentFolderId();
    }

    protected EnumSet<UserConfigurationProperties> getProperties() {
        return this.properties;
    }

    protected void setProperties(EnumSet<UserConfigurationProperties> properties) {
        this.properties = properties;
    }
}

