/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.net.URI;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.AutodiscoverErrorCode;
import microsoft.exchange.webservices.data.AutodiscoverRequest;
import microsoft.exchange.webservices.data.AutodiscoverResponse;
import microsoft.exchange.webservices.data.AutodiscoverService;
import microsoft.exchange.webservices.data.Convert;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.EwsXmlReader;
import microsoft.exchange.webservices.data.ExchangeServiceBase;
import microsoft.exchange.webservices.data.GetUserSettingsResponse;
import microsoft.exchange.webservices.data.GetUserSettingsResponseCollection;
import microsoft.exchange.webservices.data.ServiceLocalException;
import microsoft.exchange.webservices.data.ServiceValidationException;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.Strings;
import microsoft.exchange.webservices.data.UserSettingName;
import microsoft.exchange.webservices.data.XmlNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GetUserSettingsRequest
extends AutodiscoverRequest {
    private static final String GetUserSettingsActionUri = "http://schemas.microsoft.com/exchange/2010/Autodiscover/Autodiscover/GetUserSettings";
    private List<String> smtpAddresses;
    private List<UserSettingName> settings;
    private boolean expectPartnerToken = false;
    private String partnerTokenReference;
    private String partnerToken;

    protected GetUserSettingsRequest(AutodiscoverService service, URI url) throws ServiceValidationException {
        this(service, url, false);
    }

    protected GetUserSettingsRequest(AutodiscoverService service, URI url, boolean expectPartnerToken) throws ServiceValidationException {
        super(service, url);
        this.expectPartnerToken = expectPartnerToken;
        if (expectPartnerToken && !url.getScheme().equalsIgnoreCase("https")) {
            throw new ServiceValidationException(Strings.HttpsIsRequired);
        }
    }

    @Override
    protected void validate() throws Exception {
        super.validate();
        EwsUtilities.validateParam(this.getSmtpAddresses(), "smtpAddresses");
        EwsUtilities.validateParam(this.getSettings(), "settings");
        if (this.getSettings().size() == 0) {
            throw new ServiceValidationException(Strings.InvalidAutodiscoverSettingsCount);
        }
        if (this.getSmtpAddresses().size() == 0) {
            throw new ServiceValidationException(Strings.InvalidAutodiscoverSmtpAddressesCount);
        }
        for (String smtpAddress : this.getSmtpAddresses()) {
            if (smtpAddress != null && !smtpAddress.isEmpty()) continue;
            throw new ServiceValidationException(Strings.InvalidAutodiscoverSmtpAddress);
        }
    }

    protected GetUserSettingsResponseCollection execute() throws ServiceLocalException, Exception {
        GetUserSettingsResponseCollection responses = (GetUserSettingsResponseCollection)this.internalExecute();
        if (responses.getErrorCode() == AutodiscoverErrorCode.NoError) {
            this.postProcessResponses(responses);
        }
        return responses;
    }

    private void postProcessResponses(GetUserSettingsResponseCollection responses) {
        for (int index = 0; index < responses.getCount(); ++index) {
            ((GetUserSettingsResponse)responses.getResponses().get(index)).setSmtpAddress(this.getSmtpAddresses().get(index));
        }
    }

    @Override
    protected String getRequestXmlElementName() {
        return "GetUserSettingsRequestMessage";
    }

    @Override
    protected String getResponseXmlElementName() {
        return "GetUserSettingsResponseMessage";
    }

    @Override
    protected String getWsAddressingActionName() {
        return GetUserSettingsActionUri;
    }

    @Override
    protected AutodiscoverResponse createServiceResponse() {
        return new GetUserSettingsResponseCollection();
    }

    @Override
    protected void writeAttributesToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
        writer.writeAttributeValue("xmlns", "a", (Object)"http://schemas.microsoft.com/exchange/2010/Autodiscover");
    }

    @Override
    protected void writeExtraCustomSoapHeadersToXml(EwsServiceXmlWriter writer) throws XMLStreamException, ServiceXmlSerializationException {
        if (this.expectPartnerToken) {
            writer.writeElementValue(XmlNamespace.Autodiscover, "BinarySecret", Convert.ToBase64String(ExchangeServiceBase.getSessionKey()));
        }
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws XMLStreamException, ServiceXmlSerializationException {
        writer.writeStartElement(XmlNamespace.Autodiscover, "Request");
        writer.writeStartElement(XmlNamespace.Autodiscover, "Users");
        for (String smtpAddress : this.getSmtpAddresses()) {
            writer.writeStartElement(XmlNamespace.Autodiscover, "User");
            if (smtpAddress != null && !smtpAddress.isEmpty()) {
                writer.writeElementValue(XmlNamespace.Autodiscover, "Mailbox", smtpAddress);
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeStartElement(XmlNamespace.Autodiscover, "RequestedSettings");
        for (UserSettingName setting : this.getSettings()) {
            writer.writeElementValue(XmlNamespace.Autodiscover, "Setting", (Object)setting);
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }

    @Override
    protected void readSoapHeader(EwsXmlReader reader) throws Exception {
        super.readSoapHeader(reader);
        if (this.expectPartnerToken) {
            if (reader.isStartElement(XmlNamespace.Autodiscover, "PartnerToken")) {
                this.partnerToken = reader.readInnerXml();
            }
            if (reader.isStartElement(XmlNamespace.Autodiscover, "PartnerTokenReference")) {
                this.partnerTokenReference = reader.readInnerXml();
            }
        }
    }

    protected List<String> getSmtpAddresses() {
        return this.smtpAddresses;
    }

    protected void setSmtpAddresses(List<String> value) {
        this.smtpAddresses = value;
    }

    protected List<UserSettingName> getSettings() {
        return this.settings;
    }

    protected void setSettings(List<UserSettingName> value) {
        this.settings = value;
    }

    protected String getPartnerToken() {
        return this.partnerToken;
    }

    private void setPartnerToken(String value) {
        this.partnerToken = value;
    }

    protected String getPartnerTokenReference() {
        return this.partnerTokenReference;
    }

    private void setPartnerTokenReference(String tokenReference) {
        this.partnerTokenReference = tokenReference;
    }
}

