/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.ServiceObjectPropertyDefinition;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;

public final class IndexedPropertyDefinition
extends ServiceObjectPropertyDefinition {
    private String index;

    protected IndexedPropertyDefinition(String uri, String index) {
        super(uri);
        this.index = index;
    }

    protected static boolean isEqualTo(IndexedPropertyDefinition idxPropDef1, IndexedPropertyDefinition idxPropDef2) {
        return idxPropDef1 == idxPropDef2 || idxPropDef1 != null && idxPropDef2 != null && idxPropDef1.getUri().equalsIgnoreCase(idxPropDef2.getUri()) && idxPropDef1.index.equalsIgnoreCase(idxPropDef2.index);
    }

    public String getIndex() {
        return this.index;
    }

    protected void writeAttributesToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
        super.writeAttributesToXml(writer);
        writer.writeAttributeValue("FieldIndex", this.getIndex());
    }

    protected String getXmlElementName() {
        return "IndexedFieldURI";
    }

    protected String getPrintableName() {
        return String.format("%s:%s", this.getUri(), this.getIndex());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IndexedPropertyDefinition) {
            return IndexedPropertyDefinition.isEqualTo((IndexedPropertyDefinition)obj, this);
        }
        return false;
    }

    public int hashCode() {
        return this.getUri().hashCode() ^ this.getIndex().hashCode();
    }

    public Class getType() {
        return String.class;
    }
}

