/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.crowdin.mojo;

import java.io.File;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.exoplatform.crowdin.model.CrowdinFile;
import org.exoplatform.crowdin.mojo.AbstractCrowdinMojo;
import org.exoplatform.crowdin.utils.FileUtils;

@Mojo(name="upload-translation")
public class UploadTranslationMojo
extends AbstractCrowdinMojo {
    @Override
    public void crowdInMojoExecute() throws MojoExecutionException, MojoFailureException {
        if (this.isAllPropertyFilesExisted()) {
            this.getLog().info((CharSequence)"Starting uploading translations");
            Properties currentProj = this.getProperties();
            String baseDir = currentProj.getProperty("baseDir");
            Set<Object> keys = currentProj.keySet();
            for (Object key : keys) {
                if (key.equals("baseDir")) continue;
                String filePath = this.getWorkingDir() + File.separator + currentProj.getProperty(key.toString());
                CrowdinFile master = this.getFactory().prepareCrowdinFile(filePath, key.toString(), baseDir);
                this.uploadTranslation(master);
            }
            this.getLog().info((CharSequence)"Finished uploading translations");
        }
    }

    private void uploadTranslation(CrowdinFile master) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)"*** Init dir");
        }
        this.initDir(master.getCrowdinPath());
        try {
            String result;
            FileUtils.replaceCharactersInFile(master.getFile().getPath(), "config/special_character_processing.properties", "EscapeSpecialCharactersBeforeSyncFromCodeToCrowdin");
            if (!this.getHelper().elementExists(master.getCrowdinPath())) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("*** Add file: " + master.getCrowdinPath()));
                }
                result = this.getHelper().addFile(master);
            } else {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("*** Update file: " + master.getCrowdinPath()));
                }
                result = this.getHelper().updateFile(master);
            }
            if (result.contains("success")) {
                this.getLog().info((CharSequence)("File " + master.getFile().getName() + " created succesfully."));
                this.initTranslations(master);
            } else {
                this.getLog().warn((CharSequence)("Cannot upload file '" + master.getFile().getPath() + "'. Reason:\n" + result));
            }
            if (master.isShouldBeCleaned()) {
                master.getFile().delete();
            } else {
                FileUtils.replaceCharactersInFile(master.getFile().getPath(), "config/special_character_processing.properties", "EscapeSpecialCharactersAfterSyncFromCodeToCrowdin");
            }
        }
        catch (MojoExecutionException e) {
            this.getLog().error((CharSequence)("Error while updating file '" + master.getFile().getPath() + "'. Exception:\n" + e.getMessage()));
        }
    }
}

