/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.crowdin.mojo;

import java.io.File;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.exoplatform.crowdin.model.CrowdinFile;
import org.exoplatform.crowdin.mojo.AbstractCrowdinMojo;
import org.exoplatform.crowdin.utils.FileUtils;

@Mojo(name="update-crowdin")
public class UpdateCrowdInMojo
extends AbstractCrowdinMojo {
    @Override
    public void crowdInMojoExecute() throws MojoExecutionException, MojoFailureException {
        if (!this.isAllPropertyFilesExisted() && !this.isForce()) {
            this.getLog().info((CharSequence)"\n\n\n");
            this.getLog().info((CharSequence)"----------------------------------------------------------------------------------------\n\n");
            this.getLog().error((CharSequence)"There are nonexistent properties files! Check again and update properties configuration files or run following command to ");
            this.getLog().info((CharSequence)"continue:\n mvn clean install -Psync -Dforce=true \n");
            this.getLog().info((CharSequence)"Warning: All Crowdin files corresponding to nonexistent properties files will be deleted after execute above command.\n");
            this.getLog().info((CharSequence)"----------------------------------------------------------------------------------------\n\n\n");
            throw new MojoExecutionException(UpdateCrowdInMojo.class.getName());
        }
        this.getLog().info((CharSequence)"Starting updating crowdin");
        Properties currentProj = this.getProperties();
        String baseDir = currentProj.getProperty("baseDir");
        Set<Object> files = currentProj.keySet();
        for (Object file : files) {
            if (file.equals("baseDir")) continue;
            String filePath = this.getWorkingDir() + File.separator + currentProj.getProperty(file.toString());
            CrowdinFile master = this.getFactory().prepareCrowdinFile(filePath, file.toString(), baseDir);
            this.updateFile(master);
        }
        this.getLog().info((CharSequence)"Finished updating crowdin");
    }

    private void updateFile(CrowdinFile _file) {
        String fileN = _file.getFile().getName();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("*** Initializing: " + fileN));
        }
        if (_file.getClass().equals(CrowdinFile.class)) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)"*** Init dir");
            }
            this.initDir(_file.getCrowdinPath());
            try {
                if (_file.getFile().exists()) {
                    FileUtils.replaceCharactersInFile(_file.getFile().getPath(), "config/special_character_processing.properties", "EscapeSpecialCharactersBeforeSyncFromCodeToCrowdin");
                    if (!this.getHelper().elementExists(_file.getCrowdinPath())) {
                        String result;
                        if (this.getLog().isDebugEnabled()) {
                            this.getLog().debug((CharSequence)("*** Add file: " + _file.getCrowdinPath()));
                        }
                        if ((result = this.getHelper().addFile(_file)).contains("success")) {
                            this.getLog().info((CharSequence)("File " + fileN + " created succesfully."));
                            this.initTranslations(_file);
                        } else {
                            this.getLog().warn((CharSequence)("Cannot create file '" + _file.getFile().getPath() + "'. Reason:\n" + result));
                            if (_file.isShouldBeCleaned()) {
                                _file.getFile().delete();
                            }
                        }
                    } else {
                        if (this.getLog().isDebugEnabled()) {
                            this.getLog().debug((CharSequence)("*** Update file: " + _file.getCrowdinPath()));
                        }
                        String result = this.getHelper().updateFile(_file);
                        System.out.println(result);
                        if (result.contains("success")) {
                            this.getLog().info((CharSequence)("File " + fileN + " updated succesfully."));
                        } else {
                            this.getLog().warn((CharSequence)("Cannot update file '" + _file.getFile().getPath() + "'. Reason:\n" + result));
                        }
                        if (_file.isShouldBeCleaned()) {
                            _file.getFile().delete();
                        }
                        FileUtils.replaceCharactersInFile(_file.getFile().getPath(), "config/special_character_processing.properties", "EscapeSpecialCharactersAfterSyncFromCodeToCrowdin");
                    }
                } else if (this.getHelper().elementExists(_file.getCrowdinPath())) {
                    String result;
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)("*** Delete file: " + _file.getCrowdinPath()));
                    }
                    if ((result = this.getHelper().deleteFile(_file)).contains("success")) {
                        this.getLog().info((CharSequence)("File " + fileN + " deleted succesfully."));
                    } else {
                        this.getLog().warn((CharSequence)("Cannot delete file '" + _file.getFile().getPath() + "'. Reason:\n" + result));
                    }
                }
            }
            catch (MojoExecutionException e) {
                this.getLog().error((CharSequence)("Error while updating file '" + _file.getFile().getPath() + "'. Exception:\n" + e.getMessage()));
            }
        }
    }
}

