/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.crowdin.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;

public class IOSResouceBundleFileUtils {
    static Log log;

    public static void setLog(Log varLog) {
        log = varLog;
    }

    public static Log getLog() {
        if (log == null) {
            log = new SystemStreamLog();
        }
        return log;
    }

    public static List<String> readAllIOSResource(String filePath) {
        ArrayList<String> output = new ArrayList<String>();
        try {
            File file = new File(filePath);
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line = "";
            while ((line = reader.readLine()) != null) {
                output.add(line);
            }
            reader.close();
            return output;
        }
        catch (IOException ioe) {
            IOSResouceBundleFileUtils.getLog().error((Throwable)ioe);
            return new ArrayList<String>();
        }
    }

    public static List<String> readIOSResourceSkipCommentAndEmtyLine(String filePath) {
        ArrayList<String> output = new ArrayList<String>();
        try {
            File file = new File(filePath);
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line = "";
            boolean isCommentOrEmptyLine = false;
            while ((line = reader.readLine()) != null) {
                if (line.trim().indexOf("//") == 0 || line.trim().length() == 0 || line.trim().indexOf("/*") == 0 && line.trim().indexOf("*/") >= 0) continue;
                if (line.trim().indexOf("/*") == 0) {
                    isCommentOrEmptyLine = true;
                    continue;
                }
                if (line.trim().indexOf("*/") >= 0) {
                    isCommentOrEmptyLine = false;
                    continue;
                }
                if (isCommentOrEmptyLine) continue;
                output.add(line);
            }
            reader.close();
            return output;
        }
        catch (IOException ioe) {
            IOSResouceBundleFileUtils.getLog().error((Throwable)ioe);
            return new ArrayList<String>();
        }
    }

    public static String updateTranslationByLine(String sourceLine, String crowdinLine) {
        if (sourceLine.toString().trim().length() == 0 || crowdinLine.trim().length() == 0) {
            return "";
        }
        try {
            String sourceKey = sourceLine.toString().split("=")[0].trim();
            String crowdinKey = crowdinLine.split("=")[0].trim();
            if (sourceKey.equals(crowdinKey)) {
                StringBuffer buffer = new StringBuffer(sourceKey);
                String crowdinValue = crowdinLine.split("=")[1].trim();
                buffer.append(" = ").append(crowdinValue);
                sourceLine = buffer.toString();
                return sourceLine;
            }
            return "";
        }
        catch (Exception e) {
            IOSResouceBundleFileUtils.getLog().info((Throwable)e);
            return "";
        }
    }

    public static boolean isCommentOrEmptyLine(int lineIndex, List<String> linesOfFile) {
        if (linesOfFile == null || linesOfFile.isEmpty()) {
            return true;
        }
        String lineStr = "";
        try {
            lineStr = linesOfFile.get(lineIndex).trim();
        }
        catch (Exception e) {
            return false;
        }
        if (lineStr.length() == 0) {
            return true;
        }
        if (lineStr.indexOf("//") == 0 || lineStr.indexOf("/*") == 0 || lineStr.indexOf("*/") >= 0) {
            return true;
        }
        for (int checkIndex = lineIndex - 1; checkIndex >= 0; --checkIndex) {
            String previousLineString = linesOfFile.get(checkIndex).trim();
            if (previousLineString.indexOf("/*") == 0) {
                return true;
            }
            if (previousLineString.indexOf("*/") < 0) continue;
            return false;
        }
        return false;
    }

    public static boolean injectTranslation(String crowdinFilePath, String resourceMasterFilePath, String resourceTranslationFilePath) {
        List<String> crowdinList = IOSResouceBundleFileUtils.readIOSResourceSkipCommentAndEmtyLine(crowdinFilePath);
        List<String> resourcelist = IOSResouceBundleFileUtils.readAllIOSResource(resourceMasterFilePath);
        if (resourcelist == null || resourcelist.isEmpty()) {
            return false;
        }
        Iterator<String> resourceIterator = resourcelist.iterator();
        int resouceIndex = 0;
        while (resourceIterator.hasNext()) {
            if (IOSResouceBundleFileUtils.getLog().isDebugEnabled()) {
                IOSResouceBundleFileUtils.getLog().debug((CharSequence)("\n Before Synch: codebase line " + resouceIndex + " = " + resourceIterator.next()));
            }
            if (!IOSResouceBundleFileUtils.isCommentOrEmptyLine(resouceIndex, resourcelist)) {
                Iterator<String> crowdinIterator = crowdinList.iterator();
                int crowdinIndex = 0;
                while (crowdinIterator.hasNext()) {
                    String sourceLine = resourcelist.get(resouceIndex);
                    String newSourceLine = IOSResouceBundleFileUtils.updateTranslationByLine(sourceLine, crowdinList.get(crowdinIndex));
                    if (newSourceLine.length() > 0 && !sourceLine.equals(newSourceLine)) {
                        resourcelist.set(resouceIndex, newSourceLine);
                        crowdinList.remove(crowdinIndex);
                        break;
                    }
                    crowdinIterator.next();
                    ++crowdinIndex;
                }
            }
            if (IOSResouceBundleFileUtils.getLog().isDebugEnabled()) {
                IOSResouceBundleFileUtils.getLog().debug((CharSequence)("\n After Synch: codebase line " + resouceIndex + " = " + resourcelist.get(resouceIndex)));
            }
            resourceIterator.next();
            ++resouceIndex;
        }
        boolean saveTranslation = IOSResouceBundleFileUtils.saveListStringToFile(resourceTranslationFilePath, resourcelist);
        try {
            File file = new File(crowdinFilePath);
            if (file.delete()) {
                IOSResouceBundleFileUtils.getLog().info((CharSequence)(file.getName() + " is deleted!"));
            } else {
                IOSResouceBundleFileUtils.getLog().info((CharSequence)"Delete operation is failed.");
            }
        }
        catch (Exception e) {
            IOSResouceBundleFileUtils.getLog().error((Throwable)e);
        }
        return saveTranslation;
    }

    public static boolean saveListStringToFile(String filePath, List<String> listString) {
        System.out.println("Save translation to file " + filePath);
        try {
            StringBuffer content = new StringBuffer();
            for (String str : listString) {
                content.append(str + System.getProperty("line.separator"));
            }
            FileWriter writer = new FileWriter(filePath);
            writer.write(content.toString());
            writer.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        }
        return true;
    }
}

