#!/bin/bash
#
# $Id: stat-eppsp.sh 8180 2010-09-22 09:34:02Z hgomez $
#
# Copyright (C) 2003-2010 eXo Platform SAS.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU Affero General Public License
# as published by the Free Software Foundation; either version 3
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, see<http://www.gnu.org/licenses/>.#
#
#
# Purpose : Show log file a JBoss EPP single or clustering environnement for QA teams with/without WCM
#
#

echo CARGOSH-EPPSP-CATLOG cargosh-binaries 0.3

JBOSS_DISTR_NAME=jboss-epp

if [ ! -z "$WORKSPACE" ]; then

    EPP_BASE=$WORKSPACE/../../EPP_SP
    ADDONS=$EPP_BASE/addons
    GATEIN_DATA_DIR=$EPP_BASE/gatein_data
    JBOSS_BASE=$EPP_BASE/$JBOSS_DISTR_NAME

    mkdir -p $EPP_BASE
    mkdir -p $ADDONS
    mkdir -p $GATEIN_DATA_DIR
    mkdir -p $JBOSS_BASE

fi


# directory where JBossAS will be installed (if not defined outside)
if [ -z "$JBOSS_BASE" ]; then
    JBOSS_BASE=`pwd`/$JBOSS_DISTR_NAME
fi

# define jboss.server.data.dir since gatein.data.dir=${jboss.server.data.dir}/gatein (if not defined outside)
if [ -z "$GATEIN_DATA_DIR" ]; then
    GATEIN_DATA_DIR=`pwd`/jboss-data/gatein-data
fi

cygwin=false;
linux=false;
darwin=false;
case "`uname`" in
CYGWIN*) cygwin=true;;
Linux*) linux=true;;
Darwin*) darwin=true;;
esac


usage()
{
cat << EOF
usage: $0 options start/stop/restart

This script run JBoss instances.

OPTIONS:
   -h      Show this message
   -i      Define instance number (1-4) to see log.
EOF
}

#
# without parameters, provide help
#
if [ $# -lt 1 ]; then
  usage
  exit 1;
fi

while getopts "hi:" OPTION
do
     case $OPTION in
         h)
             usage
             exit 1
             ;;
         i)
             INSTANCE_NUMBER=$OPTARG
             ;;
         ?)
             usage
             exit
             ;;
     esac
done

JBOSS_LOG=$JBOSS_BASE/server/all$INSTANCE_NUMBER/log/jboss.log
JBOSS_PID=$JBOSS_BASE/server/all$INSTANCE_NUMBER/log/jboss.pid

if [ -f $JBOSS_PID ]; then

    echo "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@"
    echo "@ dumping JBoss #$INSTANCE_NUMBER log file @"
    echo "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@"

    cat $JBOSS_LOG

else

    echo "no pid found JBoss instance is not running..."

fi
