import * as Ast from "../../ast";
import { AbiAllocations, AbiSizeInfo, CalldataAndReturndataAllocation, CalldataAllocation, ReturndataAllocation, CalldataAllocations, ContractAllocationInfo, EventAllocation, EventAllocations } from "./types";
import * as Format from "../../format";
export { AbiAllocations, AbiSizeInfo, CalldataAllocation, ReturndataAllocation, CalldataAndReturndataAllocation, ContractAllocationInfo, EventAllocation };
export declare function getAbiAllocations(userDefinedTypes: Format.Types.TypesById): AbiAllocations;
/**
 * @protected
 */
export declare function abiSizeInfo(dataType: Format.Types.Type, allocations?: AbiAllocations): AbiSizeInfo;
export declare function getCalldataAllocations(contracts: ContractAllocationInfo[], referenceDeclarations: {
    [compilationId: string]: Ast.AstNodes;
}, userDefinedTypes: Format.Types.TypesById, abiAllocations: AbiAllocations): CalldataAllocations;
export declare function getEventAllocations(contracts: ContractAllocationInfo[], referenceDeclarations: {
    [compilationId: string]: Ast.AstNodes;
}, userDefinedTypes: Format.Types.TypesById, abiAllocations: AbiAllocations): EventAllocations;
