import * as AbiData from "../abi-data/types";
import * as Common from "../common";
import * as Compiler from "../compiler";
import { ImmutableReferences } from "@truffle/contract-schema/spec";
export declare type Contexts = DecoderContexts | DebuggerContexts;
export declare type Context = DecoderContext | DebuggerContext;
export interface DecoderContexts {
    [context: string]: DecoderContext;
}
export interface DebuggerContexts {
    [context: string]: DebuggerContext;
}
export interface DecoderContext {
    context: string;
    binary: string;
    isConstructor: boolean;
    immutableReferences?: ImmutableReferences;
    contractName?: string;
    contractId?: number;
    contractKind?: Common.ContractKind;
    abi?: AbiData.FunctionAbiBySelectors;
    payable?: boolean;
    fallbackAbi?: {
        fallback: AbiData.FallbackAbiEntry | null;
        receive: AbiData.ReceiveAbiEntry | null;
    };
    compiler?: Compiler.CompilerVersion;
    compilationId?: string;
    externalSolidity?: boolean;
}
export interface DebuggerContext {
    context: string;
    binary: string;
    isConstructor: boolean;
    immutableReferences?: ImmutableReferences;
    contractName?: string;
    contractId?: number;
    contractKind?: Common.ContractKind;
    abi?: AbiData.Abi;
    sourceMap?: string;
    primarySource?: number;
    compiler?: Compiler.CompilerVersion;
    compilationId?: string;
    payable?: boolean;
    externalSolidity?: boolean;
}
