"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = __importDefault(require("debug"));
const debug = debug_1.default("codec:special:decode");
const Basic = __importStar(require("../../basic"));
const Bytes = __importStar(require("../../bytes"));
const Compiler = __importStar(require("../../compiler"));
const Evm = __importStar(require("../../evm"));
function* decodeSpecial(dataType, pointer, info) {
    if (dataType.typeClass === "magic") {
        return yield* decodeMagic(dataType, pointer, info);
    }
    else {
        return yield* Basic.Decode.decodeBasic(dataType, pointer, info);
    }
}
exports.decodeSpecial = decodeSpecial;
function* decodeMagic(dataType, pointer, info) {
    let { state } = info;
    switch (pointer.special) {
        case "msg":
            return {
                type: dataType,
                kind: "value",
                value: {
                    data: yield* Bytes.Decode.decodeBytes({
                        typeClass: "bytes",
                        kind: "dynamic",
                        location: "calldata"
                    }, {
                        location: "calldata",
                        start: 0,
                        length: state.calldata.length
                    }, info),
                    sig: yield* Basic.Decode.decodeBasic({
                        typeClass: "bytes",
                        kind: "static",
                        length: Evm.Utils.SELECTOR_SIZE
                    }, {
                        location: "calldata",
                        start: 0,
                        length: Evm.Utils.SELECTOR_SIZE
                    }, info),
                    sender: yield* Basic.Decode.decodeBasic(senderType(info.currentContext.compiler), { location: "special", special: "sender" }, info),
                    value: yield* Basic.Decode.decodeBasic({
                        typeClass: "uint",
                        bits: 256
                    }, { location: "special", special: "value" }, info)
                }
            };
        case "tx":
            return {
                type: dataType,
                kind: "value",
                value: {
                    origin: yield* Basic.Decode.decodeBasic(externalAddressType(info.currentContext.compiler), { location: "special", special: "origin" }, info),
                    gasprice: yield* Basic.Decode.decodeBasic({
                        typeClass: "uint",
                        bits: 256
                    }, { location: "special", special: "gasprice" }, info)
                }
            };
        case "block":
            let block = {
                coinbase: yield* Basic.Decode.decodeBasic(externalAddressType(info.currentContext.compiler), { location: "special", special: "coinbase" }, info)
            };
            //the other ones are all uint's, so let's handle them all at once; due to
            //the lack of generator arrow functions, we do it by mutating block
            const variables = ["difficulty", "gaslimit", "number", "timestamp"];
            for (let variable of variables) {
                block[variable] = yield* Basic.Decode.decodeBasic({
                    typeClass: "uint",
                    bits: 256
                }, { location: "special", special: variable }, info);
            }
            return {
                type: dataType,
                kind: "value",
                value: block
            };
    }
}
exports.decodeMagic = decodeMagic;
//NOTE: this is likely going to change again in 0.7.x!  be ready!
function senderType(compiler) {
    switch (Compiler.Utils.solidityFamily(compiler)) {
        case "unknown":
        case "pre-0.5.0":
            return {
                typeClass: "address",
                kind: "general"
            };
        case "0.5.x":
            return {
                typeClass: "address",
                kind: "specific",
                payable: true
            };
    }
}
function externalAddressType(compiler) {
    switch (Compiler.Utils.solidityFamily(compiler)) {
        case "unknown":
        case "pre-0.5.0":
            return {
                typeClass: "address",
                kind: "general"
            };
        case "0.5.x":
            return {
                typeClass: "address",
                kind: "specific",
                payable: true
            };
    }
}
//# sourceMappingURL=index.js.map