"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const web3_interface_adapter_1 = require("./web3-interface-adapter");
const supportedEvmNetworks = ["ethereum", "fabric-evm", "quorum"];
const getNetworkTypeClass = ({ networkType = "ethereum" }) => {
    if (supportedEvmNetworks.includes(networkType))
        return "evm-like";
    return networkType;
};
class InterfaceAdapter {
    constructor(options) {
        switch (getNetworkTypeClass(options)) {
            case "evm-like":
                this.adapter = new web3_interface_adapter_1.Web3InterfaceAdapter({
                    provider: options.provider,
                    networkType: options.networkType
                });
                break;
            default:
                throw Error(`Sorry, "${options.networkType}" is not supported at this time.`);
        }
        return this.adapter;
    }
    getNetworkId() {
        return this.adapter.getNetworkId();
    }
    getBlock(block) {
        return this.adapter.getBlock(block);
    }
    setProvider(provider) {
        return this.adapter.setProvider(provider);
    }
    getTransaction(tx) {
        return this.adapter.getTransaction(tx);
    }
    getTransactionReceipt(tx) {
        return this.adapter.getTransactionReceipt(tx);
    }
    getBalance(address) {
        return this.adapter.getBalance(address);
    }
}
exports.InterfaceAdapter = InterfaceAdapter;
//# sourceMappingURL=interface-adapter.js.map