package org.exoplatform.wallet.contract;

import io.reactivex.Flowable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Bool;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.Utf8String;
import org.web3j.abi.datatypes.generated.Uint16;
import org.web3j.abi.datatypes.generated.Uint256;
import org.web3j.abi.datatypes.generated.Uint8;
import org.web3j.crypto.Credentials;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.core.RemoteFunctionCall;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.BaseEventResponse;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tx.Contract;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;

/**
 * <p>Auto generated code.
 * <p><strong>Do not modify!</strong>
 * <p>Please use the <a href="https://docs.web3j.io/command_line.html">web3j command line tools</a>,
 * or the org.web3j.codegen.SolidityFunctionWrapperGenerator in the 
 * <a href="https://github.com/web3j/web3j/tree/master/codegen">codegen module</a> to update.
 *
 * <p>Generated with web3j version 4.5.11.
 */
@SuppressWarnings("rawtypes")
public class ERTTokenV2 extends Contract {
    public static final String BINARY = "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";

    public static final String FUNC_NAME = "name";

    public static final String FUNC_APPROVE = "approve";

    public static final String FUNC_INITIALIZED = "initialized";

    public static final String FUNC_REMOVEADMIN = "removeAdmin";

    public static final String FUNC_TOTALSUPPLY = "totalSupply";

    public static final String FUNC_INITIALIZE = "initialize";

    public static final String FUNC_TRANSFERFROM = "transferFrom";

    public static final String FUNC_DECIMALS = "decimals";

    public static final String FUNC_UPGRADEIMPLEMENTATION = "upgradeImplementation";

    public static final String FUNC_VESTINGBALANCEOF = "vestingBalanceOf";

    public static final String FUNC_GETSELLPRICE = "getSellPrice";

    public static final String FUNC_ISADMIN = "isAdmin";

    public static final String FUNC_REWARD = "reward";

    public static final String FUNC_ADDADMIN = "addAdmin";

    public static final String FUNC_INITIALIZEACCOUNT = "initializeAccount";

    public static final String FUNC_VERSION = "version";

    public static final String FUNC_TRANSFORMTOVESTED = "transformToVested";

    public static final String FUNC_PAUSED = "paused";

    public static final String FUNC_DISAPPROVEACCOUNT = "disapproveAccount";

    public static final String FUNC_ISINITIALIZEDACCOUNT = "isInitializedAccount";

    public static final String FUNC_UPGRADEDATA = "upgradeData";

    public static final String FUNC_BALANCEOF = "balanceOf";

    public static final String FUNC_PAUSE = "pause";

    public static final String FUNC_OWNER = "owner";

    public static final String FUNC_GETDATAADDRESS = "getDataAddress";

    public static final String FUNC_SYMBOL = "symbol";

    public static final String FUNC_UPGRADEDATAANDIMPLEMENTATION = "upgradeDataAndImplementation";

    public static final String FUNC_TRANSFER = "transfer";

    public static final String FUNC_ISAPPROVEDACCOUNT = "isApprovedAccount";

    public static final String FUNC_GETADMINLEVEL = "getAdminLevel";

    public static final String FUNC_ISPAUSED = "isPaused";

    public static final String FUNC_SETSYMBOL = "setSymbol";

    public static final String FUNC_IMPLEMENTATIONADDRESS = "implementationAddress";

    public static final String FUNC_SETNAME = "setName";

    public static final String FUNC_ALLOWANCE = "allowance";

    public static final String FUNC_REWARDBALANCEOF = "rewardBalanceOf";

    public static final String FUNC_TRANSFEROWNERSHIP = "transferOwnership";

    public static final String FUNC_UNPAUSE = "unPause";

    public static final String FUNC_APPROVEACCOUNT = "approveAccount";

    public static final String FUNC_SETSELLPRICE = "setSellPrice";

    public static final Event VESTING_EVENT = new Event("Vesting", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}, new TypeReference<Uint256>() {}));
    ;

    public static final Event VESTINGTRANSFER_EVENT = new Event("VestingTransfer", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}, new TypeReference<Address>(true) {}, new TypeReference<Uint256>() {}));
    ;

    public static final Event REWARD_EVENT = new Event("Reward", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}, new TypeReference<Address>(true) {}, new TypeReference<Uint256>() {}, new TypeReference<Uint256>() {}));
    ;

    public static final Event INITIALIZATION_EVENT = new Event("Initialization", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}, new TypeReference<Address>(true) {}, new TypeReference<Uint256>() {}, new TypeReference<Uint256>() {}));
    ;

    public static final Event UPGRADED_EVENT = new Event("Upgraded", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Uint16>() {}, new TypeReference<Address>() {}));
    ;

    public static final Event UPGRADEDDATA_EVENT = new Event("UpgradedData", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Uint16>() {}, new TypeReference<Address>() {}));
    ;

    public static final Event TOKENPRICECHANGED_EVENT = new Event("TokenPriceChanged", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
    ;

    public static final Event TRANSACTIONFEE_EVENT = new Event("TransactionFee", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}, new TypeReference<Uint256>() {}, new TypeReference<Uint256>() {}));
    ;

    public static final Event NOSUFFICIENTFUND_EVENT = new Event("NoSufficientFund", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
    ;

    public static final Event DEPOSITRECEIVED_EVENT = new Event("DepositReceived", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}, new TypeReference<Uint256>() {}));
    ;

    public static final Event TRANSFER_EVENT = new Event("Transfer", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}, new TypeReference<Address>(true) {}, new TypeReference<Uint256>() {}));
    ;

    public static final Event APPROVAL_EVENT = new Event("Approval", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}, new TypeReference<Address>(true) {}, new TypeReference<Uint256>() {}));
    ;

    public static final Event APPROVEDACCOUNT_EVENT = new Event("ApprovedAccount", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
    ;

    public static final Event DISAPPROVEDACCOUNT_EVENT = new Event("DisapprovedAccount", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
    ;

    public static final Event CONTRACTPAUSED_EVENT = new Event("ContractPaused", 
            Arrays.<TypeReference<?>>asList());
    ;

    public static final Event CONTRACTUNPAUSED_EVENT = new Event("ContractUnPaused", 
            Arrays.<TypeReference<?>>asList());
    ;

    public static final Event ADDEDADMIN_EVENT = new Event("AddedAdmin", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}, new TypeReference<Uint8>() {}));
    ;

    public static final Event REMOVEDADMIN_EVENT = new Event("RemovedAdmin", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
    ;

    public static final Event TRANSFEROWNERSHIP_EVENT = new Event("TransferOwnership", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
    ;

    @Deprecated
    protected ERTTokenV2(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    protected ERTTokenV2(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, credentials, contractGasProvider);
    }

    @Deprecated
    protected ERTTokenV2(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    protected ERTTokenV2(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public RemoteFunctionCall<String> name() {
        final Function function = new Function(FUNC_NAME, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Utf8String>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<TransactionReceipt> approve(String _spender, BigInteger _value) {
        final Function function = new Function(
                FUNC_APPROVE, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _spender), 
                new org.web3j.abi.datatypes.generated.Uint256(_value)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<Boolean> initialized() {
        final Function function = new Function(FUNC_INITIALIZED, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Bool>() {}));
        return executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<TransactionReceipt> removeAdmin(String _target) {
        final Function function = new Function(
                FUNC_REMOVEADMIN, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _target)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<BigInteger> totalSupply() {
        final Function function = new Function(FUNC_TOTALSUPPLY, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<TransactionReceipt> initialize(BigInteger _initialAmount, String _tokenName, BigInteger _decimalUnits, String _tokenSymbol) {
        final Function function = new Function(
                FUNC_INITIALIZE, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint256(_initialAmount), 
                new org.web3j.abi.datatypes.Utf8String(_tokenName), 
                new org.web3j.abi.datatypes.generated.Uint8(_decimalUnits), 
                new org.web3j.abi.datatypes.Utf8String(_tokenSymbol)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> transferFrom(String _from, String _to, BigInteger _value) {
        final Function function = new Function(
                FUNC_TRANSFERFROM, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _from), 
                new org.web3j.abi.datatypes.Address(160, _to), 
                new org.web3j.abi.datatypes.generated.Uint256(_value)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<BigInteger> decimals() {
        final Function function = new Function(FUNC_DECIMALS, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint8>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<TransactionReceipt> upgradeImplementation(String _proxy, BigInteger _version, String _newImplementation) {
        final Function function = new Function(
                FUNC_UPGRADEIMPLEMENTATION, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _proxy), 
                new org.web3j.abi.datatypes.generated.Uint16(_version), 
                new org.web3j.abi.datatypes.Address(160, _newImplementation)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<BigInteger> vestingBalanceOf(String _target) {
        final Function function = new Function(FUNC_VESTINGBALANCEOF, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _target)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<BigInteger> getSellPrice() {
        final Function function = new Function(FUNC_GETSELLPRICE, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<Boolean> isAdmin(String _target, BigInteger _level) {
        final Function function = new Function(FUNC_ISADMIN, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _target), 
                new org.web3j.abi.datatypes.generated.Uint8(_level)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Bool>() {}));
        return executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<TransactionReceipt> reward(String _to, BigInteger _amount, BigInteger _reward) {
        final Function function = new Function(
                FUNC_REWARD, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _to), 
                new org.web3j.abi.datatypes.generated.Uint256(_amount), 
                new org.web3j.abi.datatypes.generated.Uint256(_reward)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> addAdmin(String _target, BigInteger _level) {
        final Function function = new Function(
                FUNC_ADDADMIN, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _target), 
                new org.web3j.abi.datatypes.generated.Uint8(_level)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> initializeAccount(String _to, BigInteger _tokenAmount, BigInteger weiValue) {
        final Function function = new Function(
                FUNC_INITIALIZEACCOUNT, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _to), 
                new org.web3j.abi.datatypes.generated.Uint256(_tokenAmount)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function, weiValue);
    }

    public RemoteFunctionCall<BigInteger> version() {
        final Function function = new Function(FUNC_VERSION, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint16>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<TransactionReceipt> transformToVested(String _target, BigInteger _value) {
        final Function function = new Function(
                FUNC_TRANSFORMTOVESTED, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _target), 
                new org.web3j.abi.datatypes.generated.Uint256(_value)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<Boolean> paused() {
        final Function function = new Function(FUNC_PAUSED, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Bool>() {}));
        return executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<TransactionReceipt> disapproveAccount(String _target) {
        final Function function = new Function(
                FUNC_DISAPPROVEACCOUNT, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _target)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<Boolean> isInitializedAccount(String _target) {
        final Function function = new Function(FUNC_ISINITIALIZEDACCOUNT, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _target)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Bool>() {}));
        return executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<TransactionReceipt> upgradeData(BigInteger _dataVersion, String _dataAddress) {
        final Function function = new Function(
                FUNC_UPGRADEDATA, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint16(_dataVersion), 
                new org.web3j.abi.datatypes.Address(160, _dataAddress)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<BigInteger> balanceOf(String _target) {
        final Function function = new Function(FUNC_BALANCEOF, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _target)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<TransactionReceipt> pause() {
        final Function function = new Function(
                FUNC_PAUSE, 
                Arrays.<Type>asList(), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<String> owner() {
        final Function function = new Function(FUNC_OWNER, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<String> getDataAddress(BigInteger _version) {
        final Function function = new Function(FUNC_GETDATAADDRESS, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint16(_version)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<String> symbol() {
        final Function function = new Function(FUNC_SYMBOL, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Utf8String>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<TransactionReceipt> upgradeDataAndImplementation(String _proxy, BigInteger _version, String _newImplementation, BigInteger _dataVersion, String _dataAddress) {
        final Function function = new Function(
                FUNC_UPGRADEDATAANDIMPLEMENTATION, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _proxy), 
                new org.web3j.abi.datatypes.generated.Uint16(_version), 
                new org.web3j.abi.datatypes.Address(160, _newImplementation), 
                new org.web3j.abi.datatypes.generated.Uint16(_dataVersion), 
                new org.web3j.abi.datatypes.Address(160, _dataAddress)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> transfer(String _to, BigInteger _value) {
        final Function function = new Function(
                FUNC_TRANSFER, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _to), 
                new org.web3j.abi.datatypes.generated.Uint256(_value)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<Boolean> isApprovedAccount(String _target) {
        final Function function = new Function(FUNC_ISAPPROVEDACCOUNT, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _target)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Bool>() {}));
        return executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<BigInteger> getAdminLevel(String _target) {
        final Function function = new Function(FUNC_GETADMINLEVEL, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _target)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint8>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<Boolean> isPaused() {
        final Function function = new Function(FUNC_ISPAUSED, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Bool>() {}));
        return executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<TransactionReceipt> setSymbol(String _symbol) {
        final Function function = new Function(
                FUNC_SETSYMBOL, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Utf8String(_symbol)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<String> implementationAddress() {
        final Function function = new Function(FUNC_IMPLEMENTATIONADDRESS, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<TransactionReceipt> setName(String _name) {
        final Function function = new Function(
                FUNC_SETNAME, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Utf8String(_name)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<BigInteger> allowance(String _target, String _spender) {
        final Function function = new Function(FUNC_ALLOWANCE, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _target), 
                new org.web3j.abi.datatypes.Address(160, _spender)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<BigInteger> rewardBalanceOf(String _target) {
        final Function function = new Function(FUNC_REWARDBALANCEOF, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _target)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<TransactionReceipt> transferOwnership(String _newOwner) {
        final Function function = new Function(
                FUNC_TRANSFEROWNERSHIP, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _newOwner)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> unPause() {
        final Function function = new Function(
                FUNC_UNPAUSE, 
                Arrays.<Type>asList(), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> approveAccount(String _target) {
        final Function function = new Function(
                FUNC_APPROVEACCOUNT, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _target)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> setSellPrice(BigInteger _value) {
        final Function function = new Function(
                FUNC_SETSELLPRICE, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint256(_value)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public List<VestingEventResponse> getVestingEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(VESTING_EVENT, transactionReceipt);
        ArrayList<VestingEventResponse> responses = new ArrayList<VestingEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            VestingEventResponse typedResponse = new VestingEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse._target = (String) eventValues.getIndexedValues().get(0).getValue();
            typedResponse._tokenAmount = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<VestingEventResponse> vestingEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new io.reactivex.functions.Function<Log, VestingEventResponse>() {
            @Override
            public VestingEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(VESTING_EVENT, log);
                VestingEventResponse typedResponse = new VestingEventResponse();
                typedResponse.log = log;
                typedResponse._target = (String) eventValues.getIndexedValues().get(0).getValue();
                typedResponse._tokenAmount = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<VestingEventResponse> vestingEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(VESTING_EVENT));
        return vestingEventFlowable(filter);
    }

    public List<VestingTransferEventResponse> getVestingTransferEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(VESTINGTRANSFER_EVENT, transactionReceipt);
        ArrayList<VestingTransferEventResponse> responses = new ArrayList<VestingTransferEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            VestingTransferEventResponse typedResponse = new VestingTransferEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse._from = (String) eventValues.getIndexedValues().get(0).getValue();
            typedResponse._to = (String) eventValues.getIndexedValues().get(1).getValue();
            typedResponse._value = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<VestingTransferEventResponse> vestingTransferEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new io.reactivex.functions.Function<Log, VestingTransferEventResponse>() {
            @Override
            public VestingTransferEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(VESTINGTRANSFER_EVENT, log);
                VestingTransferEventResponse typedResponse = new VestingTransferEventResponse();
                typedResponse.log = log;
                typedResponse._from = (String) eventValues.getIndexedValues().get(0).getValue();
                typedResponse._to = (String) eventValues.getIndexedValues().get(1).getValue();
                typedResponse._value = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<VestingTransferEventResponse> vestingTransferEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(VESTINGTRANSFER_EVENT));
        return vestingTransferEventFlowable(filter);
    }

    public List<RewardEventResponse> getRewardEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(REWARD_EVENT, transactionReceipt);
        ArrayList<RewardEventResponse> responses = new ArrayList<RewardEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            RewardEventResponse typedResponse = new RewardEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse._from = (String) eventValues.getIndexedValues().get(0).getValue();
            typedResponse._to = (String) eventValues.getIndexedValues().get(1).getValue();
            typedResponse._tokenAmount = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
            typedResponse._rewardAmount = (BigInteger) eventValues.getNonIndexedValues().get(1).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<RewardEventResponse> rewardEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new io.reactivex.functions.Function<Log, RewardEventResponse>() {
            @Override
            public RewardEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(REWARD_EVENT, log);
                RewardEventResponse typedResponse = new RewardEventResponse();
                typedResponse.log = log;
                typedResponse._from = (String) eventValues.getIndexedValues().get(0).getValue();
                typedResponse._to = (String) eventValues.getIndexedValues().get(1).getValue();
                typedResponse._tokenAmount = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
                typedResponse._rewardAmount = (BigInteger) eventValues.getNonIndexedValues().get(1).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<RewardEventResponse> rewardEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(REWARD_EVENT));
        return rewardEventFlowable(filter);
    }

    public List<InitializationEventResponse> getInitializationEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(INITIALIZATION_EVENT, transactionReceipt);
        ArrayList<InitializationEventResponse> responses = new ArrayList<InitializationEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            InitializationEventResponse typedResponse = new InitializationEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse._from = (String) eventValues.getIndexedValues().get(0).getValue();
            typedResponse._to = (String) eventValues.getIndexedValues().get(1).getValue();
            typedResponse._tokenAmount = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
            typedResponse._etherAmount = (BigInteger) eventValues.getNonIndexedValues().get(1).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<InitializationEventResponse> initializationEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new io.reactivex.functions.Function<Log, InitializationEventResponse>() {
            @Override
            public InitializationEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(INITIALIZATION_EVENT, log);
                InitializationEventResponse typedResponse = new InitializationEventResponse();
                typedResponse.log = log;
                typedResponse._from = (String) eventValues.getIndexedValues().get(0).getValue();
                typedResponse._to = (String) eventValues.getIndexedValues().get(1).getValue();
                typedResponse._tokenAmount = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
                typedResponse._etherAmount = (BigInteger) eventValues.getNonIndexedValues().get(1).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<InitializationEventResponse> initializationEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(INITIALIZATION_EVENT));
        return initializationEventFlowable(filter);
    }

    public List<UpgradedEventResponse> getUpgradedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(UPGRADED_EVENT, transactionReceipt);
        ArrayList<UpgradedEventResponse> responses = new ArrayList<UpgradedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            UpgradedEventResponse typedResponse = new UpgradedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.implementationVersion = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
            typedResponse.implementationAddress = (String) eventValues.getNonIndexedValues().get(1).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<UpgradedEventResponse> upgradedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new io.reactivex.functions.Function<Log, UpgradedEventResponse>() {
            @Override
            public UpgradedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(UPGRADED_EVENT, log);
                UpgradedEventResponse typedResponse = new UpgradedEventResponse();
                typedResponse.log = log;
                typedResponse.implementationVersion = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
                typedResponse.implementationAddress = (String) eventValues.getNonIndexedValues().get(1).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<UpgradedEventResponse> upgradedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(UPGRADED_EVENT));
        return upgradedEventFlowable(filter);
    }

    public List<UpgradedDataEventResponse> getUpgradedDataEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(UPGRADEDDATA_EVENT, transactionReceipt);
        ArrayList<UpgradedDataEventResponse> responses = new ArrayList<UpgradedDataEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            UpgradedDataEventResponse typedResponse = new UpgradedDataEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.dataVersion = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
            typedResponse.dataAddress = (String) eventValues.getNonIndexedValues().get(1).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<UpgradedDataEventResponse> upgradedDataEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new io.reactivex.functions.Function<Log, UpgradedDataEventResponse>() {
            @Override
            public UpgradedDataEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(UPGRADEDDATA_EVENT, log);
                UpgradedDataEventResponse typedResponse = new UpgradedDataEventResponse();
                typedResponse.log = log;
                typedResponse.dataVersion = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
                typedResponse.dataAddress = (String) eventValues.getNonIndexedValues().get(1).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<UpgradedDataEventResponse> upgradedDataEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(UPGRADEDDATA_EVENT));
        return upgradedDataEventFlowable(filter);
    }

    public List<TokenPriceChangedEventResponse> getTokenPriceChangedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(TOKENPRICECHANGED_EVENT, transactionReceipt);
        ArrayList<TokenPriceChangedEventResponse> responses = new ArrayList<TokenPriceChangedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TokenPriceChangedEventResponse typedResponse = new TokenPriceChangedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.tokenPrice = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<TokenPriceChangedEventResponse> tokenPriceChangedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new io.reactivex.functions.Function<Log, TokenPriceChangedEventResponse>() {
            @Override
            public TokenPriceChangedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(TOKENPRICECHANGED_EVENT, log);
                TokenPriceChangedEventResponse typedResponse = new TokenPriceChangedEventResponse();
                typedResponse.log = log;
                typedResponse.tokenPrice = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<TokenPriceChangedEventResponse> tokenPriceChangedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(TOKENPRICECHANGED_EVENT));
        return tokenPriceChangedEventFlowable(filter);
    }

    public List<TransactionFeeEventResponse> getTransactionFeeEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(TRANSACTIONFEE_EVENT, transactionReceipt);
        ArrayList<TransactionFeeEventResponse> responses = new ArrayList<TransactionFeeEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TransactionFeeEventResponse typedResponse = new TransactionFeeEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.from = (String) eventValues.getNonIndexedValues().get(0).getValue();
            typedResponse.tokenFee = (BigInteger) eventValues.getNonIndexedValues().get(1).getValue();
            typedResponse.etherFeeRefund = (BigInteger) eventValues.getNonIndexedValues().get(2).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<TransactionFeeEventResponse> transactionFeeEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new io.reactivex.functions.Function<Log, TransactionFeeEventResponse>() {
            @Override
            public TransactionFeeEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(TRANSACTIONFEE_EVENT, log);
                TransactionFeeEventResponse typedResponse = new TransactionFeeEventResponse();
                typedResponse.log = log;
                typedResponse.from = (String) eventValues.getNonIndexedValues().get(0).getValue();
                typedResponse.tokenFee = (BigInteger) eventValues.getNonIndexedValues().get(1).getValue();
                typedResponse.etherFeeRefund = (BigInteger) eventValues.getNonIndexedValues().get(2).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<TransactionFeeEventResponse> transactionFeeEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(TRANSACTIONFEE_EVENT));
        return transactionFeeEventFlowable(filter);
    }

    public List<NoSufficientFundEventResponse> getNoSufficientFundEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(NOSUFFICIENTFUND_EVENT, transactionReceipt);
        ArrayList<NoSufficientFundEventResponse> responses = new ArrayList<NoSufficientFundEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            NoSufficientFundEventResponse typedResponse = new NoSufficientFundEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.balance = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<NoSufficientFundEventResponse> noSufficientFundEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new io.reactivex.functions.Function<Log, NoSufficientFundEventResponse>() {
            @Override
            public NoSufficientFundEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(NOSUFFICIENTFUND_EVENT, log);
                NoSufficientFundEventResponse typedResponse = new NoSufficientFundEventResponse();
                typedResponse.log = log;
                typedResponse.balance = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<NoSufficientFundEventResponse> noSufficientFundEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(NOSUFFICIENTFUND_EVENT));
        return noSufficientFundEventFlowable(filter);
    }

    public List<DepositReceivedEventResponse> getDepositReceivedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(DEPOSITRECEIVED_EVENT, transactionReceipt);
        ArrayList<DepositReceivedEventResponse> responses = new ArrayList<DepositReceivedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            DepositReceivedEventResponse typedResponse = new DepositReceivedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.from = (String) eventValues.getNonIndexedValues().get(0).getValue();
            typedResponse.amount = (BigInteger) eventValues.getNonIndexedValues().get(1).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<DepositReceivedEventResponse> depositReceivedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new io.reactivex.functions.Function<Log, DepositReceivedEventResponse>() {
            @Override
            public DepositReceivedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(DEPOSITRECEIVED_EVENT, log);
                DepositReceivedEventResponse typedResponse = new DepositReceivedEventResponse();
                typedResponse.log = log;
                typedResponse.from = (String) eventValues.getNonIndexedValues().get(0).getValue();
                typedResponse.amount = (BigInteger) eventValues.getNonIndexedValues().get(1).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<DepositReceivedEventResponse> depositReceivedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(DEPOSITRECEIVED_EVENT));
        return depositReceivedEventFlowable(filter);
    }

    public List<TransferEventResponse> getTransferEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(TRANSFER_EVENT, transactionReceipt);
        ArrayList<TransferEventResponse> responses = new ArrayList<TransferEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TransferEventResponse typedResponse = new TransferEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse._from = (String) eventValues.getIndexedValues().get(0).getValue();
            typedResponse._to = (String) eventValues.getIndexedValues().get(1).getValue();
            typedResponse._value = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<TransferEventResponse> transferEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new io.reactivex.functions.Function<Log, TransferEventResponse>() {
            @Override
            public TransferEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(TRANSFER_EVENT, log);
                TransferEventResponse typedResponse = new TransferEventResponse();
                typedResponse.log = log;
                typedResponse._from = (String) eventValues.getIndexedValues().get(0).getValue();
                typedResponse._to = (String) eventValues.getIndexedValues().get(1).getValue();
                typedResponse._value = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<TransferEventResponse> transferEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(TRANSFER_EVENT));
        return transferEventFlowable(filter);
    }

    public List<ApprovalEventResponse> getApprovalEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(APPROVAL_EVENT, transactionReceipt);
        ArrayList<ApprovalEventResponse> responses = new ArrayList<ApprovalEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ApprovalEventResponse typedResponse = new ApprovalEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse._owner = (String) eventValues.getIndexedValues().get(0).getValue();
            typedResponse._spender = (String) eventValues.getIndexedValues().get(1).getValue();
            typedResponse._value = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<ApprovalEventResponse> approvalEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new io.reactivex.functions.Function<Log, ApprovalEventResponse>() {
            @Override
            public ApprovalEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(APPROVAL_EVENT, log);
                ApprovalEventResponse typedResponse = new ApprovalEventResponse();
                typedResponse.log = log;
                typedResponse._owner = (String) eventValues.getIndexedValues().get(0).getValue();
                typedResponse._spender = (String) eventValues.getIndexedValues().get(1).getValue();
                typedResponse._value = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<ApprovalEventResponse> approvalEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(APPROVAL_EVENT));
        return approvalEventFlowable(filter);
    }

    public List<ApprovedAccountEventResponse> getApprovedAccountEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(APPROVEDACCOUNT_EVENT, transactionReceipt);
        ArrayList<ApprovedAccountEventResponse> responses = new ArrayList<ApprovedAccountEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ApprovedAccountEventResponse typedResponse = new ApprovedAccountEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.target = (String) eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<ApprovedAccountEventResponse> approvedAccountEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new io.reactivex.functions.Function<Log, ApprovedAccountEventResponse>() {
            @Override
            public ApprovedAccountEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(APPROVEDACCOUNT_EVENT, log);
                ApprovedAccountEventResponse typedResponse = new ApprovedAccountEventResponse();
                typedResponse.log = log;
                typedResponse.target = (String) eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<ApprovedAccountEventResponse> approvedAccountEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(APPROVEDACCOUNT_EVENT));
        return approvedAccountEventFlowable(filter);
    }

    public List<DisapprovedAccountEventResponse> getDisapprovedAccountEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(DISAPPROVEDACCOUNT_EVENT, transactionReceipt);
        ArrayList<DisapprovedAccountEventResponse> responses = new ArrayList<DisapprovedAccountEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            DisapprovedAccountEventResponse typedResponse = new DisapprovedAccountEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.target = (String) eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<DisapprovedAccountEventResponse> disapprovedAccountEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new io.reactivex.functions.Function<Log, DisapprovedAccountEventResponse>() {
            @Override
            public DisapprovedAccountEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(DISAPPROVEDACCOUNT_EVENT, log);
                DisapprovedAccountEventResponse typedResponse = new DisapprovedAccountEventResponse();
                typedResponse.log = log;
                typedResponse.target = (String) eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<DisapprovedAccountEventResponse> disapprovedAccountEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(DISAPPROVEDACCOUNT_EVENT));
        return disapprovedAccountEventFlowable(filter);
    }

    public List<ContractPausedEventResponse> getContractPausedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(CONTRACTPAUSED_EVENT, transactionReceipt);
        ArrayList<ContractPausedEventResponse> responses = new ArrayList<ContractPausedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ContractPausedEventResponse typedResponse = new ContractPausedEventResponse();
            typedResponse.log = eventValues.getLog();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<ContractPausedEventResponse> contractPausedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new io.reactivex.functions.Function<Log, ContractPausedEventResponse>() {
            @Override
            public ContractPausedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(CONTRACTPAUSED_EVENT, log);
                ContractPausedEventResponse typedResponse = new ContractPausedEventResponse();
                typedResponse.log = log;
                return typedResponse;
            }
        });
    }

    public Flowable<ContractPausedEventResponse> contractPausedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(CONTRACTPAUSED_EVENT));
        return contractPausedEventFlowable(filter);
    }

    public List<ContractUnPausedEventResponse> getContractUnPausedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(CONTRACTUNPAUSED_EVENT, transactionReceipt);
        ArrayList<ContractUnPausedEventResponse> responses = new ArrayList<ContractUnPausedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ContractUnPausedEventResponse typedResponse = new ContractUnPausedEventResponse();
            typedResponse.log = eventValues.getLog();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<ContractUnPausedEventResponse> contractUnPausedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new io.reactivex.functions.Function<Log, ContractUnPausedEventResponse>() {
            @Override
            public ContractUnPausedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(CONTRACTUNPAUSED_EVENT, log);
                ContractUnPausedEventResponse typedResponse = new ContractUnPausedEventResponse();
                typedResponse.log = log;
                return typedResponse;
            }
        });
    }

    public Flowable<ContractUnPausedEventResponse> contractUnPausedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(CONTRACTUNPAUSED_EVENT));
        return contractUnPausedEventFlowable(filter);
    }

    public List<AddedAdminEventResponse> getAddedAdminEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(ADDEDADMIN_EVENT, transactionReceipt);
        ArrayList<AddedAdminEventResponse> responses = new ArrayList<AddedAdminEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            AddedAdminEventResponse typedResponse = new AddedAdminEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.target = (String) eventValues.getNonIndexedValues().get(0).getValue();
            typedResponse.level = (BigInteger) eventValues.getNonIndexedValues().get(1).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<AddedAdminEventResponse> addedAdminEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new io.reactivex.functions.Function<Log, AddedAdminEventResponse>() {
            @Override
            public AddedAdminEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(ADDEDADMIN_EVENT, log);
                AddedAdminEventResponse typedResponse = new AddedAdminEventResponse();
                typedResponse.log = log;
                typedResponse.target = (String) eventValues.getNonIndexedValues().get(0).getValue();
                typedResponse.level = (BigInteger) eventValues.getNonIndexedValues().get(1).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<AddedAdminEventResponse> addedAdminEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(ADDEDADMIN_EVENT));
        return addedAdminEventFlowable(filter);
    }

    public List<RemovedAdminEventResponse> getRemovedAdminEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(REMOVEDADMIN_EVENT, transactionReceipt);
        ArrayList<RemovedAdminEventResponse> responses = new ArrayList<RemovedAdminEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            RemovedAdminEventResponse typedResponse = new RemovedAdminEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.target = (String) eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<RemovedAdminEventResponse> removedAdminEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new io.reactivex.functions.Function<Log, RemovedAdminEventResponse>() {
            @Override
            public RemovedAdminEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(REMOVEDADMIN_EVENT, log);
                RemovedAdminEventResponse typedResponse = new RemovedAdminEventResponse();
                typedResponse.log = log;
                typedResponse.target = (String) eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<RemovedAdminEventResponse> removedAdminEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(REMOVEDADMIN_EVENT));
        return removedAdminEventFlowable(filter);
    }

    public List<TransferOwnershipEventResponse> getTransferOwnershipEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(TRANSFEROWNERSHIP_EVENT, transactionReceipt);
        ArrayList<TransferOwnershipEventResponse> responses = new ArrayList<TransferOwnershipEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TransferOwnershipEventResponse typedResponse = new TransferOwnershipEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.newOwner = (String) eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<TransferOwnershipEventResponse> transferOwnershipEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new io.reactivex.functions.Function<Log, TransferOwnershipEventResponse>() {
            @Override
            public TransferOwnershipEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(TRANSFEROWNERSHIP_EVENT, log);
                TransferOwnershipEventResponse typedResponse = new TransferOwnershipEventResponse();
                typedResponse.log = log;
                typedResponse.newOwner = (String) eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<TransferOwnershipEventResponse> transferOwnershipEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(TRANSFEROWNERSHIP_EVENT));
        return transferOwnershipEventFlowable(filter);
    }

    @Deprecated
    public static ERTTokenV2 load(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return new ERTTokenV2(contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    @Deprecated
    public static ERTTokenV2 load(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return new ERTTokenV2(contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    public static ERTTokenV2 load(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return new ERTTokenV2(contractAddress, web3j, credentials, contractGasProvider);
    }

    public static ERTTokenV2 load(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return new ERTTokenV2(contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static RemoteCall<ERTTokenV2> deploy(Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return deployRemoteCall(ERTTokenV2.class, web3j, credentials, contractGasProvider, BINARY, "");
    }

    @Deprecated
    public static RemoteCall<ERTTokenV2> deploy(Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return deployRemoteCall(ERTTokenV2.class, web3j, credentials, gasPrice, gasLimit, BINARY, "");
    }

    public static RemoteCall<ERTTokenV2> deploy(Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return deployRemoteCall(ERTTokenV2.class, web3j, transactionManager, contractGasProvider, BINARY, "");
    }

    @Deprecated
    public static RemoteCall<ERTTokenV2> deploy(Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return deployRemoteCall(ERTTokenV2.class, web3j, transactionManager, gasPrice, gasLimit, BINARY, "");
    }

    public static class VestingEventResponse extends BaseEventResponse {
        public String _target;

        public BigInteger _tokenAmount;
    }

    public static class VestingTransferEventResponse extends BaseEventResponse {
        public String _from;

        public String _to;

        public BigInteger _value;
    }

    public static class RewardEventResponse extends BaseEventResponse {
        public String _from;

        public String _to;

        public BigInteger _tokenAmount;

        public BigInteger _rewardAmount;
    }

    public static class InitializationEventResponse extends BaseEventResponse {
        public String _from;

        public String _to;

        public BigInteger _tokenAmount;

        public BigInteger _etherAmount;
    }

    public static class UpgradedEventResponse extends BaseEventResponse {
        public BigInteger implementationVersion;

        public String implementationAddress;
    }

    public static class UpgradedDataEventResponse extends BaseEventResponse {
        public BigInteger dataVersion;

        public String dataAddress;
    }

    public static class TokenPriceChangedEventResponse extends BaseEventResponse {
        public BigInteger tokenPrice;
    }

    public static class TransactionFeeEventResponse extends BaseEventResponse {
        public String from;

        public BigInteger tokenFee;

        public BigInteger etherFeeRefund;
    }

    public static class NoSufficientFundEventResponse extends BaseEventResponse {
        public BigInteger balance;
    }

    public static class DepositReceivedEventResponse extends BaseEventResponse {
        public String from;

        public BigInteger amount;
    }

    public static class TransferEventResponse extends BaseEventResponse {
        public String _from;

        public String _to;

        public BigInteger _value;
    }

    public static class ApprovalEventResponse extends BaseEventResponse {
        public String _owner;

        public String _spender;

        public BigInteger _value;
    }

    public static class ApprovedAccountEventResponse extends BaseEventResponse {
        public String target;
    }

    public static class DisapprovedAccountEventResponse extends BaseEventResponse {
        public String target;
    }

    public static class ContractPausedEventResponse extends BaseEventResponse {
    }

    public static class ContractUnPausedEventResponse extends BaseEventResponse {
    }

    public static class AddedAdminEventResponse extends BaseEventResponse {
        public String target;

        public BigInteger level;
    }

    public static class RemovedAdminEventResponse extends BaseEventResponse {
        public String target;
    }

    public static class TransferOwnershipEventResponse extends BaseEventResponse {
        public String newOwner;
    }
}
